/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai.imagefx;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kr.co.goms.epub.ai.imagefx.Image;

public class ImageFXResultStore {
    private static final ImageFXResultStore INSTANCE = new ImageFXResultStore();
    private final Map<String, List<Path>> store = new ConcurrentHashMap<String, List<Path>>();

    public static ImageFXResultStore getInstance() {
        return INSTANCE;
    }

    public String registerResult(List<Image> images) {
        String id = UUID.randomUUID().toString();
        ArrayList<Path> paths = new ArrayList<Path>();
        Path dir = this.getOrCreateTempDir();
        int idx = 1;
        for (Image img : images) {
            try {
                Path out = dir.resolve("img_" + id.substring(0, 8) + "_" + idx++ + ".png");
                img.save(out.getParent().toString());
                paths.add(this.findLatestIn(dir));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.store.put(id, paths);
        return id;
    }

    public List<Path> getResultPaths(String resultId) {
        if (resultId == null) {
            return List.of();
        }
        return this.store.getOrDefault(resultId, List.of());
    }

    public void disposeResult(String resultId, boolean deleteFiles) {
        List<Path> paths = this.store.remove(resultId);
        if (paths == null) {
            return;
        }
        if (deleteFiles) {
            for (Path p : paths) {
                try {
                    Files.deleteIfExists(p);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Path getOrCreateTempDir() {
        Path dir = Path.of(System.getProperty("java.io.tmpdir"), "goms_aiimagefx_results");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {}
        return dir;
    }

    private Path findLatestIn(Path dir) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> s = Files.list(dir);){
            return s.filter(path -> Files.isRegularFile(path, new LinkOption[0])).max(Comparator.comparingLong(p -> p.toFile().lastModified())).orElseThrow(() -> new IOException("No file saved in " + String.valueOf(dir)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

