/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai.imagefx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import kr.co.goms.epub.ai.imagefx.Constants;
import kr.co.goms.epub.ai.imagefx.PromptArg;
import kr.co.goms.epub.ai.imagefx.PromptError;

public class Prompt {
    private final long seed;
    private final String prompt;
    private final int numberOfImages;
    private final Constants.AspectRatio aspectRatio;
    private final Constants.Model generationModel;

    public Prompt(PromptArg args) {
        if (args == null) {
            throw new PromptError("Prompt arguments cannot be null");
        }
        if (args.prompt == null || args.prompt.trim().isEmpty()) {
            throw new PromptError("Prompt text cannot be empty");
        }
        this.seed = args.seed != null ? args.seed : 0L;
        this.prompt = args.prompt;
        this.numberOfImages = args.numberOfImages != null ? args.numberOfImages : 1;
        this.aspectRatio = args.aspectRatio != null ? args.aspectRatio : Constants.AspectRatio.LANDSCAPE;
        this.generationModel = args.generationModel != null ? args.generationModel : Constants.Model.IMAGEN_3;
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        PromptJson json = new PromptJson();
        json.userInput = new UserInput();
        json.clientContext = new ClientContext();
        json.modelInput = new ModelInput();
        json.userInput.candidatesCount = this.numberOfImages;
        json.userInput.prompts = List.of(this.prompt);
        json.userInput.seed = this.seed;
        json.clientContext.sessionId = ";1757113025397";
        json.clientContext.tool = "IMAGE_FX";
        json.modelInput.modelNameType = this.generationModel.name();
        json.aspectRatio = this.aspectRatio.getValue();
        return gson.toJson((Object)json);
    }

    public long getSeed() {
        return this.seed;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public Constants.AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public Constants.Model getGenerationModel() {
        return this.generationModel;
    }

    private static class ClientContext {
        String sessionId;
        String tool;

        private ClientContext() {
        }
    }

    private static class ModelInput {
        String modelNameType;

        private ModelInput() {
        }
    }

    private static class PromptJson {
        UserInput userInput;
        ClientContext clientContext;
        ModelInput modelInput;
        String aspectRatio;

        private PromptJson() {
        }
    }

    private static class UserInput {
        int candidatesCount;
        List<String> prompts;
        long seed;

        private UserInput() {
        }
    }
}

