/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.builds;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.co.goms.epub.managers.ContentOpfManager;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NavBuilder {
    public static void generateNavFromOpf(File opfFile, File baseDir, File navFile, NavProcessingCallback callback) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document opfDoc = builder.parse(opfFile);
        System.out.println("opfDoc : " + opfDoc.getNodeName());
        System.out.println("navFile : " + navFile.getName());
        HashMap<String, String> idToHrefMap = new HashMap<String, String>();
        HashMap<String, String> idToProps = new HashMap<String, String>();
        NodeList itemList = opfDoc.getElementsByTagName("item");
        int i = 0;
        while (i < itemList.getLength()) {
            Element item = (Element)itemList.item(i);
            String id = item.getAttribute("id");
            String href = item.getAttribute("href");
            String mediaType = item.getAttribute("media-type");
            String props = item.getAttribute("properties");
            idToProps.put(id, props == null ? "" : props);
            if (NavBuilder.isXhtmlMediaType(mediaType)) {
                idToHrefMap.put(id, href);
            }
            ++i;
        }
        ArrayList<String> chapterIds = new ArrayList<String>();
        ArrayList<String> titles = new ArrayList<String>();
        NodeList itemrefList = opfDoc.getElementsByTagName("itemref");
        int i2 = 0;
        while (i2 < itemrefList.getLength()) {
            Element itemref = (Element)itemrefList.item(i2);
            String idref = itemref.getAttribute("idref");
            String props = idToProps.getOrDefault(idref, "");
            if (!props.contains("nav") && !props.contains("cover-image")) {
                String href = (String)idToHrefMap.get(idref);
                if (href == null) {
                    System.out.println("[WARN] spine idref \ub9e4\ud551 \uc2e4\ud328: " + idref);
                } else if (!href.endsWith("cover.xhtml") && !href.endsWith("/cover.xhtml")) {
                    chapterIds.add(NavBuilder.stripExtension(new File(href).getName()));
                    File xhtmlFile = new File(baseDir, href);
                    String title = NavBuilder.extractTitleFromXhtml(xhtmlFile);
                    titles.add(title != null ? title : NavBuilder.stripExtension(new File(href).getName()));
                }
            }
            ++i2;
        }
        NavBuilder.generateNavXhtml(chapterIds, titles, navFile);
        callback.onComplite();
    }

    public static void generateNavXhtml(List<String> chapterIds, List<String> titles, File outputFile) throws Exception {
        if (chapterIds == null || titles == null || chapterIds.size() != titles.size()) {
            throw new IllegalArgumentException("chapterIds\uc640 titles\uc758 \ud06c\uae30\uac00 \uc77c\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.");
        }
        System.out.println("outputFile : " + outputFile.getName());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element html = doc.createElement("html");
        html.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        html.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
        doc.appendChild(html);
        Element head = doc.createElement("head");
        Element title = doc.createElement("title");
        title.setTextContent("\ubaa9\ucc28");
        head.appendChild(title);
        Element link = doc.createElement("link");
        link.setAttribute("rel", "stylesheet");
        link.setAttribute("type", "text/css");
        link.setAttribute("href", "../Styles/nav.css");
        head.appendChild(link);
        html.appendChild(head);
        Element body = doc.createElement("body");
        body.setAttribute("id", "body");
        body.setAttribute("epub:type", "frontmatter");
        Element navToc = doc.createElement("nav");
        navToc.setAttribute("epub:type", "toc");
        navToc.setAttribute("id", "toc");
        navToc.setAttribute("role", "doc-toc");
        Element h1 = doc.createElement("h1");
        h1.setTextContent("\ubaa9\ucc28");
        navToc.appendChild(h1);
        Element ol = doc.createElement("ol");
        int i = 0;
        while (i < chapterIds.size()) {
            String id = chapterIds.get(i);
            String label = titles.get(i);
            Element li = doc.createElement("li");
            Element a = doc.createElement("a");
            a.setAttribute("href", "../Text/" + id + ".xhtml");
            a.setTextContent(label);
            li.appendChild(a);
            ol.appendChild(li);
            ++i;
        }
        navToc.appendChild(ol);
        body.appendChild(navToc);
        Element navLandmarks = doc.createElement("nav");
        navLandmarks.setAttribute("epub:type", "landmarks");
        navLandmarks.setAttribute("id", "landmarks");
        navLandmarks.setAttribute("hidden", "");
        Element h1Landmarks = doc.createElement("h1");
        h1Landmarks.setTextContent("Landmarks");
        navLandmarks.appendChild(h1Landmarks);
        Element olLandmarks = doc.createElement("ol");
        Element liCover = doc.createElement("li");
        Element aCover = doc.createElement("a");
        aCover.setAttribute("epub:type", "cover");
        aCover.setAttribute("href", "../Text/cover.xhtml");
        aCover.setTextContent("Cover");
        liCover.appendChild(aCover);
        olLandmarks.appendChild(liCover);
        navLandmarks.appendChild(olLandmarks);
        body.appendChild(navLandmarks);
        html.appendChild(body);
        NavBuilder.saveNav(doc, outputFile);
    }

    private static void saveNav(Document doc, File file) {
        try {
            Path outputDir = Paths.get(EpubBuildUtil.getProjectFullPath(), "OEBPS", "Text");
            System.out.println("outputDir : " + String.valueOf(outputDir));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String xmlString = writer.toString();
            System.out.println("xmlString : " + xmlString);
            Files.writeString(outputDir.resolve(file.getName()), (CharSequence)xmlString, StandardCharsets.UTF_8, new OpenOption[0]);
            ContentOpfManager.getInstance().updateMenifestAndSpine(file.getName());
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private static String extractTitleFromXhtml(File xhtmlFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xhtmlFile);
        NodeList titleList = doc.getElementsByTagName("title");
        if (titleList.getLength() > 0) {
            return titleList.item(0).getTextContent().trim();
        }
        NodeList h1List = doc.getElementsByTagName("h1");
        if (h1List.getLength() > 0) {
            return h1List.item(0).getTextContent().trim();
        }
        return xhtmlFile.getName();
    }

    private static String stripExtension(String filename) {
        int dot = filename.lastIndexOf(46);
        return dot > 0 ? filename.substring(0, dot) : filename;
    }

    private static boolean isXhtmlMediaType(String mt) {
        if (mt == null) {
            return false;
        }
        String m = mt.trim().toLowerCase(Locale.ROOT);
        return m.equals("application/xhtml+xml") || m.startsWith("application/xhtml+xml;") || m.equals("text/html") || m.startsWith("text/html;");
    }

    public static interface NavProcessingCallback {
        public void onComplite();
    }
}

