/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.highlighter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Display;

public final class Highlighter {
    private final SourceViewer viewer;
    private final String ANN = "kr.co.goms.highlight";
    private final List<Annotation> live = new ArrayList<Annotation>();

    public Highlighter(SourceViewer viewer) {
        this.viewer = viewer;
        IAnnotationAccess access = new IAnnotationAccess(){

            public Object getType(Annotation a) {
                return a.getType();
            }

            public boolean isMultiLine(Annotation a) {
                return true;
            }

            public boolean isTemporary(Annotation a) {
                return false;
            }
        };
        AnnotationPainter painter = new AnnotationPainter((ISourceViewer)viewer, access);
        painter.addHighlightAnnotationType((Object)"kr.co.goms.highlight");
        painter.setAnnotationTypeColor((Object)"kr.co.goms.highlight", Display.getDefault().getSystemColor(7));
        viewer.addPainter((IPainter)painter);
    }

    public void highlightAt(int oneBasedLine, int oneBasedCol, int length, int autoClearMs) {
        if (!this.ready()) {
            return;
        }
        try {
            IDocument doc = this.viewer.getDocument();
            int offset = Highlighter.safeOffset(doc, oneBasedLine, oneBasedCol);
            int len = Math.max(1, Math.min(length, doc.getLength() - offset));
            IAnnotationModel model = this.viewer.getAnnotationModel();
            this.clear(model);
            Annotation ann = new Annotation("kr.co.goms.highlight", false, "epubcheck \uc704\uce58");
            Position pos = new Position(offset, len);
            if (model instanceof IAnnotationModelExtension) {
                IAnnotationModelExtension ext = (IAnnotationModelExtension)model;
                ext.replaceAnnotations(null, Map.of(ann, pos));
            } else {
                model.addAnnotation(ann, pos);
            }
            this.viewer.revealRange(offset, len);
            this.viewer.setSelectedRange(offset, 0);
            if (autoClearMs > 0) {
                Display.getDefault().timerExec(autoClearMs, () -> {
                    if (this.ready()) {
                        this.clear(this.viewer.getAnnotationModel());
                    }
                });
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean ready() {
        return this.viewer != null && this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed() && this.viewer.getDocument() != null && this.viewer.getAnnotationModel() != null;
    }

    private void clear(IAnnotationModel model) {
        if (model == null || this.live.isEmpty()) {
            return;
        }
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ext = (IAnnotationModelExtension)model;
            ext.replaceAnnotations((Annotation[])this.live.toArray(Annotation[]::new), null);
        } else {
            for (Annotation a : this.live) {
                model.removeAnnotation(a);
            }
        }
        this.live.clear();
    }

    private static int safeOffset(IDocument doc, int oneBasedLine, int oneBasedCol) throws BadLocationException {
        int li = Math.max(0, Math.min(oneBasedLine - 1, Math.max(0, doc.getNumberOfLines() - 1)));
        int lineOffset = doc.getLineOffset(li);
        int lineLen = doc.getLineLength(li);
        int col = Math.max(1, oneBasedCol);
        int colOffset = Math.min(col - 1, Math.max(0, lineLen - 1));
        return Math.max(0, Math.min(lineOffset + colOffset, Math.max(0, doc.getLength() - 1)));
    }
}

