/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.managers;

import java.util.ArrayList;
import java.util.List;
import kr.co.goms.epub.menu.ExplorerNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ExplorerNodeManager {
    private static ExplorerNodeManager instance;
    private List<ExplorerNode> nodeList;

    private ExplorerNodeManager() {
    }

    public static ExplorerNodeManager getInstance() {
        if (instance == null) {
            instance = new ExplorerNodeManager();
        }
        return instance;
    }

    public void setNodeList(List<ExplorerNode> nodeList) {
        this.nodeList = nodeList;
    }

    public List<ExplorerNode> createProjectNodeData(String projectName) {
        System.err.println("\u26a0\ufe0f createProjectNodeData : " + projectName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException coreException) {
                System.err.println("\u26a0\ufe0f \uc65c \uc624\ud508\uc774 \uc548\ub3fc");
            }
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            System.err.println("\u26a0\ufe0f \ud504\ub85c\uc81d\ud2b8 \ub9ac\uc18c\uc2a4 \uc0c8\ub85c\uace0\uce68 \uc2e4\ud328: " + e.getMessage());
        }
        this.nodeList = new ArrayList<ExplorerNode>();
        if (project.exists() && project.isOpen()) {
            try {
                IResource[] iResourceArray = project.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource folder = iResourceArray[n2];
                    ExplorerNode node = this.createNodeRecursive(folder, null);
                    if (node != null) {
                        this.nodeList.add(node);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("\u26a0\ufe0f \ud504\ub85c\uc81d\ud2b8\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uac70\ub098 \uc5f4\ub824 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        return this.nodeList;
    }

    private ExplorerNode createNodeRecursive(IResource resource, ExplorerNode parent) {
        if (resource instanceof IFile && resource.getName().equals(".project")) {
            return null;
        }
        if (resource.getName().equals("META-INF")) {
            return null;
        }
        ExplorerNode node = new ExplorerNode();
        node.name = resource.getName();
        node.parent = parent;
        if (resource instanceof IFile) {
            node.isFolder = false;
            node.iFile = (IFile)resource;
        } else if (resource instanceof IContainer) {
            node.isFolder = true;
            node.folder = (IContainer)resource;
            node.children = new ArrayList<ExplorerNode>();
            try {
                IResource[] iResourceArray = ((IContainer)resource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    ExplorerNode childNode = this.createNodeRecursive(child, node);
                    if (childNode != null) {
                        node.children.add(childNode);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    public ExplorerNode getNode(String name) {
        for (ExplorerNode node : this.nodeList) {
            ExplorerNode found = this.findNodeRecursive(node, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private ExplorerNode findNodeRecursive(ExplorerNode node, String name) {
        if (node.name != null && node.name.equals(name)) {
            return node;
        }
        if (node.isFolder() && node.getChildren() != null) {
            for (ExplorerNode child : node.getChildren()) {
                ExplorerNode result = this.findNodeRecursive(child, name);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

