/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.managers;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import kr.co.goms.epub.managers.ContentOpfManager;
import kr.co.goms.epub.pdf.CssColorUpdater;
import kr.co.goms.epub.pdf.PdfFontSizeAnalyzer;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PdfManager {
    private static PdfManager instance;

    private PdfManager() {
    }

    public static PdfManager getInstance() {
        if (instance == null) {
            instance = new PdfManager();
        }
        return instance;
    }

    public void pdfConvert(String pdfFilePath) throws IOException {
        File pdfFile = new File(pdfFilePath);
        PDDocument document = PDDocument.load((File)pdfFile);
        int pageCount = document.getNumberOfPages();
        PDFTextStripper stripper = new PDFTextStripper();
        int page = 1;
        while (page <= pageCount) {
            stripper.setStartPage(page);
            stripper.setEndPage(page);
            String pageText = stripper.getText(document);
            String[] lines = pageText.split("\\r?\\n");
            StringBuilder xhtml = new StringBuilder();
            xhtml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            xhtml.append("<!DOCTYPE html>\n");
            xhtml.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"  xmlns:epub=\"http://www.idpf.org/2007/ops\" xml:lang=\"ko\" lang=\"ko\">\n");
            xhtml.append("<head><title>Chapter ").append(page).append("</title></head>\n");
            xhtml.append("<body>\n");
            xhtml.append("<section epub:type=\"chapter\" role=\"doc-chapter\">");
            int pIndex = 1;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.trim().isEmpty()) {
                    String id = "chapter" + page + "_p_" + pIndex++;
                    xhtml.append("<p id=\"").append(id).append("\">").append(PdfManager.escapeToUnicode(line)).append("</p>\n");
                }
                ++n2;
            }
            xhtml.append("</section>");
            xhtml.append("</body>\n</html>");
            String outputFileName = "chapter" + page + ".xhtml";
            Files.write(Paths.get(outputFileName, new String[0]), xhtml.toString().getBytes("UTF-8"), new OpenOption[0]);
            ++page;
        }
        document.close();
        System.out.println("\ubcc0\ud658 \uc644\ub8cc: \ucd1d " + pageCount + "\uac1c\uc758 chapter.xhtml \ud30c\uc77c \uc0dd\uc131\ub428");
    }

    public void convert(File pdfFile, File outputTextDir, File outputImageDir) throws Exception {
        if (!outputTextDir.exists()) {
            outputTextDir.mkdirs();
        }
        if (!outputImageDir.exists()) {
            outputImageDir.mkdirs();
        }
        PDDocument document = PDDocument.load((File)pdfFile);
        PDFRenderer renderer = new PDFRenderer(document);
        int pageCount = document.getNumberOfPages();
        String bgHexFirst = null;
        final ArrayList<PageItem> allItemsForColor = new ArrayList<PageItem>();
        TreeMap<Float, Integer> sizeHistogram = new TreeMap<Float, Integer>();
        int p2 = 1;
        while (p2 <= document.getNumberOfPages()) {
            for (PdfFontSizeAnalyzer.LineInfo line : PdfFontSizeAnalyzer.extract(document, p2)) {
                float sz = (float)Math.round(line.avgFont() * 2.0f) / 2.0f;
                sizeHistogram.merge(Float.valueOf(sz), 1, Integer::sum);
            }
            ++p2;
        }
        float maxHeadingSize = 100.0f;
        int minClusterCount = 5;
        float mergeTol = 0.6f;
        AutoHeadingRules rules = PdfManager.buildAutoHeadingRules(sizeHistogram, maxHeadingSize, minClusterCount, mergeTol);
        int iPage = 0;
        while (iPage < pageCount) {
            ArrayList<PageItem> items = new ArrayList<PageItem>();
            PDPage currPage = document.getPage(iPage);
            PDResources resources = currPage.getResources();
            if (bgHexFirst == null) {
                BufferedImage bgImage = renderer.renderImageWithDPI(iPage, 150.0f);
                int rgb = bgImage.getRGB(50, 50);
                Color bgColor = new Color(rgb);
                bgHexFirst = PdfManager.rgbToHex(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
            }
            String bgHex = bgHexFirst;
            int imgCount = 1;
            for (COSName name : resources.getXObjectNames()) {
                PDXObject xObject = resources.getXObject(name);
                if (!(xObject instanceof PDImageXObject)) continue;
                PDImageXObject image = (PDImageXObject)xObject;
                BufferedImage bImage = image.getImage();
                String chapterId = PdfManager.getChapterId(iPage);
                String imgId = chapterId + "_img_" + imgCount;
                String imgName = chapterId + "_img_" + imgCount + ".jpg";
                ImageIO.write((RenderedImage)bImage, "JPEG", new File(outputImageDir, imgName));
                ContentOpfManager.getInstance().addImage(imgName);
                items.add(new ImageItem(imgName, imgId, image.getHeight()));
                ++imgCount;
            }
            FontSizeTextStripper stripper = new FontSizeTextStripper(iPage + 1, items){

                @Override
                protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
                    if (textPositions == null || textPositions.isEmpty()) {
                        return;
                    }
                    String colorHex = null;
                    try {
                        PDColor pdColor = this.getGraphicsState().getNonStrokingColor();
                        if (pdColor != null) {
                            int rgb = pdColor.toRGB();
                            Color awt = new Color(rgb, true);
                            colorHex = String.format("#%02x%02x%02x", awt.getRed(), awt.getGreen(), awt.getBlue());
                        }
                    }
                    catch (Exception exception) {}
                    StringBuilder builder = new StringBuilder();
                    TextPosition prev = null;
                    for (TextPosition curr : textPositions) {
                        float spacing;
                        if (prev != null && (spacing = curr.getXDirAdj() - (prev.getXDirAdj() + prev.getWidthDirAdj())) > prev.getFontSizeInPt() * 0.2f) {
                            builder.append(" ");
                        }
                        builder.append(curr.getUnicode());
                        prev = curr;
                    }
                    String cleanText = builder.toString().replaceAll("\\p{Cntrl}", " ").replace("\u00a0", " ").replaceAll(" {2,}", " ").trim();
                    if (!cleanText.isEmpty()) {
                        float avgY = 0.0f;
                        float avgFont = 0.0f;
                        for (TextPosition pos : textPositions) {
                            avgY += pos.getYDirAdj();
                            avgFont += pos.getFontSizeInPt();
                        }
                        TextItem ti = new TextItem(cleanText, avgY /= (float)textPositions.size(), avgFont /= (float)textPositions.size(), colorHex);
                        this.items.add(ti);
                        allItemsForColor.add(ti);
                    }
                }
            };
            stripper.writeText(document, new OutputStreamWriter(OutputStream.nullOutputStream()));
            items.sort(Comparator.comparingDouble(p -> p.y).thenComparing(p -> p instanceof TextItem ? ((TextItem)p).text : ""));
            String chapterId = PdfManager.getChapterId(iPage);
            this.saveAsXhtml(new File(outputTextDir, chapterId + ".xhtml"), items, chapterId, bgHex, iPage, rules);
            ++iPage;
        }
        document.close();
        RepresentativeColors rep = PdfManager.pickRepresentativeColors(allItemsForColor);
        String bg = bgHexFirst;
        String bodyColorFinal = PdfManager.enforceContrastBW(rep.bodyColor, bg, 4.5);
        String headingColorFinal = PdfManager.enforceContrastBW(rep.headingColor, bg, 3.0);
        Path cssPath = outputTextDir.toPath().getParent().resolve("Styles").resolve("style1.css");
        if (Files.exists(cssPath, new LinkOption[0])) {
            CssColorUpdater.updateColors(cssPath, headingColorFinal, bodyColorFinal);
        }
        System.out.println("\u2705 \ubcc0\ud658 \uc644\ub8cc: \ubc30\uacbd\uc0c9(" + bgHexFirst + "), \ud5e4\ub529\uc0c9(" + rep.headingColor + "), \ubcf8\ubb38\uc0c9(" + rep.bodyColor + ") CSS \ubc18\uc601");
        System.out.println("\u2705 \ubcc0\ud658 \uc644\ub8cc: \uc774\ubbf8\uc9c0 \ubc0f \ud14d\uc2a4\ud2b8\uc5d0 \uace0\uc720 ID \ud3ec\ud568\ub428");
    }

    private void saveAsXhtml(File outFile, List<PageItem> items, String idPrefix, String bgColor, int pageIndex, AutoHeadingRules rules) {
        StringBuilder html = new StringBuilder();
        String titleText = null;
        for (PageItem it : items) {
            String t;
            if (!(it instanceof TextItem)) continue;
            TextItem ti = (TextItem)it;
            String tag = PdfManager.tagFor(ti.fontSize, rules);
            if (tag == null || !"h1".equals(tag) && (titleText != null || !"h2".equals(tag))) continue;
            String string = t = ti.text != null ? ti.text.trim() : "";
            if (t.isEmpty()) continue;
            titleText = t;
            if ("h1".equals(tag)) break;
        }
        if (titleText == null || titleText.isBlank()) {
            titleText = idPrefix;
        }
        boolean isCover = false;
        boolean isNav = false;
        boolean isNavLoi = false;
        boolean isNavLot = false;
        boolean isAuthor = false;
        boolean isPrologue = false;
        if (outFile.getPath().contains("nav")) {
            isNav = true;
        }
        if (outFile.getPath().contains("loi")) {
            isNavLoi = true;
        }
        if (outFile.getPath().contains("lot")) {
            isNavLot = true;
        }
        if (outFile.getPath().contains("cover")) {
            isCover = true;
        }
        if (outFile.getPath().contains("author")) {
            isAuthor = true;
        }
        if (outFile.getPath().contains("chapter1")) {
            isPrologue = true;
        }
        html.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<!DOCTYPE html>\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\" xml:lang=\"ko\" lang=\"ko\">\n").append("<head>\n").append("<title>").append(PdfManager.escapeToUnicode(titleText)).append("</title>\n");
        if (isNav) {
            html.append("<link href=\"../Styles/nav.css\" type=\"text/css\" rel=\"stylesheet\"/>\n");
        } else {
            html.append("<link href=\"../Styles/style1.css\" type=\"text/css\" rel=\"stylesheet\"/>\n");
        }
        html.append("</head>\n").append("<body id=\"body\" style=\"background-color: ").append(bgColor).append("; position: relative;\">\n");
        if (!isCover) {
            if (isNav) {
                html.append("<nav epub:type=\"toc\" id=\"toc\" role=\"doc-toc\">\n");
            } else if (isNavLoi) {
                html.append("<nav epub:type=\"loi\" id=\"loi\">\n");
            } else if (isNavLot) {
                html.append("<nav epub:type=\"lot\" id=\"lot\">\n");
            } else if (isAuthor || isPrologue) {
                html.append("<section epub:type=\"preface\" role=\"doc-preface\">\n");
            } else {
                html.append("<section epub:type=\"chapter\" role=\"doc-chapter\">\n");
            }
        }
        int idx = 1;
        for (PageItem item : items) {
            if (item instanceof TextItem) {
                TextItem ti = (TextItem)item;
                String tag = PdfManager.tagFor(ti.fontSize, rules);
                if (tag == null) continue;
                String id = idPrefix + "_" + tag + "_" + idx++;
                html.append("<").append(tag).append(" id=\"").append(id).append("\">").append(PdfManager.escapeToUnicode(ti.text == null ? "" : ti.text)).append("</").append(tag).append(">\n");
                continue;
            }
            if (!(item instanceof ImageItem)) continue;
            ImageItem img = (ImageItem)item;
            html.append("<img role=\"img\" id=\"").append(img.imageId).append("\" src=\"../Images/").append(img.imageFileName).append("\" alt=\"\uc774\ubbf8\uc9c0\" class=\"radius-img\" style=\"width:100%;\"/>\n");
        }
        if (!isCover) {
            if (isNav) {
                html.append("</nav>\n");
            } else {
                html.append("</section>\n");
            }
        }
        html.append("</body>\n");
        html.append("</html>");
        try {
            Files.write(outFile.toPath(), html.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ContentOpfManager.getInstance().updateMenifestAndSpine(outFile.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getChapterId(int pageIndex) {
        return switch (pageIndex) {
            case 0 -> "cover";
            case 1 -> "nav";
            case 2 -> "author";
            default -> "chapter" + (pageIndex - 2);
        };
    }

    public void printFontStats(Path pdf) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PDDocument doc = PDDocument.load((File)pdf.toFile());){
            TreeMap<Float, Integer> sizeHistogram = new TreeMap<Float, Integer>();
            ArrayList<PdfFontSizeAnalyzer.LineInfo> all = new ArrayList<PdfFontSizeAnalyzer.LineInfo>();
            int p = 1;
            while (p <= doc.getNumberOfPages()) {
                all.addAll(PdfFontSizeAnalyzer.extract(doc, p));
                ++p;
            }
            for (PdfFontSizeAnalyzer.LineInfo line : all) {
                float sz = (float)Math.round(line.avgFont() * 2.0f) / 2.0f;
                sizeHistogram.merge(Float.valueOf(sz), 1, Integer::sum);
            }
            System.out.println("=== Font size histogram (avg per line) ===");
            sizeHistogram.forEach((k, v) -> {
                PrintStream printStream = System.out.printf("%.1fpt : %d lines%n", k, v);
            });
            float maxHeadingSize = 100.0f;
            int minClusterCount = 5;
            float mergeTol = 0.6f;
            AutoHeadingRules rules = PdfManager.buildAutoHeadingRules(sizeHistogram, maxHeadingSize, minClusterCount, mergeTol);
            System.out.printf("Estimated body size: %.1fpt%n", Float.valueOf(rules.bodySize));
            System.out.println("=== Auto rules ===");
            System.out.println("h1: " + String.valueOf(rules.h1Buckets));
            System.out.println("h2: " + String.valueOf(rules.h2Buckets));
            System.out.println("h3: " + String.valueOf(rules.h3Buckets));
            System.out.println("h4: " + String.valueOf(rules.h4Buckets));
            System.out.println("=== Heading candidates (size > body) ===");
            all.stream().filter(l -> (float)Math.round(l.avgFont() * 2.0f) / 2.0f > autoHeadingRules.bodySize).filter(l -> l.avgFont() < autoHeadingRules.maxHeadingSize).sorted(Comparator.comparing(PdfFontSizeAnalyzer.LineInfo::avgFont).reversed()).limit(10L).forEach(l -> {
                PrintStream printStream = System.out.printf("[%.1fpt]%s%n", Float.valueOf(l.avgFont()), l.getText().trim());
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String escapeToUnicode(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int cp = s.codePointAt(i);
            i += Character.charCount(cp);
            switch (cp) {
                case 38: {
                    out.append("\\u0026");
                    break;
                }
                case 60: {
                    out.append("\\u003C");
                    break;
                }
                case 62: {
                    out.append("\\u003E");
                    break;
                }
                case 39: {
                    out.append("\u2019");
                    break;
                }
                case 34: {
                    out.append("\u201d");
                    break;
                }
                default: {
                    out.appendCodePoint(cp);
                }
            }
        }
        return out.toString();
    }

    public static String rgbToHex(int r, int g, int b) {
        return String.format("#%02X%02X%02X", r, g, b);
    }

    /*
     * WARNING - void declaration
     */
    private static RepresentativeColors pickRepresentativeColors(List<PageItem> allPagesItems) {
        void var9_19;
        void var9_17;
        ArrayList<Object> texts = new ArrayList<Object>();
        for (PageItem it : allPagesItems) {
            if (!(it instanceof TextItem)) continue;
            TextItem ti = (TextItem)it;
            texts.add(ti);
        }
        if (texts.isEmpty()) {
            return new RepresentativeColors("#ffffff", "#ffffff");
        }
        TreeSet<Float> sizeSetDesc = new TreeSet<Float>((a, b) -> Float.compare(b.floatValue(), a.floatValue()));
        for (TextItem textItem : texts) {
            sizeSetDesc.add(Float.valueOf(PdfManager.bucket(textItem.fontSize <= 0.0f ? 12.0f : textItem.fontSize)));
        }
        ArrayList arrayList = new ArrayList(sizeSetDesc);
        Float minSize = (Float)arrayList.get(arrayList.size() - 1);
        HashMap<Float, Integer> rank = new HashMap<Float, Integer>();
        int i = 0;
        while (i < arrayList.size()) {
            rank.put((Float)arrayList.get(i), i + 1);
            ++i;
        }
        HashMap<String, Integer> headingColorCount = new HashMap<String, Integer>();
        HashMap<String, Integer> bodyColorCount = new HashMap<String, Integer>();
        HashMap<String, Integer> globalColorCount = new HashMap<String, Integer>();
        for (TextItem textItem : texts) {
            if (textItem.colorHex == null) continue;
            globalColorCount.merge(textItem.colorHex, 1, Integer::sum);
            Float bk = Float.valueOf(PdfManager.bucket(textItem.fontSize <= 0.0f ? 12.0f : textItem.fontSize));
            Integer r = (Integer)rank.get(bk);
            if (r == null) continue;
            if (r <= 4) {
                headingColorCount.merge(textItem.colorHex, 1, Integer::sum);
            }
            if (!bk.equals(minSize)) continue;
            bodyColorCount.merge(textItem.colorHex, 1, Integer::sum);
        }
        String string = PdfManager.mostFrequent(headingColorCount);
        String body = PdfManager.mostFrequent(bodyColorCount);
        if (string == null) {
            String string2 = PdfManager.mostFrequent(globalColorCount);
        }
        if (body == null) {
            body = PdfManager.mostFrequent(globalColorCount);
        }
        if (var9_17 == null) {
            String string3 = "#ffffff";
        }
        if (body == null) {
            body = "#ffffff";
        }
        return new RepresentativeColors((String)var9_19, body);
    }

    private static String mostFrequent(Map<String, Integer> counter) {
        return counter.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    private static float bucket(float pt) {
        if (pt <= 0.0f) {
            return 12.0f;
        }
        return (float)Math.round(pt * 10.0f) / 10.0f;
    }

    private static float bucket05(float pt) {
        if (pt <= 0.0f) {
            return 12.0f;
        }
        return (float)Math.round(pt * 2.0f) / 2.0f;
    }

    private static int roundPt(float pt) {
        return Math.round(pt);
    }

    private static boolean isPt(float pt, int targetPt) {
        return PdfManager.roundPt(pt) == targetPt;
    }

    private static boolean approx(float pt, float target, float tol) {
        return Math.abs(pt - target) <= tol;
    }

    private static AutoHeadingRules buildAutoHeadingRules(Map<Float, Integer> sizeHistogram, float maxHeadingSize, int minClusterCount, float clusterMergeTolPt) {
        float bodySize = sizeHistogram.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(Float.valueOf(12.0f)).floatValue();
        AutoHeadingRules rules = new AutoHeadingRules(bodySize, maxHeadingSize);
        List<Float> candidates = sizeHistogram.keySet().stream().filter(sz -> sz.floatValue() > bodySize).filter(sz -> sz.floatValue() < maxHeadingSize).filter(sz -> !PdfManager.approx(sz.floatValue(), 213.0f, 1.0f)).sorted(Comparator.reverseOrder()).toList();
        class Cluster {
            final List<Float> members = new ArrayList<Float>();
            int totalCount = 0;
            float rep = 0.0f;

            Cluster() {
            }
        }
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (Float sz2 : candidates) {
            Cluster c22;
            int cnt = sizeHistogram.getOrDefault(sz2, 0);
            boolean merged = false;
            for (Cluster c22 : clusters) {
                if (!PdfManager.approx(sz2.floatValue(), c22.rep, clusterMergeTolPt) && !c22.members.stream().anyMatch(m -> PdfManager.approx(m.floatValue(), sz2.floatValue(), clusterMergeTolPt))) continue;
                c22.members.add(sz2);
                c22.totalCount += cnt;
                c22.rep = Math.max(c22.rep, sz2.floatValue());
                merged = true;
                break;
            }
            if (merged) continue;
            c22 = new Cluster();
            c22.members.add(sz2);
            c22.totalCount = cnt;
            c22.rep = sz2.floatValue();
            clusters.add(c22);
        }
        clusters.removeIf(c -> c.totalCount < minClusterCount);
        clusters.sort(Comparator.comparingDouble(c -> c.rep).reversed());
        int i = 0;
        while (i < clusters.size()) {
            Set<Float> target;
            if (i == 0) {
                target = rules.h1Buckets;
            } else if (i == 1) {
                target = rules.h2Buckets;
            } else if (i == 2) {
                target = rules.h3Buckets;
            } else {
                if (i != 3) break;
                target = rules.h4Buckets;
            }
            target.addAll(((Cluster)clusters.get((int)i)).members);
            ++i;
        }
        return rules;
    }

    private static String tagFor(float fontSizePt, AutoHeadingRules rules) {
        float fs = fontSizePt <= 0.0f ? 12.0f : fontSizePt;
        float bk = PdfManager.bucket05(fs);
        if (bk >= rules.maxHeadingSize || PdfManager.approx(bk, 213.0f, 1.0f)) {
            return null;
        }
        if (bk <= rules.bodySize) {
            return "p";
        }
        if (rules.h1Buckets.contains(Float.valueOf(bk))) {
            return "h1";
        }
        if (rules.h2Buckets.contains(Float.valueOf(bk))) {
            return "h2";
        }
        if (rules.h3Buckets.contains(Float.valueOf(bk))) {
            return "h3";
        }
        if (rules.h4Buckets.contains(Float.valueOf(bk))) {
            return "h4";
        }
        return "p";
    }

    private static int[] hexToRgb(String hex) {
        hex = hex.startsWith("#") ? hex.substring(1) : hex;
        return new int[]{Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16)};
    }

    private static double relLuminance(String hex) {
        int[] rgb = PdfManager.hexToRgb(hex);
        double Rs = (double)rgb[0] / 255.0;
        double Gs = (double)rgb[1] / 255.0;
        double Bs = (double)rgb[2] / 255.0;
        double R = Rs <= 0.03928 ? Rs / 12.92 : Math.pow((Rs + 0.055) / 1.055, 2.4);
        double G = Gs <= 0.03928 ? Gs / 12.92 : Math.pow((Gs + 0.055) / 1.055, 2.4);
        double B = Bs <= 0.03928 ? Bs / 12.92 : Math.pow((Bs + 0.055) / 1.055, 2.4);
        return 0.2126 * R + 0.7152 * G + 0.0722 * B;
    }

    private static double contrastRatio(String fgHex, String bgHex) {
        double L1 = PdfManager.relLuminance(fgHex);
        double L2 = PdfManager.relLuminance(bgHex);
        double hi = Math.max(L1, L2);
        double lo = Math.min(L1, L2);
        return (hi + 0.05) / (lo + 0.05);
    }

    private static String enforceContrastBW(String candidate, String bgHex, double minRatio) {
        double cWhite;
        if (candidate == null || candidate.length() < 7) {
            return "#000000";
        }
        double base = PdfManager.contrastRatio(candidate, bgHex);
        if (base >= minRatio) {
            return candidate;
        }
        String black = "#000000";
        String white = "#ffffff";
        double cBlack = PdfManager.contrastRatio(black, bgHex);
        return cBlack >= (cWhite = PdfManager.contrastRatio(white, bgHex)) ? black : white;
    }

    private static String getTagForBucket(Float bk, List<Float> sizesDesc, Map<Float, Integer> rankBySize, Float minSize, boolean singleSizeOnly, boolean[] usedH1OnceInSingleSizeRef, String idPrefix, int index) {
        if (bk == null || sizesDesc == null || sizesDesc.isEmpty()) {
            return "p";
        }
        if (singleSizeOnly) {
            if (!usedH1OnceInSingleSizeRef[0]) {
                usedH1OnceInSingleSizeRef[0] = true;
                return "h1";
            }
            return "p";
        }
        if (minSize != null && bk.equals(minSize)) {
            return "p";
        }
        Integer rank = rankBySize.getOrDefault(bk, Integer.MAX_VALUE);
        switch (rank) {
            case 1: {
                return "h1";
            }
            case 2: {
                return "h2";
            }
            case 3: {
                return "h3";
            }
            case 4: {
                return "h4";
            }
        }
        return "p";
    }

    static class AutoHeadingRules {
        final float bodySize;
        final float maxHeadingSize;
        final Set<Float> h1Buckets = new HashSet<Float>();
        final Set<Float> h2Buckets = new HashSet<Float>();
        final Set<Float> h3Buckets = new HashSet<Float>();
        final Set<Float> h4Buckets = new HashSet<Float>();

        AutoHeadingRules(float bodySize, float maxHeadingSize) {
            this.bodySize = bodySize;
            this.maxHeadingSize = maxHeadingSize;
        }
    }

    static class FontSizeTextStripper
    extends PDFTextStripper {
        List<PageItem> items;

        FontSizeTextStripper(int page, List<PageItem> items) throws IOException {
            this.items = items;
            this.setSortByPosition(true);
            this.setStartPage(page);
            this.setEndPage(page);
        }

        protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
            if (textPositions == null || textPositions.isEmpty()) {
                return;
            }
            String colorHex = null;
            PDColor pdColor = this.getGraphicsState().getNonStrokingColor();
            if (pdColor != null) {
                int rgb = pdColor.toRGB();
                Color awt = new Color(rgb, true);
                colorHex = String.format("#%02x%02x%02x", awt.getRed(), awt.getGreen(), awt.getBlue());
            }
            StringBuilder builder = new StringBuilder();
            TextPosition prev = null;
            for (TextPosition curr : textPositions) {
                float spacing;
                if (prev != null && (double)(spacing = curr.getXDirAdj() - (prev.getXDirAdj() + prev.getWidthDirAdj())) > (double)prev.getFontSizeInPt() * 0.2) {
                    builder.append(" ");
                }
                builder.append(curr.getUnicode());
                prev = curr;
            }
            String cleanText = builder.toString().replaceAll("\\p{Cntrl}", " ").replace("\u00a0", " ").replaceAll(" {2,}", " ").trim();
            if (!cleanText.isEmpty()) {
                float avgY = 0.0f;
                float avgFontSize = 0.0f;
                for (TextPosition pos : textPositions) {
                    avgY += pos.getYDirAdj();
                    avgFontSize += pos.getFontSizeInPt();
                }
                this.items.add(new TextItem(cleanText, avgY /= (float)textPositions.size(), avgFontSize /= (float)textPositions.size(), colorHex));
            }
        }
    }

    static class ImageItem
    extends PageItem {
        public final String imageFileName;
        public final String imageId;

        ImageItem(String imageFileName, String imageId, float y) {
            this.imageFileName = imageFileName;
            this.imageId = imageId;
            this.y = y;
        }

        @Override
        String toXHTML(String idPrefix, TagContext ctx) {
            String id = ctx.nextId(idPrefix, "img");
            return "<img id=\"" + id + "\" src=\"../Images/" + this.imageFileName + "\" alt=\"\uc774\ubbf8\uc9c0\" class=\"radius-img\" style=\"width:100%;\"/>";
        }
    }

    static abstract class PageItem {
        float y;

        PageItem() {
        }

        abstract String toXHTML(String var1, TagContext var2);
    }

    private static class RepresentativeColors {
        final String headingColor;
        final String bodyColor;

        RepresentativeColors(String h, String b) {
            this.headingColor = h;
            this.bodyColor = b;
        }
    }

    static class TagContext {
        final Map<Float, Integer> rankBySize;
        final float minBucket;
        final float maxHeadingSize;
        private final Map<String, Integer> counters = new HashMap<String, Integer>();

        TagContext(Map<Float, Integer> rankBySize, float minBucket, float maxHeadingSize) {
            this.rankBySize = rankBySize;
            this.minBucket = minBucket;
            this.maxHeadingSize = maxHeadingSize;
        }

        String nextId(String idPrefix, String tag) {
            int n = this.counters.merge(tag, 1, Integer::sum);
            return idPrefix + "_" + tag + "_" + n;
        }
    }

    static class TextItem
    extends PageItem {
        String text;
        float fontSize;
        String colorHex;

        TextItem(String text, float y, float fontSize, String colorHex) {
            this.text = text;
            this.y = y;
            this.fontSize = fontSize;
            this.colorHex = colorHex;
        }

        private static float bucket(float pt) {
            if (pt <= 0.0f) {
                return 12.0f;
            }
            return (float)Math.round(pt * 10.0f) / 10.0f;
        }

        private static String mapFontSizeToTag(float fontSizePt, TagContext ctx) {
            float fs;
            float f = fs = fontSizePt <= 0.0f ? 12.0f : fontSizePt;
            if (fs >= ctx.maxHeadingSize) {
                return "p";
            }
            Float bk = Float.valueOf(TextItem.bucket(fs));
            if (Float.compare(bk.floatValue(), ctx.minBucket) == 0) {
                return "p";
            }
            Integer rank = ctx.rankBySize.get(bk);
            if (rank == null) {
                return "p";
            }
            switch (rank) {
                case 1: {
                    return "h1";
                }
                case 2: {
                    return "h2";
                }
                case 3: {
                    return "h3";
                }
                case 4: {
                    return "h4";
                }
                case 5: {
                    return "h5";
                }
            }
            return "p";
        }

        @Override
        String toXHTML(String idPrefix, TagContext ctx) {
            String tag = TextItem.mapFontSizeToTag(this.fontSize, ctx);
            String id = ctx.nextId(idPrefix, tag);
            return "<" + tag + " id=\"" + id + "\">" + PdfManager.escapeToUnicode(this.text) + "</" + tag + ">";
        }
    }
}

