/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;

public class ExplorerNode {
    public String name;
    public boolean isFolder;
    public List<ExplorerNode> children;
    public IFile iFile;
    public IContainer folder;
    public ExplorerNode parent;

    public ExplorerNode() {
    }

    public ExplorerNode(String name, List<ExplorerNode> children, IContainer folder) {
        this.name = name;
        this.children = children;
        this.folder = folder;
        this.isFolder = true;
        this.setParentForChildren();
    }

    public ExplorerNode(String name, IFile iFile) {
        this.name = name;
        this.iFile = iFile;
        this.isFolder = false;
    }

    public ExplorerNode(String name) {
        this.name = name;
        this.isFolder = false;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public IFile getIFile() {
        return this.iFile;
    }

    public void addChild(ExplorerNode child) {
        if (this.children == null) {
            this.children = new ArrayList<ExplorerNode>();
        }
        child.setParent(this);
        this.children.add(child);
    }

    private void setParentForChildren() {
        if (this.children != null) {
            for (ExplorerNode child : this.children) {
                child.setParent(this);
            }
        }
    }

    public ExplorerNode getParent() {
        return this.parent;
    }

    public void setParent(ExplorerNode parent) {
        this.parent = parent;
    }

    public List<ExplorerNode> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    public IContainer getContainer() {
        return this.folder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplorerNode other = (ExplorerNode)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

