/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.smil;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javazoom.jl.player.Player;
import kr.co.goms.epub.smil.NarrationItem;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmilNarrationPlayer {
    private List<NarrationItem> items = new ArrayList<NarrationItem>();

    public void loadSmil(File smilFile) throws Exception {
        this.items.clear();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(smilFile);
        NodeList parList = doc.getElementsByTagName("par");
        int i = 0;
        while (i < parList.getLength()) {
            Element par = (Element)parList.item(i);
            String textId = null;
            String audioSrc = null;
            float clipBegin = 0.0f;
            float clipEnd = 0.0f;
            NodeList children = par.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node node = children.item(j);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    if ("text".equals(element.getTagName())) {
                        textId = element.getAttribute("src");
                    } else if ("audio".equals(element.getTagName())) {
                        audioSrc = element.getAttribute("src");
                        clipBegin = this.parseTime(element.getAttribute("clipBegin"));
                        clipEnd = this.parseTime(element.getAttribute("clipEnd"));
                    }
                }
                ++j;
            }
            if (audioSrc != null) {
                this.items.add(new NarrationItem(textId, audioSrc, clipBegin, clipEnd));
            }
            ++i;
        }
    }

    private float parseTime(String timeStr) {
        try {
            String[] parts = timeStr.split(":");
            float seconds = 0.0f;
            if (parts.length == 3) {
                seconds += (float)(Integer.parseInt(parts[0]) * 3600);
                seconds += (float)(Integer.parseInt(parts[1]) * 60);
                seconds += Float.parseFloat(parts[2]);
            }
            return seconds;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void playNarration(List<NarrationItem> items) {
        new Thread(() -> {
            for (NarrationItem item : items) {
                try {
                    File audioFile = new File(EpubBuildUtil.getProjectAudioPath() + "/" + item.audioPath());
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileInputStream is = new FileInputStream(audioFile);){
                        Player player = new Player((InputStream)is);
                        player.play();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    Thread.sleep((long)((item.clipEnd() - item.clipBegin()) * 1000.0f));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public List<NarrationItem> getItems() {
        return this.items;
    }
}

