/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.accessibility;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kr.co.goms.epub.solution.accessibility.HeadingIssue;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AccessibilityHeadingChecker {
    public static List<HeadingIssue> checkDirectory(File textDir) throws Exception {
        ArrayList<HeadingIssue> all = new ArrayList<HeadingIssue>();
        File[] files = textDir.listFiles((dir, name) -> name.endsWith(".xhtml") || name.endsWith(".html"));
        if (files == null) {
            return all;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            all.addAll(AccessibilityHeadingChecker.checkFile(f));
            ++n2;
        }
        return all;
    }

    public static List<HeadingIssue> checkFile(File file) throws Exception {
        ArrayList<HeadingIssue> result = new ArrayList<HeadingIssue>();
        Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
        Element title = doc.selectFirst("head > title");
        if (title == null) {
            result.add(new HeadingIssue(file, HeadingIssue.IssueType.TITLE_MISSING, "<title> \ud0dc\uadf8 \uc5c6\uc74c", "title", "", -1));
        } else if (title.text().trim().isEmpty()) {
            result.add(new HeadingIssue(file, HeadingIssue.IssueType.TITLE_EMPTY, "<title> \ub0b4\uc6a9 \ube44\uc5b4 \uc788\uc74c", "title", "", -1));
        }
        Elements headings = doc.select("h1, h2, h3, h4, h5");
        if (headings.isEmpty()) {
            result.add(new HeadingIssue(file, HeadingIssue.IssueType.HEADING_MISSING, "H1~H5 Heading\uc774 \ud558\ub098\ub3c4 \uc5c6\uc2b5\ub2c8\ub2e4.", "", "", -1));
            return result;
        }
        int prevLevel = 0;
        int h1Count = 0;
        int i = 0;
        while (i < headings.size()) {
            Element h = (Element)headings.get(i);
            String tag = h.tagName();
            int level = Integer.parseInt(tag.substring(1));
            String text = h.text().trim();
            if ("h1".equals(tag)) {
                ++h1Count;
            }
            if (text.isEmpty()) {
                result.add(new HeadingIssue(file, HeadingIssue.IssueType.HEADING_EMPTY, "Heading \ub0b4\uc6a9\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.", tag, "", i));
            }
            if (prevLevel > 0 && level > prevLevel + 1) {
                String msg = String.format("Heading \ub808\ubca8 \uc810\ud504: \uc774\uc804 H%d \u2192 \ud604\uc7ac H%d", prevLevel, level);
                result.add(new HeadingIssue(file, HeadingIssue.IssueType.HEADING_LEVEL_JUMP, msg, tag, text, i));
            }
            prevLevel = level;
            ++i;
        }
        if (h1Count == 0) {
            result.add(new HeadingIssue(file, HeadingIssue.IssueType.H1_COUNT_ZERO, "H1\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. (\uc804\ub7b5\uc5d0 \ub530\ub77c \ud5c8\uc6a9 \uac00\ub2a5\ud558\uc9c0\ub9cc \uad8c\uc7a5\ub418\uc9c0 \uc54a\uc74c)", "h1", "", -1));
        } else if (h1Count > 1) {
            String msg = "H1\uc774 " + h1Count + "\uac1c\uc785\ub2c8\ub2e4. \uac00\ub2a5\ud558\uba74 1\uac1c\ub85c \uc81c\ud55c\ud558\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4.";
            result.add(new HeadingIssue(file, HeadingIssue.IssueType.H1_COUNT_OVER, msg, "h1", "", -1));
        }
        return result;
    }
}

