/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.accessibility;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.co.goms.epub.solution.accessibility.MetaDef;
import kr.co.goms.epub.solution.accessibility.MetaRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccessibilityMetaUtil {
    public static List<MetaRow> loadFromOpf(File opfFile) throws Exception {
        ArrayList<MetaRow> rows = new ArrayList<MetaRow>();
        List<MetaDef> defs = MetaDef.getDefaults();
        HashMap<String, MetaDef> defByProp = new HashMap<String, MetaDef>();
        for (MetaDef def : defs) {
            defByProp.put(def.getProperty(), def);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(opfFile);
        Element metadataEl = AccessibilityMetaUtil.findMetadataElement(doc);
        if (metadataEl == null) {
            return rows;
        }
        NodeList metaNodes = metadataEl.getElementsByTagName("meta");
        HashMap<String, Boolean> defPresent = new HashMap<String, Boolean>();
        for (MetaDef def : defs) {
            defPresent.put(def.getProperty(), false);
        }
        int i = 0;
        while (i < metaNodes.getLength()) {
            Element m = (Element)metaNodes.item(i);
            String prop = m.getAttribute("property");
            if (prop != null && !prop.isEmpty() && prop.startsWith("schema:")) {
                MetaDef def;
                String value = "";
                value = m.hasAttribute("content") ? m.getAttribute("content") : m.getTextContent();
                if (value != null) {
                    value = value.trim();
                }
                if ((def = (MetaDef)defByProp.get(prop)) == null) {
                    def = new MetaDef(prop, prop, false, "");
                    defByProp.put(prop, def);
                } else {
                    defPresent.put(prop, true);
                }
                rows.add(new MetaRow(def, value, true));
            }
            ++i;
        }
        for (MetaDef def : defs) {
            if (((Boolean)defPresent.get(def.getProperty())).booleanValue()) continue;
            rows.add(new MetaRow(def, "", false));
        }
        return rows;
    }

    public static void saveToOpf(File opfFile, List<MetaRow> rows) throws Exception {
        String prop;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(opfFile);
        Element metadataEl = AccessibilityMetaUtil.findMetadataElement(doc);
        if (metadataEl == null) {
            Element pkg = (Element)doc.getElementsByTagName("package").item(0);
            metadataEl = doc.createElement("metadata");
            pkg.insertBefore(metadataEl, pkg.getFirstChild());
        }
        HashMap<String, Object> firstMetaByProp = new HashMap<String, Object>();
        NodeList metaNodes = metadataEl.getElementsByTagName("meta");
        int i = 0;
        while (i < metaNodes.getLength()) {
            Element m = (Element)metaNodes.item(i);
            prop = m.getAttribute("property");
            if (!prop.isEmpty() && !firstMetaByProp.containsKey(prop)) {
                firstMetaByProp.put(prop, m);
            }
            ++i;
        }
        for (MetaRow row : rows) {
            prop = row.getProperty();
            String value = row.getValue() != null ? row.getValue().trim() : "";
            Element metaEl = (Element)firstMetaByProp.get(prop);
            if (metaEl == null) {
                if (value.isEmpty()) continue;
                metaEl = doc.createElement("meta");
                metaEl.setAttribute("property", prop);
                metaEl.setTextContent(value);
                metadataEl.appendChild(metaEl);
                continue;
            }
            metaEl.setTextContent(value);
        }
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tf.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        tf.transform(source, result);
        String xml = out.toString("UTF-8");
        String cleaned = xml.replaceAll("(?m)^\\s*$[\n\r]{1,}", "");
        Throwable throwable = null;
        Object var14_17 = null;
        try (FileOutputStream fos = new FileOutputStream(opfFile);){
            ((OutputStream)fos).write(cleaned.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Element findMetadataElement(Document doc) {
        NodeList nl = doc.getElementsByTagName("metadata");
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public static void autoApplyRequiredDefaults(List<MetaRow> rows) {
        for (MetaRow row : rows) {
            String defVal;
            String v;
            if (!row.isRequired() || (v = row.getValue()) != null && !v.trim().isEmpty() || (defVal = row.getDef().getDefaultValue()) == null || defVal.isEmpty()) continue;
            row.setValue(defVal);
        }
    }
}

