/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.accessibility;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kr.co.goms.epub.solution.accessibility.HeadingRow;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HeadingCollectUtil {
    public static List<HeadingRow> collectFromDirectory(File textDir) throws Exception {
        ArrayList<HeadingRow> rows = new ArrayList<HeadingRow>();
        File[] files = textDir.listFiles((dir, name) -> name.endsWith(".xhtml") || name.endsWith(".html"));
        if (files == null) {
            return rows;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            rows.addAll(HeadingCollectUtil.collectFromFile(f));
            ++n2;
        }
        return rows;
    }

    public static List<HeadingRow> collectFromFile(File file) throws Exception {
        ArrayList<HeadingRow> rows = new ArrayList<HeadingRow>();
        Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
        Elements titles = doc.select("head > title");
        if (titles.isEmpty()) {
            rows.add(new HeadingRow(file, HeadingRow.RowType.TITLE, "title", -1, ""));
        } else {
            Element t = titles.first();
            String text = t.text();
            rows.add(new HeadingRow(file, HeadingRow.RowType.TITLE, "title", 0, text));
        }
        Elements headings = doc.select("h1, h2, h3, h4, h5");
        int i = 0;
        while (i < headings.size()) {
            Element h = (Element)headings.get(i);
            String tag = h.tagName();
            String text = h.text();
            rows.add(new HeadingRow(file, HeadingRow.RowType.HEADING, tag, i, text));
            ++i;
        }
        return rows;
    }
}

