/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.accessibility;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kr.co.goms.epub.solution.accessibility.HeadingRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NavXhtmlSync {
    public static void syncInTocFromNav(Path navPath, List<HeadingRow> rows) throws Exception {
        File navFile = navPath.toFile();
        if (!navFile.exists()) {
            for (HeadingRow row : rows) {
                row.setInToc(false);
            }
            return;
        }
        Set<String> navHrefSet = NavXhtmlSync.collectTocHrefs(navFile);
        for (HeadingRow row : rows) {
            String href = NavXhtmlSync.buildHrefForRow(row);
            String norm = NavXhtmlSync.normalizeHref(href);
            boolean inNav = navHrefSet.contains(norm);
            row.setInToc(inNav);
        }
    }

    private static Set<String> collectTocHrefs(File navFile) throws Exception {
        HashSet<String> result = new HashSet<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(navFile);
        NodeList navNodes = doc.getElementsByTagName("nav");
        int i = 0;
        while (i < navNodes.getLength()) {
            Element navEl = (Element)navNodes.item(i);
            String epubType = navEl.getAttribute("epub:type");
            if ("toc".equals(epubType)) {
                NodeList anchorNodes = navEl.getElementsByTagName("a");
                int j = 0;
                while (j < anchorNodes.getLength()) {
                    Element a = (Element)anchorNodes.item(j);
                    String href = a.getAttribute("href");
                    if (!(href != null && href.contains("nav.xhtml") || href == null || href.isEmpty())) {
                        String norm = NavXhtmlSync.normalizeHref(href);
                        result.add(norm);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private static String buildHrefForRow(HeadingRow row) {
        if (row.getFile() == null) {
            return "";
        }
        String fileName = row.getFile().getName();
        String href = "../Text/" + fileName;
        if ("title".equalsIgnoreCase(row.getTagName())) {
            return href;
        }
        if (row.getTagName() != null && row.getTagName().matches("h[1-5]")) {
            href = href + "#" + row.getTagName() + "_" + row.getIndex();
        }
        return href;
    }

    private static String normalizeHref(String href) {
        if (href == null) {
            return "";
        }
        href = href.trim();
        if ((href = href.replace("\\", "/")).startsWith("../Text/")) {
            href = href.substring("../Text/".length());
        } else if (href.startsWith("./Text/")) {
            href = href.substring("./Text/".length());
        } else if (href.startsWith("Text/")) {
            href = href.substring("Text/".length());
        }
        return href;
    }
}

