/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.accessibility;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import kr.co.goms.epub.solution.accessibility.HeadingRow;
import kr.co.goms.epub.solution.accessibility.ImageRow;
import kr.co.goms.epub.solution.accessibility.TableRow;

public class NavXhtmlWriter {
    public static void writeNav(Path navPath, List<HeadingRow> rows, Comparator<HeadingRow> comparator) throws IOException {
        List<HeadingRow> tocRows = rows.stream().filter(HeadingRow::isInToc).filter(r -> r.getFile() != null).sorted(comparator).toList();
        String navXhtml = NavXhtmlWriter.buildNavXhtml(tocRows);
        Files.createDirectories(navPath.getParent(), new FileAttribute[0]);
        Files.writeString(navPath, (CharSequence)navXhtml, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void writeLoi(Path loiPath, List<ImageRow> rows, Comparator<ImageRow> comparator) throws IOException {
        List<ImageRow> imageRows = rows.stream().filter(r -> r.getFile() != null).sorted(comparator).toList();
        String loiXhtml = NavXhtmlWriter.buildLoiXhtml(imageRows);
        Files.createDirectories(loiPath.getParent(), new FileAttribute[0]);
        Files.writeString(loiPath, (CharSequence)loiXhtml, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void writeLot(Path loiPath, List<TableRow> rows, Comparator<TableRow> comparator) throws IOException {
        List<TableRow> tableRows = rows.stream().filter(r -> r.getFile() != null).sorted(comparator).toList();
        String loiXhtml = NavXhtmlWriter.buildLotXhtml(tableRows);
        Files.createDirectories(loiPath.getParent(), new FileAttribute[0]);
        Files.writeString(loiPath, (CharSequence)loiXhtml, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String buildNavXhtml(List<HeadingRow> tocRows) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" ").append("xmlns:epub=\"http://www.idpf.org/2007/ops\" ").append("lang=\"ko\" xml:lang=\"ko\">\n");
        sb.append("\t<head>\n");
        sb.append("\t\t<title>Table of Contents</title>\n");
        sb.append("\t\t<link href=\"../Styles/nav.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
        sb.append("\t</head>\n");
        sb.append("\t<body id=\"body\">\n");
        sb.append("\t\t<nav epub:type=\"toc\" id=\"toc\" role=\"doc-toc\">\n");
        sb.append("\t\t\t<h1 id=\"nav_h1_1\">\n");
        sb.append("\t\t\t\t<a href=\"../Text/nav.xhtml\">Table of Contents</a>\n");
        sb.append("\t\t\t</h1>\n");
        sb.append("\t\t\t<ol>\n");
        NavXhtmlWriter.appendLiItems(sb, tocRows);
        sb.append("\t\t\t</ol>\n");
        sb.append("\t\t</nav>\n");
        sb.append("\t\t<nav epub:type=\"landmarks\" hidden=\"\" id=\"landmarks\">\n");
        sb.append("\t\t\t<h1>Landmarks</h1>\n");
        sb.append("\t\t\t<ol>\n");
        sb.append("\t\t\t\t<li>\n");
        sb.append("\t\t\t\t\t<a epub:type=\"cover\" href=\"../Text/cover.xhtml\">Cover</a>\n");
        sb.append("\t\t\t\t</li>\n");
        sb.append("\t\t\t</ol>\n");
        sb.append("\t\t</nav>\n");
        sb.append("\t</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    private static String buildLoiXhtml(List<ImageRow> rows) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" ").append("xmlns:epub=\"http://www.idpf.org/2007/ops\" ").append("lang=\"ko\" xml:lang=\"ko\">\n");
        sb.append("\t<head>\n");
        sb.append("\t\t<title>\uc774\ubbf8\uc9c0 \ubaa9\ucc28</title>\n");
        sb.append("\t\t<link href=\"../Styles/nav.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
        sb.append("\t</head>\n");
        sb.append("\t<body id=\"body\">\n");
        sb.append("\t\t<nav epub:type=\"loi\" id=\"loi\" role=\"doc-toc\">\n");
        sb.append("\t\t\t<h1 id=\"loi_00001\" class=\"loi_toc\">\uc774\ubbf8\uc9c0 \ubaa9\ucc28</h1>\n");
        sb.append("\t\t\t<ol>\n");
        NavXhtmlWriter.appendImageLiItems(sb, rows);
        sb.append("\t\t\t</ol>\n");
        sb.append("\t\t</nav>\n");
        sb.append("\t</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    private static String buildLotXhtml(List<TableRow> rows) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" ").append("xmlns:epub=\"http://www.idpf.org/2007/ops\" ").append("lang=\"ko\" xml:lang=\"ko\">\n");
        sb.append("\t<head>\n");
        sb.append("\t\t<title>\ud45c \ubaa9\ucc28</title>\n");
        sb.append("\t\t<link href=\"../Styles/nav.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
        sb.append("\t</head>\n");
        sb.append("\t<body id=\"body\">\n");
        sb.append("\t\t<nav epub:type=\"lot\" id=\"lot\" role=\"doc-toc\">\n");
        sb.append("\t\t\t<h1 id=\"lot_00001\" class=\"lot_toc\">\ud45c \ubaa9\ucc28</h1>\n");
        sb.append("\t\t\t<ol>\n");
        NavXhtmlWriter.appendTableLiItems(sb, rows);
        sb.append("\t\t\t</ol>\n");
        sb.append("\t\t</nav>\n");
        sb.append("\t</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    private static void appendLiItems(StringBuilder sb, List<HeadingRow> tocRows) {
        int liIndex = 2;
        for (HeadingRow row : tocRows) {
            String fileName = row.getFile().getName();
            String text = NavXhtmlWriter.escapeXml(row.getText());
            String id = "nav_li_" + liIndex++;
            String href = "../Text/" + fileName;
            if (row.getTagName() != null && row.getTagName().matches("h[1-5]")) {
                href = href + "#" + row.getTagName() + "_" + row.getIndex();
            }
            sb.append("\t\t\t\t<li id=\"").append(id).append("\">\n");
            sb.append("\t\t\t\t\t<a href=\"").append(NavXhtmlWriter.escapeAttr(href)).append("\">").append(text).append("</a>\n");
            sb.append("\t\t\t\t</li>\n");
        }
    }

    private static void appendImageLiItems(StringBuilder sb, List<ImageRow> rows) {
        for (ImageRow row : rows) {
            String fileName = row.getFile().getName();
            String imgId = row.getImgId();
            String altText = row.getAlt();
            if (altText == null || altText.trim().isEmpty()) {
                altText = imgId;
            }
            if ("cover".equals(imgId)) {
                altText = "\ud45c\uc9c0";
            }
            sb.append("\t\t\t\t<li>\n");
            sb.append("\t\t\t\t\t<a href=\"../Text/").append(fileName).append("#").append(imgId).append("\">").append(NavXhtmlWriter.escapeXml(altText)).append("</a>\n");
            sb.append("\t\t\t\t\t</li>\n");
        }
    }

    private static void appendTableLiItems(StringBuilder sb, List<TableRow> rows) {
        for (TableRow row : rows) {
            String fileName = row.getFile().getName();
            String id = row.getId();
            String caption = row.getCaption();
            if (caption == null || caption.trim().isEmpty()) {
                caption = id;
            }
            sb.append("\t\t\t\t<li>\n");
            sb.append("\t\t\t\t\t<a href=\"../Text/").append(fileName).append("#").append(id).append("\">").append(NavXhtmlWriter.escapeXml(caption)).append("</a>\n");
            sb.append("\t\t\t\t\t</li>\n");
        }
    }

    private static String escapeXml(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String escapeAttr(String s) {
        if (s == null) {
            return "";
        }
        return NavXhtmlWriter.escapeXml(s).replace("\"", "&quot;");
    }
}

