/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.accessibility;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kr.co.goms.epub.solution.accessibility.ImageRow;
import kr.co.goms.epub.solution.accessibility.TableRow;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ObjectCollectUtil {
    public static List<ImageRow> collectImageFromDirectory(File textDir) throws Exception {
        ArrayList<ImageRow> rows = new ArrayList<ImageRow>();
        File[] files = textDir.listFiles((dir, name) -> name.endsWith(".xhtml") || name.endsWith(".html"));
        if (files == null) {
            return rows;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            rows.addAll(ObjectCollectUtil.collectImageFromFile(f));
            ++n2;
        }
        return rows;
    }

    public static List<TableRow> collectTableFromDirectory(File textDir) throws Exception {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        File[] files = textDir.listFiles((dir, name) -> name.endsWith(".xhtml") || name.endsWith(".html"));
        if (files == null) {
            return rows;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            rows.addAll(ObjectCollectUtil.collectTableFromFile(f));
            ++n2;
        }
        return rows;
    }

    public static List<ImageRow> collectImageFromFile(File file) throws Exception {
        ArrayList<ImageRow> rows = new ArrayList<ImageRow>();
        Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
        Elements imgs = doc.select("img");
        int i = 0;
        while (i < imgs.size()) {
            int dotIdx;
            String src;
            Element img = (Element)imgs.get(i);
            String imgId = src = img.attr("src");
            int lastSlash = src.lastIndexOf(47);
            if (lastSlash != -1) {
                imgId = src.substring(lastSlash + 1);
            }
            if ((dotIdx = imgId.lastIndexOf(46)) != -1) {
                imgId = imgId.substring(0, dotIdx);
            }
            String alt = img.hasAttr("alt") ? img.attr("alt") : "";
            String role = img.hasAttr("role") ? img.attr("role") : "";
            String ariaHidden = img.hasAttr("aria-hidden") ? img.attr("aria-hidden") : "";
            ImageRow row = new ImageRow(file, i, src, imgId, alt, role, ariaHidden);
            rows.add(row);
            ++i;
        }
        return rows;
    }

    public static List<TableRow> collectTableFromFile(File file) throws Exception {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
        Elements tables = doc.select("table");
        int i = 0;
        while (i < tables.size()) {
            Element tbl = (Element)tables.get(i);
            String id = tbl.hasAttr("id") ? tbl.attr("id") : "";
            String className = tbl.hasAttr("class") ? tbl.attr("class") : "";
            String style = tbl.hasAttr("style") ? tbl.attr("style") : "";
            String captionText = "";
            Element captionEl = tbl.selectFirst("caption");
            if (captionEl != null) {
                captionText = captionEl.text();
            }
            TableRow row = new TableRow(file, id, className, captionText, style);
            rows.add(row);
            ++i;
        }
        return rows;
    }
}

