/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import java.io.IOException;
import java.net.URL;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class AboutDialog
extends Dialog {
    Image logoImage;

    public AboutDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.getShell().setBackground(Display.getDefault().getSystemColor(1));
        try {
            Bundle bundle = Platform.getBundle((String)"epubtest03");
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/gomsbook_16.png"), null);
            URL fileUrl = null;
            try {
                fileUrl = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Image dialogIconImage = new Image((Device)Display.getDefault(), fileUrl.getPath());
            this.getShell().setImage(dialogIconImage);
            this.getShell().setText("GomsBook Editor");
            this.getShell().addListener(12, event -> {
                if (dialogIconImage != null && !dialogIconImage.isDisposed()) {
                    dialogIconImage.dispose();
                }
            });
        }
        catch (NullPointerException e) {
            System.out.println("e : " + e.toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Color white = Display.getDefault().getSystemColor(1);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setBackground(white);
        container.setLayout((Layout)new GridLayout(1, false));
        String projectName = EpubBuildUtil.getProjectName();
        Bundle bundle = Platform.getBundle((String)projectName);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/256x256_32bit.bmp"), null);
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logoImage = new Image((Device)Display.getDefault(), fileUrl.getPath());
        Label logoLabel = new Label(container, 0);
        logoLabel.setImage(this.logoImage);
        logoLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Label titleLabel = new Label(container, 0);
        titleLabel.setText("GomsBook Editor");
        titleLabel.setFont(parent.getDisplay().getSystemFont());
        titleLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        titleLabel.setBackground(white);
        Label versionLabel = new Label(container, 64);
        versionLabel.setText("Version: 2025-06\nEclipse Rich Client Platform based application.\n");
        versionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        versionLabel.setBackground(white);
        Label spacer = new Label(container, 0);
        GridData spacerData = new GridData(4, 4, true, true);
        spacer.setBackground(white);
        spacer.setLayoutData((Object)spacerData);
        Label developerLabel = new Label(container, 0);
        developerLabel.setText("Created by Han Junghoon. omaro7@hanmail.net");
        developerLabel.setLayoutData((Object)new GridData(0x1000000, 1024, true, false));
        developerLabel.setBackground(white);
        container.addListener(12, event -> {
            if (this.logoImage != null && !this.logoImage.isDisposed()) {
                this.logoImage.dispose();
            }
        });
        return container;
    }

    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, "\ud655\uc778", true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            System.out.println("\uc608 \ubc84\ud2bc \ud074\ub9ad\ub428");
            this.close();
        } else if (buttonId == 3) {
            System.out.println("\uc544\ub2c8\uc624 \ubc84\ud2bc \ud074\ub9ad\ub428");
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public boolean close() {
        if (this.logoImage != null && !this.logoImage.isDisposed()) {
            this.logoImage.dispose();
        }
        return super.close();
    }
}

