/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ContrastCheckerDialog
extends TitleAreaDialog {
    private Text txtBgHex;
    private Text txtFgHex;
    private Label lblPreview;
    private Label lblRatio;
    private Label lblResult;
    private Color bgColor;
    private Color fgColor;
    private String selectedBgHex = "#08203B";
    private String selectedFgHex = "#FFFFFF";

    public ContrastCheckerDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("\uba85\ub3c4 \ub300\ube44 \uccb4\ud06c");
        this.setMessage("\ubc30\uacbd\uc0c9\uacfc \uae00\uc790\uc0c9\uc744 \uc120\ud0dd\ud574\uc11c WCAG \uba85\ub3c4 \ub300\ube44 \uae30\uc900\uc744 \ud655\uc778\ud558\uc138\uc694.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        final Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpColors = new Group(container, 0);
        grpColors.setText("\uba85\ub3c4 \ub300\ube44 \uc0c9\uc0c1 \uc124\uc815");
        grpColors.setLayoutData((Object)new GridData(4, 128, true, false));
        grpColors.setLayout((Layout)new GridLayout(3, false));
        Label lblBg = new Label((Composite)grpColors, 0);
        lblBg.setText("\ubc30\uacbd\uc0c9 (#RRGGBB):");
        this.txtBgHex = new Text((Composite)grpColors, 2048);
        this.txtBgHex.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtBgHex.setText(this.selectedBgHex);
        Button btnBgPick = new Button((Composite)grpColors, 8);
        btnBgPick.setText("\ubc30\uacbd\uc0c9 \uc120\ud0dd...");
        btnBgPick.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContrastCheckerDialog.this.pickColor(ContrastCheckerDialog.this.txtBgHex, container.getDisplay());
            }
        });
        Label lblFg = new Label((Composite)grpColors, 0);
        lblFg.setText("\uae00\uc790\uc0c9 (#RRGGBB):");
        this.txtFgHex = new Text((Composite)grpColors, 2048);
        this.txtFgHex.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtFgHex.setText(this.selectedFgHex);
        Button btnFgPick = new Button((Composite)grpColors, 8);
        btnFgPick.setText("\uae00\uc790\uc0c9 \uc120\ud0dd...");
        btnFgPick.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContrastCheckerDialog.this.pickColor(ContrastCheckerDialog.this.txtFgHex, container.getDisplay());
            }
        });
        Group grpPreview = new Group(container, 0);
        grpPreview.setText("\ubbf8\ub9ac\ubcf4\uae30");
        grpPreview.setLayoutData((Object)new GridData(4, 4, true, true));
        grpPreview.setLayout((Layout)new GridLayout(1, false));
        this.lblPreview = new Label((Composite)grpPreview, 0x1000000);
        this.lblPreview.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lblPreview.setText("\uc608\uc2dc \ud14d\uc2a4\ud2b8\nExample Text 123");
        this.lblPreview.setAlignment(0x1000000);
        Display display = container.getDisplay();
        this.bgColor = new Color((Device)display, this.hexToRGB(this.selectedBgHex));
        this.fgColor = new Color((Device)display, this.hexToRGB(this.selectedFgHex));
        this.applyColorsToPreview();
        Group grpResult = new Group(container, 0);
        grpResult.setText("\uba85\ub3c4 \ub300\ube44 \uacb0\uacfc");
        grpResult.setLayoutData((Object)new GridData(4, 1024, true, false));
        grpResult.setLayout((Layout)new GridLayout(2, false));
        Label lblRatioTitle = new Label((Composite)grpResult, 0);
        lblRatioTitle.setText("\uba85\ub3c4 \ub300\ube44 \ube44\uc728:");
        this.lblRatio = new Label((Composite)grpResult, 0);
        this.lblRatio.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblResultTitle = new Label((Composite)grpResult, 0);
        lblResultTitle.setText("WCAG \uacb0\uacfc:");
        this.lblResult = new Label((Composite)grpResult, 0);
        this.lblResult.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ContrastCheckerDialog.this.updateFromHexTexts(container.getDisplay());
            }
        };
        this.txtBgHex.addModifyListener(modifyListener);
        this.txtFgHex.addModifyListener(modifyListener);
        this.updateFromHexTexts(container.getDisplay());
        container.addListener(12, event -> {
            if (this.bgColor != null && !this.bgColor.isDisposed()) {
                this.bgColor.dispose();
            }
            if (this.fgColor != null && !this.fgColor.isDisposed()) {
                this.fgColor.dispose();
            }
        });
        return area;
    }

    protected void okPressed() {
        this.selectedBgHex = this.txtBgHex.getText().trim();
        this.selectedFgHex = this.txtFgHex.getText().trim();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    public String getSelectedBgHex() {
        return this.selectedBgHex;
    }

    public String getSelectedFgHex() {
        return this.selectedFgHex;
    }

    private void pickColor(Text targetText, Display display) {
        ColorDialog dialog = new ColorDialog(this.getShell());
        try {
            RGB current = this.hexToRGB(targetText.getText().trim());
            dialog.setRGB(current);
        }
        catch (Exception exception) {}
        RGB rgb = dialog.open();
        if (rgb != null) {
            String hex = String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
            targetText.setText(hex);
        }
    }

    private RGB hexToRGB(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("hex is null");
        }
        if ((hex = hex.trim()).startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6) {
            throw new IllegalArgumentException("hex must be 6 digits");
        }
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return new RGB(r, g, b);
    }

    private void updateFromHexTexts(Display display) {
        try {
            RGB bgRgb = this.hexToRGB(this.txtBgHex.getText());
            RGB fgRgb = this.hexToRGB(this.txtFgHex.getText());
            if (this.bgColor != null && !this.bgColor.isDisposed()) {
                this.bgColor.dispose();
            }
            if (this.fgColor != null && !this.fgColor.isDisposed()) {
                this.fgColor.dispose();
            }
            this.bgColor = new Color((Device)display, bgRgb);
            this.fgColor = new Color((Device)display, fgRgb);
            this.applyColorsToPreview();
            this.updateContrastResult(bgRgb, fgRgb);
        }
        catch (Exception exception) {
            this.lblRatio.setText("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c9\uc0c1 \uac12");
            this.lblResult.setText("-");
        }
    }

    private void applyColorsToPreview() {
        if (this.lblPreview != null && !this.lblPreview.isDisposed()) {
            this.lblPreview.setBackground(this.bgColor);
            this.lblPreview.setForeground(this.fgColor);
        }
    }

    private void updateContrastResult(RGB bgRgb, RGB fgRgb) {
        double bgL = this.relativeLuminance(bgRgb);
        double fgL = this.relativeLuminance(fgRgb);
        double lighter = Math.max(bgL, fgL);
        double darker = Math.min(bgL, fgL);
        double ratio = (lighter + 0.05) / (darker + 0.05);
        String ratioStr = String.format("%.2f : 1", ratio);
        this.lblRatio.setText(ratioStr);
        boolean passAA_Normal = ratio >= 4.5;
        boolean passAAA_Normal = ratio >= 7.0;
        boolean passAA_Large = ratio >= 3.0;
        StringBuilder sb = new StringBuilder();
        sb.append("\uc77c\ubc18 \ud14d\uc2a4\ud2b8 AA(4.5\uc774\uc0c1): ").append(passAA_Normal ? "\ud1b5\uacfc" : "\uc2e4\ud328").append("  /  ");
        sb.append("\uc77c\ubc18 \ud14d\uc2a4\ud2b8 AAA(7.0\uc774\uc0c1): ").append(passAAA_Normal ? "\ud1b5\uacfc" : "\uc2e4\ud328").append("  /  ");
        sb.append("\ud070 \ud14d\uc2a4\ud2b8 AA(3.0\uc774\uc0c1): ").append(passAA_Large ? "\ud1b5\uacfc" : "\uc2e4\ud328");
        this.lblResult.setText(sb.toString());
    }

    private double relativeLuminance(RGB rgb) {
        double r = (double)rgb.red / 255.0;
        double g = (double)rgb.green / 255.0;
        double b = (double)rgb.blue / 255.0;
        r = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }
}

