/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import kr.co.goms.epub.solution.ui.EpubErrorItem;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EpubCheckErrorDialog
extends TitleAreaDialog {
    private EpubErrorItem epubErrorItem;
    private Color backgroundColor;
    private Color whiteColor;

    public EpubCheckErrorDialog(Shell parentShell, EpubErrorItem epubErrorItem) {
        super(parentShell);
        this.epubErrorItem = epubErrorItem;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("EPUB Check Error");
        shell.setSize(800, 600);
        shell.setMinimumSize(800, 600);
        this.backgroundColor = new Color((Device)shell.getDisplay(), 220, 235, 250);
        this.whiteColor = new Color((Device)shell.getDisplay(), 255, 255, 255);
    }

    public void create() {
        super.create();
        this.setTitle("EPUB Check Error");
        String headerTxt = this.epubErrorItem.getFileFullPath() + "\nLEVEL : " + this.epubErrorItem.getLevel() + ", CODE : " + this.epubErrorItem.getCode() + ", ROW : " + this.epubErrorItem.getLine() + ", COLUMN : " + this.epubErrorItem.getColumn();
        this.setMessage(headerTxt);
        this.applyTitleAreaBackground();
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout(256));
        container.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(container, 512);
        StyledText errorDesc = new StyledText((Composite)sashForm, 584);
        errorDesc.setMargins(10, 10, 10, 10);
        errorDesc.setBackground(this.whiteColor);
        errorDesc.setText(this.epubErrorItem.getMessage());
        sashForm.setWeights(new int[]{1});
        return area;
    }

    private void applyTitleAreaBackground() {
        Composite titleArea = this.getDialogArea().getParent();
        titleArea.setBackground(this.backgroundColor);
        Control[] controlArray = titleArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(this.backgroundColor);
            ++n2;
        }
        titleArea.addDisposeListener(e -> {
            if (!this.backgroundColor.isDisposed()) {
                this.backgroundColor.dispose();
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.backgroundColor);
        Button closeButton = this.createButton(parent, 12, "\ub2eb\uae30", false);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpubCheckErrorDialog.this.close();
            }
        });
    }
}

