/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.List;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.Spine;
import nl.siegmann.epublib.domain.SpineReference;
import nl.siegmann.epublib.epub.EpubReader;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EpubViewerDialog
extends TitleAreaDialog {
    private File epubFile;
    private Book book;
    private Browser browser;
    private int currentSpineIndex = 0;
    private Color backgroundColor;

    public EpubViewerDialog(Shell parentShell, File epubFile) {
        super(parentShell);
        this.epubFile = epubFile;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("EPUB Viewer");
        shell.setSize(580, 960);
        shell.setMinimumSize(480, 960);
        this.backgroundColor = new Color((Device)shell.getDisplay(), 220, 235, 250);
        shell.setBackground(this.backgroundColor);
    }

    public void create() {
        super.create();
        this.setTitle("EPUB Viewer");
        this.setMessage(this.epubFile.getName());
        this.applyTitleAreaBackground();
    }

    private void applyTitleAreaBackground() {
        Composite titleArea = this.getDialogArea().getParent();
        titleArea.setBackground(this.backgroundColor);
        Control[] controlArray = titleArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(this.backgroundColor);
            ++n2;
        }
        titleArea.addDisposeListener(e -> {
            if (!this.backgroundColor.isDisposed()) {
                this.backgroundColor.dispose();
            }
        });
    }

    private void applyTitleAreaBackgroundImage() {
        Composite titleArea = this.getDialogArea().getParent();
        try {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"epubtest03", (String)"resources/ad_banner_1280.jpg");
            Image image = descriptor.createImage();
            titleArea.addPaintListener(e -> {
                if (image != null && !image.isDisposed()) {
                    Rectangle area = titleArea.getClientArea();
                    Rectangle imgBounds = image.getBounds();
                    e.gc.drawImage(image, 0, 0);
                    e.gc.drawImage(image, 0, 0, imgBounds.width, imgBounds.height, 0, 0, area.width, area.height);
                }
            });
            titleArea.addDisposeListener(e -> {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            });
        }
        catch (Exception exception) {}
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(container, 2048);
        GridData browserGridData = new GridData(4, 4, true, true);
        browserGridData.widthHint = 800;
        browserGridData.heightHint = 600;
        this.browser.setLayoutData((Object)browserGridData);
        Composite buttonComposite = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        buttonComposite.setBackground(this.backgroundColor);
        GridData gd = new GridData(0x1000000, 0x1000000, true, false);
        buttonComposite.setLayoutData((Object)gd);
        Button prevButton = new Button(buttonComposite, 8);
        prevButton.setText("\uc774\uc804");
        prevButton.addListener(13, e -> this.showPreviousPage());
        Button nextButton = new Button(buttonComposite, 8);
        nextButton.setText("\ub2e4\uc74c");
        nextButton.addListener(13, e -> this.showNextPage());
        this.loadEpub();
        this.showPage(this.currentSpineIndex);
        return container;
    }

    private void loadEpub() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream fis = new FileInputStream(this.epubFile);){
                this.book = new EpubReader().readEpub((InputStream)fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.setErrorMessage("EPUB \ud30c\uc77c \ub85c\ub4dc \uc2e4\ud328: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void showPage(int spineIndex) {
        if (this.book == null) {
            return;
        }
        Spine spine = this.book.getSpine();
        List spineRefs = spine.getSpineReferences();
        if (spineIndex < 0 || spineIndex >= spineRefs.size()) {
            return;
        }
        try {
            Resource res = ((SpineReference)spineRefs.get(spineIndex)).getResource();
            String content = new String(res.getData(), res.getInputEncoding());
            String projectPath = EpubBuildUtil.getProjectFullPath();
            content = content.replace("../Images/", "file://" + projectPath + "/OEBPS/Images/");
            content = content.replace("../Styles/", "file://" + projectPath + "/OEBPS/Styles/");
            this.browser.setText(content);
            this.currentSpineIndex = spineIndex;
            this.setMessage(String.format("%s \u2014 \ud398\uc774\uc9c0 %d/%d", this.epubFile.getName(), this.currentSpineIndex + 1, spineRefs.size()));
            this.setErrorMessage(null);
        }
        catch (Exception e) {
            this.setErrorMessage("\ud398\uc774\uc9c0 \ub85c\ub4dc \uc624\ub958: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void showPreviousPage() {
        if (this.currentSpineIndex > 0) {
            this.showPage(this.currentSpineIndex - 1);
        }
    }

    private void showNextPage() {
        if (this.book != null && this.currentSpineIndex < this.book.getSpine().size() - 1) {
            this.showPage(this.currentSpineIndex + 1);
        }
    }

    protected Point getInitialSize() {
        return new Point(1200, 800);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.backgroundColor);
        Button closeButton = this.createButton(parent, 12, "\ub2eb\uae30", false);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpubViewerDialog.this.close();
            }
        });
    }

    public void runEpubCheckWithProgress(Shell parentShell, File epubFile) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parentShell);
        try {
            dialog.run(true, false, monitor -> {
                monitor.beginTask("EPUB \uac80\uc0ac \uc911\uc785\ub2c8\ub2e4...", -1);
                try {
                    String output = this.runEpubCheck(epubFile);
                    Display.getDefault().asyncExec(() -> this.showResultInDialog(parentShell, epubFile.getName(), output));
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(() -> this.showResultInDialog(parentShell, "\uc624\ub958", e.getMessage()));
                }
                monitor.done();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            this.showResultInDialog(parentShell, "\uc624\ub958", e.getMessage());
        }
    }

    public String runEpubCheck(File epubFile) throws IOException, InterruptedException {
        String line;
        String epubcheckDir = EpubBuildUtil.getProjectPath() + "/epubcheck-5.2.1";
        System.out.println("epubcheckDir : " + epubcheckDir);
        String classpath = String.join((CharSequence)File.pathSeparator, epubcheckDir + "/epubcheck.jar", epubcheckDir + "/lib/*");
        ProcessBuilder pb = new ProcessBuilder("java", "-Dfile.encoding=UTF-8", "-cp", classpath, "com.adobe.epubcheck.tool.Checker", epubFile.getAbsolutePath());
        pb.directory(new File(epubcheckDir));
        pb.redirectErrorStream(true);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("MS949")));
        StringBuilder output = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            output.append(line).append("\n");
        }
        process.waitFor();
        return output.toString();
    }

    public void runEpubCheck(File epubFile, EpubCheckCallback callback) {
        new Thread(() -> {
            try {
                String line;
                String epubcheckDir = EpubBuildUtil.getProjectPath() + "/epubcheck-5.2.1";
                System.out.println("epubcheckDir : " + epubcheckDir);
                String classpath = String.join((CharSequence)File.pathSeparator, epubcheckDir + "/epubcheck.jar", epubcheckDir + "/lib/*");
                ProcessBuilder pb = new ProcessBuilder("java", "-Dfile.encoding=UTF-8", "-cp", classpath, "com.adobe.epubcheck.tool.Checker", epubFile.getAbsolutePath());
                pb.directory(new File(epubcheckDir));
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("MS949")));
                StringBuilder output = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
                process.waitFor();
                String result = output.toString();
                callback.onCompleted(epubFile.getName(), result);
            }
            catch (Exception e) {
                callback.onCompleted("\uc624\ub958", "epubcheck \uc2e4\ud589 \uc911 \uc624\ub958 \ubc1c\uc0dd\n" + e.getMessage());
            }
        }).start();
    }

    private void showResultInDialog(Shell shell, String title, String message) {
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)("EPUB \uac80\uc0ac \uacb0\uacfc - " + title), (String)message));
    }

    public static interface EpubCheckCallback {
        public void onCompleted(String var1, String var2);
    }
}

