/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoInsertDialog
extends TitleAreaDialog {
    private Text descText;
    private String description = "";
    private String selectedColorName = "Orange";
    private List<Color> colorPool = new ArrayList<Color>();
    private static final String[][] COLORS = new String[][]{{"Orange", "#FFA500"}, {"Sunset", "#FF4500"}, {"Gold", "#FFD700"}, {"LimeGreen", "#32CD32"}, {"RoyalBlue", "#4169E1"}};

    public InfoInsertDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\uc815\ubcf4\ub0b4\uc6a9 \uc0bd\uc785");
        newShell.setMinimumSize(640, 420);
    }

    protected boolean isResizable() {
        return false;
    }

    public void create() {
        super.create();
        this.setTitle("\uc815\ubcf4\ub0b4\uc6a9 \uc0bd\uc785");
        this.setMessage("\uc815\ubcf4\ub0b4\uc6a9\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 10;
        gl.marginHeight = 10;
        gl.verticalSpacing = 8;
        gl.horizontalSpacing = 8;
        container.setLayout((Layout)gl);
        Label l3 = new Label(container, 0);
        l3.setText("\uc815\ubcf4\uae00");
        l3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.descText = new Text(container, 2626);
        GridData gdDesc = new GridData(4, 4, true, false);
        gdDesc.horizontalSpan = 2;
        gdDesc.heightHint = 120;
        gdDesc.widthHint = 480;
        this.descText.setLayoutData((Object)gdDesc);
        Label l4 = new Label(container, 0);
        l4.setText("\uc0c9\uc0c1");
        l4.setLayoutData((Object)new GridData(16384, 128, false, false));
        Composite colorGroup = new Composite(container, 0);
        GridData gdColor = new GridData(4, 128, true, false);
        gdColor.horizontalSpan = 2;
        colorGroup.setLayoutData((Object)gdColor);
        RowLayout rl = new RowLayout(256);
        rl.wrap = true;
        rl.spacing = 18;
        rl.marginBottom = 4;
        rl.marginTop = 4;
        rl.center = true;
        colorGroup.setLayout((Layout)rl);
        String[][] stringArray = COLORS;
        int n = COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] c = stringArray[n2];
            String label = c[0];
            String hex = c[1];
            Canvas swatch = new Canvas(colorGroup, 0x20000000);
            swatch.setLayoutData((Object)new RowData(14, 14));
            swatch.setToolTipText(label);
            Color colorObj = this.hexToColor(swatch.getDisplay(), hex);
            this.colorPool.add(colorObj);
            swatch.addPaintListener(e -> {
                e.gc.setBackground(colorObj);
                e.gc.fillRectangle(0, 0, 14, 14);
                e.gc.setForeground(swatch.getDisplay().getSystemColor(17));
                e.gc.drawRectangle(0, 0, 13, 13);
            });
            Button rb = new Button(colorGroup, 16);
            rb.setText(label);
            rb.setData("hex", (Object)hex);
            if (hex.equalsIgnoreCase(this.selectedColorName)) {
                rb.setSelection(true);
            }
            rb.addListener(13, ev -> {
                if (rb.getSelection()) {
                    this.selectedColorName = rb.getText();
                }
            });
            swatch.addListener(3, ev -> {
                rb.setSelection(true);
                this.selectedColorName = hex;
            });
            ++n2;
        }
        Dialog.applyDialogFont((Control)container);
        return area;
    }

    private Color hexToColor(Display d, String hex) {
        Object h;
        Object object = h = hex.startsWith("#") ? hex.substring(1) : hex;
        if (((String)h).length() == 3) {
            h = "" + ((String)h).charAt(0) + ((String)h).charAt(0) + ((String)h).charAt(1) + ((String)h).charAt(1) + ((String)h).charAt(2) + ((String)h).charAt(2);
        }
        int r = Integer.parseInt(((String)h).substring(0, 2), 16);
        int g = Integer.parseInt(((String)h).substring(2, 4), 16);
        int b = Integer.parseInt(((String)h).substring(4, 6), 16);
        return new Color((Device)d, r, g, b);
    }

    protected void okPressed() {
        this.description = this.safe(this.descText.getText());
        if (this.description.isEmpty()) {
            this.setErrorMessage("\ub0b4\uc6a9\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
            return;
        }
        this.colorPool.clear();
        super.okPressed();
    }

    private String safe(String s) {
        return s == null ? "" : s.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public String getSelectedColorName() {
        return this.selectedColorName;
    }
}

