/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javazoom.jl.player.Player;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Mp3PlayerDialog
extends Dialog {
    private String mp3Path;
    private String textContent;
    private Player player;
    private Thread playThread;
    private boolean isPlaying = false;
    private int durationInSec = 0;
    private int currentSec = 0;

    public Mp3PlayerDialog(Shell parent, String mp3Path, String textContent) {
        super(parent);
        this.mp3Path = mp3Path;
        this.textContent = textContent;
    }

    public void open() {
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 67680);
        shell.setText("MP3 \uc7ac\uc0dd\uae30");
        shell.setLayout((Layout)new GridLayout(1, false));
        shell.setSize(600, 400);
        shell.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)shell, 2560);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Text textArea = new Text((Composite)scrolledComposite, 586);
        textArea.setText(this.textContent);
        textArea.setBackground(shell.getDisplay().getSystemColor(1));
        textArea.setLayoutData((Object)new GridData(4, 4, true, true));
        int widthHint = 560;
        textArea.setSize(widthHint, -1);
        scrolledComposite.setContent((Control)textArea);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(textArea.computeSize(-1, -1));
        Point preferredSize = textArea.computeSize(widthHint, -1);
        textArea.setSize(preferredSize);
        scrolledComposite.setMinSize(preferredSize);
        Composite progressComposite = new Composite((Composite)shell, 0);
        progressComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        progressComposite.setLayout((Layout)new GridLayout(1, false));
        Label timeLabel = new Label(progressComposite, 0);
        timeLabel.setText("00:00 / 00:00");
        ProgressBar progressBar = new ProgressBar(progressComposite, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite buttonArea = new Composite((Composite)shell, 0);
        buttonArea.setLayout((Layout)new RowLayout(256));
        buttonArea.setLayoutData((Object)new GridData(0x1000000, 1024, true, false));
        Button playBtn = new Button(buttonArea, 8);
        playBtn.setText("\u25b6 \uc7ac\uc0dd");
        Button stopBtn = new Button(buttonArea, 8);
        stopBtn.setText("\u25a0 \uc815\uc9c0");
        stopBtn.setEnabled(false);
        Button closeBtn = new Button(buttonArea, 8);
        closeBtn.setText("\ub2eb\uae30");
        playBtn.addListener(13, e -> {
            this.stop();
            this.currentSec = 0;
            this.durationInSec = this.estimateMp3Duration(this.mp3Path);
            progressBar.setMaximum(this.durationInSec);
            timeLabel.setText("00:00 / " + this.formatTime(this.durationInSec));
            this.playThread = new Thread(() -> {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileInputStream fis = new FileInputStream(this.mp3Path);){
                        this.player = new Player((InputStream)fis);
                        this.isPlaying = true;
                        this.player.play();
                        this.isPlaying = false;
                        Display.getDefault().asyncExec(() -> {
                            playBtn.setEnabled(true);
                            stopBtn.setEnabled(false);
                            progressBar.setSelection(0);
                            timeLabel.setText("00:00 / " + this.formatTime(this.durationInSec));
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            this.playThread.start();
            this.startProgressUpdater(timeLabel, progressBar, shell.getDisplay());
            playBtn.setEnabled(false);
            stopBtn.setEnabled(true);
        });
        stopBtn.addListener(13, e -> {
            this.stop();
            playBtn.setEnabled(true);
            stopBtn.setEnabled(false);
        });
        closeBtn.addListener(13, e -> {
            this.stop();
            shell.close();
        });
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void stop() {
        this.isPlaying = false;
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
        if (this.playThread != null && this.playThread.isAlive()) {
            this.playThread.interrupt();
        }
    }

    private void startProgressUpdater(final Label label, final ProgressBar bar, final Display display) {
        display.timerExec(1000, new Runnable(){

            @Override
            public void run() {
                if (!Mp3PlayerDialog.this.isPlaying) {
                    return;
                }
                ++Mp3PlayerDialog.this.currentSec;
                if (Mp3PlayerDialog.this.currentSec <= Mp3PlayerDialog.this.durationInSec) {
                    label.setText(Mp3PlayerDialog.this.formatTime(Mp3PlayerDialog.this.currentSec) + " / " + Mp3PlayerDialog.this.formatTime(Mp3PlayerDialog.this.durationInSec));
                    bar.setSelection(Mp3PlayerDialog.this.currentSec);
                    display.timerExec(1000, (Runnable)this);
                }
            }
        });
    }

    private String formatTime(int seconds) {
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    private int estimateMp3Duration(String path) {
        File f = new File(path);
        long fileSize = f.length();
        int bitRate = 131072;
        return (int)(fileSize * 8L / (long)bitRate);
    }
}

