/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javazoom.jl.player.Player;
import kr.co.goms.epub.smil.SmilParser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SmilViewerDialog {
    private Shell shell;
    private Browser browser;
    private Player player;
    private Button playButton;
    private Button stopButton;
    private List<SmilEntry> smilEntries;
    private volatile boolean stopRequested = false;
    private String xhtmlPath;

    public SmilViewerDialog(Display display, File smilFile, File xhtmlFile) {
        this.xhtmlPath = xhtmlFile.getAbsolutePath();
        this.smilEntries = SmilParser.parse(smilFile);
        this.shell = new Shell(display, 66800);
        this.shell.setText("Smil \uc7ac\uc0dd: " + smilFile.getName());
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(900, 700);
        this.browser = new Browser((Composite)this.shell, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.setUrl("file:///" + this.xhtmlPath.replace("\\", "/"));
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 1024, true, false));
        buttonComp.setLayout((Layout)new RowLayout(256));
        this.playButton = new Button(buttonComp, 8);
        this.playButton.setText("\u25b6 \uc7ac\uc0dd");
        this.playButton.addListener(13, e -> this.startPlayback());
        this.stopButton = new Button(buttonComp, 8);
        this.stopButton.setText("\u23f9 \uc815\uc9c0");
        this.stopButton.addListener(13, e -> {
            boolean bl = this.stopRequested = true;
        });
        this.shell.addDisposeListener(e -> this.stopPlayback());
    }

    public void open() {
        this.shell.open();
    }

    private void startPlayback() {
        this.stopRequested = false;
        new Thread(() -> {
            for (SmilEntry entry : this.smilEntries) {
                if (this.stopRequested) break;
                String mp3Path = entry.getAudioPath();
                String id = entry.getTextId();
                Display.getDefault().asyncExec(() -> this.browser.execute("highlight('" + id + "');"));
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileInputStream fis = new FileInputStream(mp3Path);){
                        Player player = new Player((InputStream)fis);
                        player.play();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.stopRequested) break;
            }
        }).start();
    }

    private void stopPlayback() {
        this.stopRequested = true;
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    public static class SmilEntry {
        private final String textId;
        private final String audioPath;

        public SmilEntry(String textId, String audioPath) {
            this.textId = textId;
            this.audioPath = audioPath;
        }

        public String getTextId() {
            return this.textId;
        }

        public String getAudioPath() {
            return this.audioPath;
        }
    }
}

