/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.doc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import kr.co.goms.epub.managers.ContentOpfManager;
import kr.co.goms.epub.solution.doc.HwpToXhtmlFontUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ConvertHwpHandler {
    @Execute
    public void execute(Shell parentShell, IEclipseContext parentContext) {
        FileDialog dialog = new FileDialog(parentShell, 4096);
        dialog.setFilterExtensions(new String[]{"*.hwp"});
        dialog.setText("HWP \ud30c\uc77c \uc120\ud0dd");
        String selectedPath = dialog.open();
        if (selectedPath == null) {
            return;
        }
        File hwpFile = new File(selectedPath);
        IProject iProject = EpubBuildUtil.getIProject();
        IFolder iTextFolder = EpubBuildUtil.getProjectIFolder("OEBPS/Text");
        IFolder iImagesFolder = EpubBuildUtil.getProjectIFolder("OEBPS/Images");
        try {
            ConvertHwpHandler.ensureFolder(iTextFolder);
            ConvertHwpHandler.ensureFolder(iImagesFolder);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFile hwp = iTextFolder.getFile(hwpFile.getName());
        Job.create((String)"HWP \u2192 XHTML \ubcc0\ud658", monitor -> {
            monitor.beginTask("\ubcc0\ud658 \uc911...", -1);
            try {
                try {
                    String base = hwp.getName().replaceFirst("\\.hwp$", "");
                    IFile outXhtml = iTextFolder.getFile(base + ".xhtml");
                    Path hwpPath = Paths.get(selectedPath, new String[0]);
                    Path imageOut = iImagesFolder.getLocation().toFile().toPath();
                    HwpToXhtmlFontUtil.Result result = HwpToXhtmlFontUtil.convert(hwpPath, imageOut);
                    byte[] bytes = result.xhtml().getBytes(StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    Object var13_15 = null;
                    try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                        if (outXhtml.exists()) {
                            outXhtml.setContents((InputStream)in, true, true, monitor);
                        } else {
                            outXhtml.create((InputStream)in, true, monitor);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    iProject.refreshLocal(2, monitor);
                    try {
                        ContentOpfManager.getInstance().updateMenifestAndSpine(outXhtml.getName());
                    }
                    catch (Throwable throwable3) {}
                }
                catch (Exception ex) {
                    throw new CoreException((IStatus)new Status(4, "epubtest03", ex.getMessage(), (Throwable)ex));
                }
            }
            finally {
                monitor.done();
            }
        }).schedule();
    }

    private static void ensureFolder(IFolder f) throws CoreException {
        if (!f.exists()) {
            f.create(true, true, null);
        }
    }
}

