/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.BodyText;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.charshape.CharPositionShapeIdPair;
import kr.dogfoot.hwplib.object.bodytext.paragraph.charshape.ParaCharShape;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlExtend;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlInline;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharNormal;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.ParaText;
import kr.dogfoot.hwplib.object.docinfo.CharShape;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.reader.HWPReader;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.hwp.HwpV5Parser;
import org.apache.tika.sax.ToXMLContentHandler;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.xml.sax.ContentHandler;

public class HwpToXhtmlFontUtil {
    public static Result convert(Path hwpPath, final Path imageOutDir) throws Exception {
        Files.createDirectories(imageOutDir, new FileAttribute[0]);
        ParseContext ctx = new ParseContext();
        final AtomicInteger seq = new AtomicInteger(1);
        ctx.set(EmbeddedDocumentExtractor.class, (Object)new EmbeddedDocumentExtractor(){

            public boolean shouldParseEmbedded(Metadata m) {
                return true;
            }

            public void parseEmbedded(InputStream stream, ContentHandler h, Metadata m, boolean outputHtml) throws IOException {
                String ext = HwpToXhtmlFontUtil.extFromMime(m == null ? null : m.get("Content-Type"));
                String name = "img_" + String.format("%03d", seq.getAndIncrement()) + ext;
                Path out = imageOutDir.resolve(name);
                Throwable throwable = null;
                Object var9_10 = null;
                try (OutputStream os = Files.newOutputStream(out, new OpenOption[0]);){
                    stream.transferTo(os);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
        HwpV5Parser parser = new HwpV5Parser();
        ToXMLContentHandler xhtmlHandler = new ToXMLContentHandler();
        Metadata md = new Metadata();
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream is = Files.newInputStream(hwpPath, new OpenOption[0]);){
            ctx.set(Parser.class, (Object)parser);
            parser.parse(is, (ContentHandler)xhtmlHandler, md, ctx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String cleaned = HwpToXhtmlFontUtil.buildXhtmlFromHwplib(hwpPath);
        cleaned = HwpToXhtmlFontUtil.postProcessXhtml(cleaned, imageOutDir.getFileName().toString());
        return new Result(cleaned);
    }

    public static String postProcessXhtml(String raw, String imageFolderName) {
        if (raw == null || raw.isBlank()) {
            raw = "<html><head><title></title></head><body><p></p></body></html>";
        }
        Document doc = Jsoup.parse((String)raw);
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).charset(StandardCharsets.UTF_8).prettyPrint(true);
        doc.select("html").attr("xmlns", "http://www.w3.org/1999/xhtml").attr("xmlns:epub", "http://www.idpf.org/2007/ops").attr("xml:lang", "ko").attr("lang", "ko");
        doc.select("img").forEach(img -> {
            String src = img.attr("src");
            if (src == null || src.isBlank()) {
                return;
            }
            String file = Paths.get(src, new String[0]).getFileName().toString();
            img.attr("src", "../Images/" + file);
            if (!img.hasAttr("alt")) {
                img.attr("alt", "");
            }
        });
        String bodyHtml = doc.selectFirst("body") != null ? doc.selectFirst("body").outerHtml() : "<body/>";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\" lang=\"ko\" xml:lang=\"ko\">\n  <head>\n    <title></title>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"../Styles/style1.css\" />\n  </head>\n  %s\n</html>".formatted(bodyHtml);
    }

    private static String extFromMime(String mime) {
        if (mime == null) {
            return ".bin";
        }
        switch (mime) {
            case "image/png": {
                return ".png";
            }
            case "image/jpeg": {
                return ".jpg";
            }
            case "image/gif": {
                return ".gif";
            }
            case "image/bmp": {
                return ".bmp";
            }
            case "image/webp": {
                return ".webp";
            }
        }
        return ".bin";
    }

    private static String buildXhtmlFromHwplib(Path hwpPath) throws Exception {
        HWPFile f = HWPReader.fromFile((String)hwpPath.toString());
        DocInfo docInfo = f.getDocInfo();
        StringBuilder x = new StringBuilder();
        x.append("<div>\n");
        BodyText body = f.getBodyText();
        ArrayList sections = body.getSectionList();
        for (Section section : sections) {
            int pi = 0;
            while (pi < section.getParagraphCount()) {
                Paragraph p = section.getParagraph(pi);
                ParaText text = p.getText();
                if (text == null || text.getCharList() == null || text.getCharList().isEmpty()) {
                    x.append("<p/>").append('\n');
                } else {
                    ParaCharShape pcs = p.getCharShape();
                    List<Run> runs = HwpToXhtmlFontUtil.collectRuns(text, pcs, docInfo);
                    int maxPt = runs.stream().mapToInt(r -> r.pointSize).max().orElse(0);
                    String tag = HwpToXhtmlFontUtil.tagByPointSize(maxPt);
                    StringBuilder buf = new StringBuilder();
                    for (Run r2 : runs) {
                        buf.append(HwpToXhtmlFontUtil.escapeXml(r2.text));
                    }
                    x.append('<').append(tag).append('>').append((CharSequence)buf).append("</").append(tag).append(">\n");
                }
                ++pi;
            }
        }
        x.append("</div>");
        return x.toString();
    }

    private static List<Run> collectRuns(ParaText text, ParaCharShape pcs, DocInfo docInfo) {
        ArrayList<Run> out = new ArrayList<Run>();
        if (text == null || text.getCharList() == null || text.getCharList().isEmpty()) {
            return out;
        }
        if (pcs == null || pcs.getPositonShapeIdPairList() == null || pcs.getPositonShapeIdPairList().isEmpty() || docInfo == null || docInfo.getCharShapeList() == null || docInfo.getCharShapeList().isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (HWPChar hc : text.getCharList()) {
                String c = HwpToXhtmlFontUtil.toPrintableChar(hc);
                if (c == "\r" || c == "\n") {
                    c = " ";
                }
                b.append(c);
            }
            Run r = new Run();
            r.text = b.toString();
            r.pointSize = 0;
            out.add(r);
            return out;
        }
        ArrayList pairs = pcs.getPositonShapeIdPairList();
        int pairIdx = 0;
        int currentShapeId = 0;
        int nextBoundary = Integer.MAX_VALUE;
        if (pairs != null && !pairs.isEmpty()) {
            currentShapeId = (int)((CharPositionShapeIdPair)pairs.get(0)).getShapeId();
            if (pairs.size() > 1) {
                nextBoundary = (int)((CharPositionShapeIdPair)pairs.get(1)).getPosition();
            }
        }
        StringBuilder buf = new StringBuilder();
        Integer curPt = null;
        int i = 0;
        while (i < text.getCharList().size()) {
            String c;
            if (i == nextBoundary && pairIdx + 1 < pairs.size()) {
                HwpToXhtmlFontUtil.flushRun(out, buf, curPt);
                currentShapeId = (int)Math.max(0L, ((CharPositionShapeIdPair)pairs.get(++pairIdx)).getShapeId());
                nextBoundary = (int)(pairIdx + 1 < pairs.size() ? ((CharPositionShapeIdPair)pairs.get(pairIdx + 1)).getPosition() : Integer.MAX_VALUE);
            }
            int pt = 0;
            try {
                CharShape cs;
                ArrayList charShapes = docInfo.getCharShapeList();
                if (currentShapeId >= 0 && currentShapeId < charShapes.size() && (cs = (CharShape)charShapes.get(currentShapeId)) != null) {
                    pt = Math.round((float)cs.getBaseSize() / 100.0f);
                }
            }
            catch (Throwable throwable) {
                pt = 0;
            }
            if ((c = HwpToXhtmlFontUtil.toPrintableChar((HWPChar)text.getCharList().get(i))) == "\r" || c == "\n") {
                c = " ";
            }
            if (curPt == null) {
                curPt = pt;
            }
            if (!curPt.equals(pt)) {
                HwpToXhtmlFontUtil.flushRun(out, buf, curPt);
                curPt = pt;
            }
            buf.append(c);
            ++i;
        }
        HwpToXhtmlFontUtil.flushRun(out, buf, curPt);
        return out;
    }

    private static void flushRun(List<Run> out, StringBuilder buf, Integer pt) {
        if (buf.length() == 0) {
            return;
        }
        Run r = new Run();
        r.text = buf.toString();
        r.pointSize = pt == null ? 0 : pt;
        out.add(r);
        buf.setLength(0);
    }

    private static String toPrintableChar(HWPChar hc) {
        if (hc == null) {
            return " ";
        }
        if (hc instanceof HWPCharNormal) {
            HWPCharNormal n = (HWPCharNormal)hc;
            try {
                return n.getCh();
            }
            catch (Throwable throwable) {
                try {
                    Method m = n.getClass().getMethod("getCode", new Class[0]);
                    Object code = m.invoke((Object)n, new Object[0]);
                    if (code instanceof Number) {
                        int cp = ((Number)code).intValue();
                        String s = Character.toString(cp);
                        return s;
                    }
                }
                catch (Throwable throwable2) {}
            }
        }
        if (hc instanceof HWPCharControlInline) {
            return " ";
        }
        if (hc instanceof HWPCharControlExtend) {
            return " ";
        }
        return " ";
    }

    private static String tagByPointSize(int pt) {
        if (pt >= 32) {
            return "h1";
        }
        if (pt >= 24) {
            return "h2";
        }
        if (pt >= 20) {
            return "h3";
        }
        if (pt >= 18) {
            return "h4";
        }
        return "p";
    }

    private static String escapeXml(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public record Result(String xhtml) {
    }

    private static final class Run {
        String text;
        int pointSize;

        private Run() {
        }
    }
}

