/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.util.List;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.accessibility.AccessibilityHeadingChecker;
import kr.co.goms.epub.solution.accessibility.HeadingIssue;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public class AccessibilityHeadingCheckHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext context) {
        File textDir = this.getCurrentEpubTextDir();
        if (textDir == null || !textDir.isDirectory()) {
            System.err.println("EPUB Text \ud3f4\ub354\ub97c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
            return;
        }
        List[] resultHolder = new List[1];
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, false, monitor -> {
                monitor.beginTask("H \ud0dc\uadf8 \uc811\uadfc\uc131 \uac80\uc0ac \uc911...", 100);
                try {
                    try {
                        List<HeadingIssue> issues;
                        listArray[0] = issues = AccessibilityHeadingChecker.checkDirectory(textDir);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        List issues = resultHolder[0];
        if (issues == null) {
            System.err.println("\uac80\uc0ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            return;
        }
        context.set("headingIssues", (Object)issues);
        this.openHeadingResultPart(context);
    }

    private File getCurrentEpubTextDir() {
        String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        return new File(textPath);
    }

    private void openHeadingResultPart(IEclipseContext context) {
        MApplication app = (MApplication)context.get(MApplication.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        String targetContributionURI = "AccessibilityHeadingCheckResultPart";
        String title = "\uc811\uadfc\uc131 \uac80\uc0ac \uacb0\uacfc(H \ud0dc\uadf8)";
        String message = "";
        EpubPartManager.getInstance().addPreviewPart(app, partService, modelService, targetContributionURI, title, message);
    }
}

