/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.util.List;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.accessibility.HeadingCollectUtil;
import kr.co.goms.epub.solution.accessibility.HeadingRow;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public class AccessibilityHeadingEditHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext context, MApplication application) {
        File textDir = this.getCurrentEpubTextDir();
        if (textDir == null || !textDir.isDirectory()) {
            System.err.println("EPUB Text \ud3f4\ub354\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        List[] holder = new List[1];
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, false, monitor -> {
                monitor.beginTask("\uc81c\ubaa9/Heading \ubaa9\ub85d \uc218\uc9d1 \uc911...", 100);
                try {
                    try {
                        List<HeadingRow> rows;
                        listArray[0] = rows = HeadingCollectUtil.collectFromDirectory(textDir);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        List rows = holder[0];
        if (rows == null) {
            System.err.println("\uc218\uc9d1 \uc911 \uc624\ub958 \ubc1c\uc0dd");
            return;
        }
        IEclipseContext appCtx = application.getContext();
        appCtx.set("headingRowsForEdit", (Object)rows);
        appCtx.set("epubTextDir", (Object)textDir);
        GomsLogPart.log("Text rows size : " + rows.size());
        GomsLogPart.log("Text Dir : " + String.valueOf(textDir));
        File navFile = this.getCurrentNavFile();
        this.openHeadingEditPart(application, context, navFile);
    }

    private File getCurrentEpubTextDir() {
        String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        return new File(textPath);
    }

    private File getCurrentNavFile() {
        String contentNavPath = EpubBuildUtil.getProjectOEBPSNavFile();
        return new File(contentNavPath);
    }

    private void openHeadingEditPart(MApplication app, IEclipseContext context, File navFile) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        String targetContributionURI = "AccessibilityHeadingEditPart";
        String title = "\uc811\uadfc\uc131 H \ud0dc\uadf8 \ud655\uc778";
        String message = "";
        EpubPartManager.getInstance().addPreviewPart(app, partService, modelService, targetContributionURI, title, message);
        EpubPartManager.getInstance().addEditorViewPart(app, partService, modelService, navFile.getAbsolutePath(), message);
    }
}

