/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.util.List;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.accessibility.AccessibilityMetaUtil;
import kr.co.goms.epub.solution.accessibility.MetaRow;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public class AccessibilityMetaHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext context, MApplication application) {
        File opfFile = this.getCurrentContentOpfFile();
        if (opfFile == null || !opfFile.isFile()) {
            System.err.println("content.opf \ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        List[] holder = new List[1];
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, false, monitor -> {
                monitor.beginTask("\ud14c\uc774\ube14 \uc811\uadfc\uc131 \uc815\ubcf4 \uc218\uc9d1 \uc911...", 100);
                try {
                    try {
                        List<MetaRow> rows;
                        listArray[0] = rows = AccessibilityMetaUtil.loadFromOpf(opfFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        List rows = holder[0];
        if (rows == null) {
            System.err.println("\uc218\uc9d1 \uc911 \uc624\ub958 \ubc1c\uc0dd");
            return;
        }
        context.set("MetaRowsForEdit", (Object)rows);
        context.set("opfFile", (Object)opfFile);
        IEclipseContext appCtx = application.getContext();
        appCtx.set("MetaRowsForEdit", (Object)rows);
        appCtx.set("opfFile", (Object)opfFile);
        GomsLogPart.log("Meta rows size : " + rows.size());
        GomsLogPart.log("opfFile : " + opfFile.getAbsolutePath());
        this.openMetaAccessibilityEditPart(application, context, opfFile);
    }

    private File getCurrentContentOpfFile() {
        String contentOpfPath = EpubBuildUtil.getProjectOEBPSContentOpfFile();
        return new File(contentOpfPath);
    }

    private void openMetaAccessibilityEditPart(MApplication app, IEclipseContext context, File opfFile) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        String targetContributionURI = "AccessibilityMetaEditPart";
        String title = "\uc811\uadfc\uc131 Meta \ud0dc\uadf8 \ud655\uc778";
        String message = "";
        EpubPartManager.getInstance().addPreviewPart(app, partService, modelService, targetContributionURI, title, message);
        EpubPartManager.getInstance().addEditorViewPart(app, partService, modelService, opfFile.getAbsolutePath(), message);
    }
}

