/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.util.List;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.accessibility.ObjectCollectUtil;
import kr.co.goms.epub.solution.accessibility.TableRow;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AccessibilityTableHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext context, MApplication application) {
        File textDir = this.getCurrentEpubTextDir();
        if (textDir == null || !textDir.isDirectory()) {
            System.err.println("EPUB Text \ud3f4\ub354\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        List[] holder = new List[1];
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, false, monitor -> {
                monitor.beginTask("\ud14c\uc774\ube14 \uc811\uadfc\uc131 \uc815\ubcf4 \uc218\uc9d1 \uc911...", 100);
                try {
                    try {
                        List<TableRow> rows;
                        listArray[0] = rows = ObjectCollectUtil.collectTableFromDirectory(textDir);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        List rows = holder[0];
        if (rows == null) {
            System.err.println("\uc218\uc9d1 \uc911 \uc624\ub958 \ubc1c\uc0dd");
            return;
        }
        context.set("TableRowsForEdit", (Object)rows);
        context.set("epubTextDir", (Object)textDir);
        IEclipseContext appCtx = application.getContext();
        appCtx.set("TableRowsForEdit", (Object)rows);
        appCtx.set("epubTextDir", (Object)textDir);
        GomsLogPart.log("Table rows size : " + rows.size());
        GomsLogPart.log("Text Dir : " + String.valueOf(textDir));
        File lotFile = this.getCurrentLotFile();
        this.openTableAccessibilityEditPart(application, context, lotFile);
    }

    private File getCurrentEpubTextDir() {
        String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        return new File(textPath);
    }

    private File getCurrentLotFile() {
        String contentLotPath = EpubBuildUtil.getProjectOEBPSLotFile();
        return new File(contentLotPath);
    }

    private void openTableAccessibilityEditPart(MApplication app, IEclipseContext context, File lotFile) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        String targetContributionURI = "AccessibilityTableEditPart";
        String title = "\uc811\uadfc\uc131 \ud14c\uc774\ube14 \ud0dc\uadf8 \ud655\uc778";
        String message = "";
        EpubPartManager.getInstance().addPreviewPart(app, partService, modelService, targetContributionURI, title, message);
        GomsLogPart.log("lotFile Dir : " + String.valueOf(lotFile));
        if (lotFile == null || !lotFile.exists()) {
            Display.getDefault().asyncExec(() -> {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)"LOT \ud30c\uc77c \uc5c6\uc74c", (String)"LOT \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\n\n\ud45c \ubaa9\ub85d(LOT)\uc774 \uc0dd\uc131\ub418\uc9c0 \uc54a\uc558\uac70\ub098\n\uc544\uc9c1 EPUB\uc5d0 \ud3ec\ud568\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
            });
            return;
        }
        EpubPartManager.getInstance().addEditorViewPart(app, partService, modelService, lotFile.getAbsolutePath(), message);
    }
}

