/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.parts.EpubEditorPart;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class GenerateEpubCodeHandler {
    @Execute
    public void execute(Shell shell, EPartService partService) {
        String epubCode = "urn:uuid:" + UUID.randomUUID().toString();
        System.out.println("\uc0dd\uc131\ub41c EPub \ucf54\ub4dc: " + epubCode);
        try {
            String contentOpf = EpubBuildUtil.getProjectOEBPSContentOpfFile();
            Path contentOpfPath = Path.of(contentOpf, new String[0]);
            File opfFile = contentOpfPath.toFile();
            if (!opfFile.exists()) {
                MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("content.opf \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4:\n" + contentOpf));
                return;
            }
            String content = Files.readString(contentOpfPath, StandardCharsets.UTF_8);
            String newUuid = UUID.randomUUID().toString();
            String newIdentifier = "urn:uuid:" + newUuid;
            Pattern pattern = Pattern.compile("<dc:identifier[^>]*id=[\"']BookId[\"'][^>]*>(.*?)</dc:identifier>");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) {
                MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)"content.opf\uc5d0\uc11c BookId \uc2dd\ubcc4\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            String oldLine = matcher.group(0);
            String updatedLine = oldLine.replaceAll(">.*?<", ">" + newIdentifier + "<");
            String updatedContent = content.replace(oldLine, updatedLine);
            Files.writeString(contentOpfPath, (CharSequence)updatedContent, StandardCharsets.UTF_8, new OpenOption[0]);
            for (MPart part : partService.getParts()) {
                if (!"kr.co.goms.epub.solution.parts.epubeditorpart".equals(part.getElementId())) continue;
                String openedPath = (String)part.getPersistedState().get("filePath");
                if (!contentOpfPath.toString().equals(openedPath)) continue;
                EpubEditorPart editor = (EpubEditorPart)part.getObject();
                if (editor == null) break;
                editor.setTextContent(updatedContent);
                editor.setFilePath(openedPath);
                part.setDirty(false);
                break;
            }
            MessageDialog.openInformation((Shell)shell, (String)"EPUB \ucf54\ub4dc \uc0dd\uc131 \uc644\ub8cc", (String)("\uc0c8 EPUB \ucf54\ub4dc\uac00 \uc801\uc6a9\ub418\uc5c8\uc2b5\ub2c8\ub2e4:\n" + newIdentifier));
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)"\ud30c\uc77c \ucc98\ub9ac \uc624\ub958", (String)e.getMessage());
        }
    }
}

