/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Named;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.security.GomsPackagingCrypto;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GomsPackagingHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, EPartService partService) {
        IProject project = EpubBuildUtil.getIProject();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String prefProjectPath = prefs.get("ebook_project_folder", null);
        String initialDir = prefProjectPath != null && !prefProjectPath.isBlank() ? prefProjectPath : project.getLocation().toOSString();
        DirectoryDialog dirDialog = new DirectoryDialog(shell);
        dirDialog.setText("GomsBook \ud328\ud0a4\uc9d5\ud560 \ud3f4\ub354 \uc120\ud0dd");
        dirDialog.setMessage("\ud328\ud0a4\uc9d5(.goms)\uc73c\ub85c \ub9cc\ub4e4 \ud3f4\ub354\ub97c \uc120\ud0dd\ud558\uc138\uc694.");
        dirDialog.setFilterPath(initialDir);
        String selectedDir = dirDialog.open();
        if (selectedDir == null || selectedDir.isBlank()) {
            GomsLogPart.logInfo("\ud328\ud0a4\uc9d5 \ucde8\uc18c - \ud3f4\ub354 \uc120\ud0dd\uc774 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            return;
        }
        Path sourceDir = Paths.get(selectedDir, new String[0]);
        if (!Files.isDirectory(sourceDir, new LinkOption[0])) {
            MessageDialog.openError((Shell)shell, (String)"GomsBook \ud328\ud0a4\uc9d5", (String)("\uc120\ud0dd\ud55c \uacbd\ub85c\uac00 \ud3f4\ub354\uac00 \uc544\ub2d9\ub2c8\ub2e4.\n\uacbd\ub85c: " + selectedDir));
            GomsLogPart.logWarn("\ud328\ud0a4\uc9d5 \uc2e4\ud328 - \ud3f4\ub354\uac00 \uc544\ub2d8. \uacbd\ub85c: " + selectedDir);
            return;
        }
        try {
            IFolder distFolder = project.getFolder("dist");
            if (!distFolder.exists()) {
                distFolder.create(true, true, null);
            }
            Path distDir = distFolder.getLocation().toFile().toPath();
            String folderName = sourceDir.getFileName().toString();
            Path outPath = distDir.resolve(folderName + ".goms");
            AtomicReference<Object> errorRef = new AtomicReference<Object>(null);
            long startTime = System.currentTimeMillis();
            GomsLogPart.logInfo("\ud328\ud0a4\uc9d5 \uc2dc\uc791 - \ud504\ub85c\uc81d\ud2b8: " + project.getName() + ", \ud3f4\ub354: " + sourceDir.toString());
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, false, monitor -> {
                Path tempZip;
                block13: {
                    monitor.beginTask("GomsBook \ud15c\ud50c\ub9bf \ud328\ud0a4\uc9d5 \uc911...", 100);
                    tempZip = null;
                    monitor.subTask("\uc784\uc2dc ZIP \uc0dd\uc131 \uc900\ube44...");
                    tempZip = Files.createTempFile("goms_pack_temp_", ".zip", new FileAttribute[0]);
                    monitor.worked(5);
                    monitor.subTask("\ud15c\ud50c\ub9bf \uc555\ucd95 \uc911 (ZIP)...");
                    GomsPackagingCrypto.zipDirectory(sourceDir, tempZip);
                    monitor.worked(35);
                    if (!monitor.isCanceled()) break block13;
                    monitor.done();
                    if (tempZip == null) return;
                    try {
                        Files.deleteIfExists(tempZip);
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                try {
                    try {
                        monitor.subTask(".goms \uc554\ud638\ud654 \ud30c\uc77c \uc0dd\uc131 \uc911...");
                        GomsPackagingCrypto.encryptZipToGoms(tempZip, outPath);
                        monitor.worked(40);
                        monitor.subTask("\uc784\uc2dc \ud30c\uc77c \uc815\ub9ac \uc911...");
                        Files.deleteIfExists(tempZip);
                        monitor.worked(5);
                        monitor.subTask("\ud504\ub85c\uc81d\ud2b8 \ub9ac\ud504\ub808\uc2dc \uc911...");
                        project.refreshLocal(2, null);
                        monitor.worked(15);
                    }
                    catch (Exception ex) {
                        errorRef.set(ex);
                        monitor.done();
                        if (tempZip == null) return;
                        try {
                            Files.deleteIfExists(tempZip);
                            return;
                        }
                        catch (IOException iOException) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    if (tempZip == null) throw throwable;
                    try {
                        Files.deleteIfExists(tempZip);
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                monitor.done();
                if (tempZip == null) return;
                try {
                    Files.deleteIfExists(tempZip);
                    return;
                }
                catch (IOException iOException) {}
            });
            long endTime = System.currentTimeMillis();
            double elapsedSec = (double)(endTime - startTime) / 1000.0;
            Exception err = errorRef.get();
            if (err != null) {
                err.printStackTrace();
                MessageDialog.openError((Shell)shell, (String)"GomsBook \ud328\ud0a4\uc9d5 \uc624\ub958", (String)("\ud328\ud0a4\uc9d5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.\n\n" + err.getMessage()));
                GomsLogPart.log(GomsLogPart.LogLevel.ERROR, String.format("\ud328\ud0a4\uc9d5 \uc2e4\ud328 - \ud504\ub85c\uc81d\ud2b8: %s, \uba54\uc2dc\uc9c0: %s, \uc18c\uc694 \uc2dc\uac04: %.2f\ucd08", project.getName(), err.getMessage(), elapsedSec));
                return;
            }
            MessageDialog.openInformation((Shell)shell, (String)"GomsBook \ud328\ud0a4\uc9d5 \uc644\ub8cc", (String)String.format("\ud15c\ud50c\ub9bf \ud328\ud0a4\uc9d5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\n\ud30c\uc77c \uc704\uce58:\n%s\n\n\uc18c\uc694 \uc2dc\uac04: %.2f\ucd08", outPath.toString(), elapsedSec));
            this.openDirectory(distDir.toFile());
            GomsLogPart.log(GomsLogPart.LogLevel.INFO, String.format("\ud328\ud0a4\uc9d5 \uc644\ub8cc - \ud504\ub85c\uc81d\ud2b8: %s, \ud30c\uc77c: %s, \uc18c\uc694 \uc2dc\uac04: %.2f\ucd08", project.getName(), outPath.toString(), elapsedSec));
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"GomsBook \ud328\ud0a4\uc9d5 \uc624\ub958", (String)("\ud328\ud0a4\uc9d5 \uc911 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.\n\n" + e.getMessage()));
            GomsLogPart.log(GomsLogPart.LogLevel.ERROR, "\ud328\ud0a4\uc9d5 \uc911 \uc608\uc678 - \ud504\ub85c\uc81d\ud2b8: " + project.getName() + ", \uba54\uc2dc\uc9c0: " + e.getMessage());
        }
    }

    private Optional<IProject> getCurrentProject() {
        IStructuredSelection ssel;
        Object obj;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel instanceof IStructuredSelection && (obj = (ssel = (IStructuredSelection)sel).getFirstElement()) instanceof IResource) {
            IResource res = (IResource)obj;
            return Optional.of(res.getProject());
        }
        return Optional.empty();
    }

    private void openDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(dir);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Program.launch((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

