/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Named;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.security.GomsPackagingCrypto;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GomsUnPackagingHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, EPartService partService) {
        IProject project = EpubBuildUtil.getIProject();
        try {
            IFolder unpackRoot;
            IFolder distFolder = project.getFolder("dist");
            if (!distFolder.exists()) {
                distFolder.create(true, true, null);
            }
            Path distDir = distFolder.getLocation().toFile().toPath();
            FileDialog fileDialog = new FileDialog(shell, 4096);
            fileDialog.setText("\uc5b8\ud328\ud0a4\uc9d5\ud560 .goms \ud30c\uc77c \uc120\ud0dd");
            fileDialog.setFilterExtensions(new String[]{"*.goms"});
            fileDialog.setFilterNames(new String[]{"GomsBook \ud328\ud0a4\uc9c0 (*.goms)"});
            fileDialog.setFilterPath(distDir.toString());
            String gomsPathStr = fileDialog.open();
            if (gomsPathStr == null || gomsPathStr.isBlank()) {
                GomsLogPart.logInfo("\uc5b8\ud328\ud0a4\uc9d5 \ucde8\uc18c - .goms \ud30c\uc77c \uc120\ud0dd \ucde8\uc18c\ub428");
                return;
            }
            Path gomsPath = Paths.get(gomsPathStr, new String[0]);
            if (!Files.exists(gomsPath, new LinkOption[0]) || !gomsPath.toString().toLowerCase().endsWith(".goms")) {
                MessageDialog.openError((Shell)shell, (String)"GomsBook \uc5b8\ud328\ud0a4\uc9d5", (String)("\uc720\ud6a8\ud55c .goms \ud30c\uc77c\uc774 \uc544\ub2d9\ub2c8\ub2e4.\n\uacbd\ub85c: " + gomsPath.toString()));
                GomsLogPart.logWarn("\uc5b8\ud328\ud0a4\uc9d5 \uc2e4\ud328 - \uc798\ubabb\ub41c .goms \ud30c\uc77c: " + gomsPath.toString());
                return;
            }
            String baseName = gomsPath.getFileName().toString();
            if (baseName.toLowerCase().endsWith(".goms")) {
                baseName = baseName.substring(0, baseName.length() - 5);
            }
            if (!(unpackRoot = project.getFolder("dist/unpacked")).exists()) {
                unpackRoot.create(true, true, null);
            }
            Path unpackRootDir = unpackRoot.getLocation().toFile().toPath();
            Path targetDir = unpackRootDir.resolve(baseName);
            AtomicReference<Object> errorRef = new AtomicReference<Object>(null);
            long start = System.currentTimeMillis();
            GomsLogPart.logInfo(String.format("\uc5b8\ud328\ud0a4\uc9d5 \uc2dc\uc791 - \ud504\ub85c\uc81d\ud2b8: %s, goms: %s, \ucd9c\ub825 \ud3f4\ub354: %s", project.getName(), gomsPath.toString(), targetDir.toString()));
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, false, monitor -> {
                monitor.beginTask("GomsBook \ud328\ud0a4\uc9c0 \uc5b8\ud328\ud0a4\uc9d5 \uc911...", 100);
                try {
                    monitor.subTask("\ucd9c\ub825 \ud3f4\ub354 \uc900\ube44 \uc911...");
                    if (!Files.exists(targetDir, new LinkOption[0])) {
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                    }
                    monitor.worked(10);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.subTask(".goms \ubcf5\ud638\ud654 \ubc0f \uc555\ucd95 \ud574\uc81c \uc911...");
                    GomsPackagingCrypto.decryptGomsToDirectory(gomsPath, targetDir);
                    monitor.worked(70);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        monitor.subTask("\ud504\ub85c\uc81d\ud2b8 \ub9ac\ud504\ub808\uc2dc \uc911...");
                        project.refreshLocal(2, null);
                        monitor.worked(20);
                    }
                    catch (Exception ex) {
                        errorRef.set(ex);
                    }
                }
                finally {
                    monitor.done();
                }
            });
            long end = System.currentTimeMillis();
            double elapsedSec = (double)(end - start) / 1000.0;
            Exception err = errorRef.get();
            if (err != null) {
                err.printStackTrace();
                MessageDialog.openError((Shell)shell, (String)"GomsBook \uc5b8\ud328\ud0a4\uc9d5 \uc624\ub958", (String)("\uc5b8\ud328\ud0a4\uc9d5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.\n\n" + err.getMessage()));
                GomsLogPart.log(GomsLogPart.LogLevel.ERROR, String.format("\uc5b8\ud328\ud0a4\uc9d5 \uc2e4\ud328 - \ud504\ub85c\uc81d\ud2b8: %s, goms: %s, \uba54\uc2dc\uc9c0: %s, \uc18c\uc694 \uc2dc\uac04: %.2f\ucd08", project.getName(), gomsPath.toString(), err.getMessage(), elapsedSec));
                return;
            }
            MessageDialog.openInformation((Shell)shell, (String)"GomsBook \uc5b8\ud328\ud0a4\uc9d5 \uc644\ub8cc", (String)String.format("\uc5b8\ud328\ud0a4\uc9d5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\n\ub300\uc0c1 \ud30c\uc77c:\n%s\n\n\ucd9c\ub825 \ud3f4\ub354:\n%s\n\n\uc18c\uc694 \uc2dc\uac04: %.2f\ucd08", gomsPath.toString(), targetDir.toString(), elapsedSec));
            this.openDirectory(targetDir.toFile());
            GomsLogPart.log(GomsLogPart.LogLevel.INFO, String.format("\uc5b8\ud328\ud0a4\uc9d5 \uc644\ub8cc - \ud504\ub85c\uc81d\ud2b8: %s, goms: %s, \ucd9c\ub825: %s, \uc18c\uc694 \uc2dc\uac04: %.2f\ucd08", project.getName(), gomsPath.toString(), targetDir.toString(), elapsedSec));
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"GomsBook \uc5b8\ud328\ud0a4\uc9d5 \uc624\ub958", (String)("\uc5b8\ud328\ud0a4\uc9d5 \uc911 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.\n\n" + e.getMessage()));
            GomsLogPart.log(GomsLogPart.LogLevel.ERROR, "\uc5b8\ud328\ud0a4\uc9d5 \uc911 \uc608\uc678 - \ud504\ub85c\uc81d\ud2b8: " + project.getName() + ", \uba54\uc2dc\uc9c0: " + e.getMessage());
        }
    }

    private Optional<IProject> getCurrentProject() {
        IStructuredSelection ssel;
        Object obj;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel instanceof IStructuredSelection && (obj = (ssel = (IStructuredSelection)sel).getFirstElement()) instanceof IResource) {
            IResource res = (IResource)obj;
            return Optional.of(res.getProject());
        }
        return Optional.empty();
    }

    private void openDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(dir);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Program.launch((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

