/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Display;

public class GotoAndHighlightHandler {
    @Inject
    @Optional
    @Active
    private SourceViewer viewer;
    @Inject
    @Named(value="e4ActivePart")
    private MPart activePart;

    @Execute
    public void run(@Named(value="line") int line, @Named(value="column") int column) {
        SourceViewer v = this.viewer;
        if (v == null) {
            IEclipseContext ctx = this.activePart != null ? this.activePart.getContext() : null;
            SourceViewer sourceViewer = v = ctx != null ? (SourceViewer)ctx.get(SourceViewer.class) : null;
        }
        if (v == null || v.getDocument() == null) {
            this.retry(10, 80, (Supplier<Boolean>)((Supplier)() -> {
                SourceViewer vv;
                IEclipseContext ctx = this.activePart != null ? this.activePart.getContext() : null;
                SourceViewer sourceViewer = vv = ctx != null ? (SourceViewer)ctx.get(SourceViewer.class) : null;
                if (vv != null && vv.getDocument() != null) {
                    return true;
                }
                return false;
            }), () -> {
                IEclipseContext ctx = this.activePart != null ? this.activePart.getContext() : null;
                SourceViewer vv = ctx != null ? (SourceViewer)ctx.get(SourceViewer.class) : null;
                this.gotoAndSelect(vv, line, column);
            });
            return;
        }
        this.gotoAndSelect(v, line, column);
    }

    private void gotoAndSelect(SourceViewer v, int oneBasedLine, int oneBasedCol) {
        try {
            IDocument doc = v.getDocument();
            int offset = GotoAndHighlightHandler.safeOffset(doc, oneBasedLine, oneBasedCol);
            v.revealRange(offset, 1);
            v.setSelectedRange(offset, 1);
            IAnnotationModel iAnnotationModel = v.getAnnotationModel();
        }
        catch (BadLocationException badLocationException) {}
    }

    private void retry(int tries, int delayMs, Supplier<Boolean> ready, Runnable task) {
        if (((Boolean)ready.get()).booleanValue()) {
            task.run();
            return;
        }
        if (tries <= 0) {
            return;
        }
        Display.getDefault().timerExec(delayMs, () -> this.retry(tries - 1, delayMs, ready, task));
    }

    private static int safeOffset(IDocument doc, int oneBasedLine, int oneBasedCol) throws BadLocationException {
        int li = Math.max(0, Math.min(oneBasedLine - 1, Math.max(0, doc.getNumberOfLines() - 1)));
        int lineOffset = doc.getLineOffset(li);
        int lineLen = doc.getLineLength(li);
        int col = Math.max(1, oneBasedCol);
        int colOffset = Math.min(col - 1, Math.max(0, lineLen - 1));
        return Math.max(0, Math.min(lineOffset + colOffset, Math.max(0, doc.getLength() - 1)));
    }
}

