/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomSerializer;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlCleanHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext parentContext) {
        System.out.println("EPub HtmlCleanHandler");
        String oebpsTextFolder = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        File folder = new File(oebpsTextFolder);
        File[] xhtmlFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".xhtml"));
        if (xhtmlFiles == null || xhtmlFiles.length == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"\uc548\ub0b4", (String)"XHTML \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        try {
            progressDialog.run(true, true, monitor -> {
                monitor.beginTask("HTML \uc815\ub9ac \uc911...", xhtmlFiles.length);
                File[] fileArray2 = xhtmlFiles;
                int n = xhtmlFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    if (monitor.isCanceled()) break;
                    monitor.subTask(file.getName());
                    try {
                        this.cleanAndFormatHtml(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"\ucc98\ub9ac \uc2e4\ud328", (String)(file.getName() + " \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd:\n" + e.getMessage())));
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            });
            MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)"HTML \uc815\ub9ac \uc644\ub8cc!");
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("\ucc98\ub9ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4:\n" + e.getMessage()));
        }
    }

    private void cleanAndFormatHtml(File file) throws IOException {
        String withTabs;
        Document doc;
        TagNode rootNode;
        String raw = Files.readString(file.toPath(), StandardCharsets.UTF_8);
        if (!raw.isEmpty() && raw.charAt(0) == '\ufeff') {
            raw = raw.substring(1);
        }
        raw = raw.strip();
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        props.setOmitComments(true);
        props.setOmitDoctypeDeclaration(false);
        props.setRecognizeUnicodeChars(true);
        props.setTranslateSpecialEntities(true);
        props.setTreatUnknownTagsAsContent(false);
        props.setAdvancedXmlEscape(true);
        props.setUseEmptyElementTags(true);
        props.setAllowMultiWordAttributes(true);
        props.setOmitXmlDeclaration(false);
        props.setOmitHtmlEnvelope(true);
        props.setAllowHtmlInsideAttributes(true);
        Throwable throwable = null;
        Object var7_7 = null;
        try (StringReader reader = new StringReader(raw);){
            rootNode = cleaner.clean((Reader)reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            doc = new DomSerializer(props, true).createDOM(rootNode);
        }
        catch (Exception e) {
            throw new IOException("DOM serialization failed", e);
        }
        HtmlCleanHandler.stripWhitespaceTextNodes(doc);
        String pretty = HtmlCleanHandler.transformDomToString(doc, 1);
        String out = withTabs = HtmlCleanHandler.leadingSpacesToTabs(pretty);
        out = out.replaceAll("(?m)^[ \t]+$", "");
        out = out.replaceAll("(?:\\r?\\n){2,}", "\n");
        out = out.replaceFirst("\\A\\s+", "").replaceAll("\\s+\\z", "");
        out = out.replaceFirst("\\s+standalone=\"no\"", "");
        out = out.replaceFirst("(?m)^<!DOCTYPE\\s+html\\s+PUBLIC\\s+\"\"\\s+\"\">\\s*\\r?\\n?", "");
        out = out.replace("\r\n", "\n");
        Files.writeString(file.toPath(), (CharSequence)out, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String transformDomToString(Document doc, int indentSpacesPerLevel) throws IOException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentSpacesPerLevel));
            DocumentType dt = doc.getDoctype();
            if (dt != null) {
                if (dt.getPublicId() != null && !dt.getPublicId().isEmpty()) {
                    t.setOutputProperty("doctype-public", dt.getPublicId());
                }
                if (dt.getSystemId() != null && !dt.getSystemId().isEmpty()) {
                    t.setOutputProperty("doctype-system", dt.getSystemId());
                }
            }
            StringWriter out = new StringWriter();
            t.transform(new DOMSource(doc), new StreamResult(out));
            return out.toString();
        }
        catch (Exception e) {
            throw new IOException("DOM transform failed", e);
        }
    }

    private static String leadingSpacesToTabs(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        Matcher m = Pattern.compile("(?m)^ +").matcher(s);
        int last = 0;
        while (m.find()) {
            sb.append(s, last, m.start());
            int n = m.end() - m.start();
            sb.append("\t".repeat(n));
            last = m.end();
        }
        sb.append(s, last, s.length());
        return sb.toString();
    }

    private static void stripWhitespaceTextNodes(Document doc) throws IOException {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node n = nodes.item(i);
                Node p = n.getParentNode();
                if (p != null) {
                    p.removeChild(n);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new IOException("Whitespace text cleanup failed", e);
        }
    }
}

