/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.dialogs.InfoInsertDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class InsertInfoAtCaretHandler {
    @Inject
    @Optional
    private SourceViewer sourceViewer;

    @CanExecute
    public boolean canExecute(EPartService ps, @Optional SourceViewer injectedSV) {
        MPart active = ps.getActivePart();
        if (active == null) {
            return false;
        }
        SourceViewer sv = injectedSV;
        if (sv == null && active.getContext() != null) {
            sv = (SourceViewer)active.getContext().get(SourceViewer.class);
        }
        if (sv == null) {
            return false;
        }
        Object f = active.getTransientData().get("currentFile");
        return f instanceof IFile;
    }

    @Execute
    public void execute(Shell shell, EPartService partService, @Optional SourceViewer injectedSV) {
        IEclipseContext partCtx;
        MPart activePart = partService.getActivePart();
        if (activePart == null) {
            InsertInfoAtCaretHandler.msg(shell, "\ud65c\uc131 \ud3b8\uc9d1\uae30\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        SourceViewer sourceViewer = injectedSV;
        if (sourceViewer == null && (partCtx = activePart.getContext()) != null) {
            sourceViewer = (SourceViewer)partCtx.get(SourceViewer.class);
        }
        if (sourceViewer == null) {
            InsertInfoAtCaretHandler.msg(shell, "SourceViewer\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc5d0\ub514\ud130\uc5d0\uc11c context.set(SourceViewer.class, viewer) \ud588\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.");
            return;
        }
        Object tf = activePart.getTransientData().get("currentFile");
        if (!(tf instanceof IFile)) {
            InsertInfoAtCaretHandler.msg(shell, "\ud604\uc7ac \ud30c\uc77c(IFile)\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. part.getTransientData().put(\"currentFile\", iFile) \uc124\uc815\uc744 \ud655\uc778\ud558\uc138\uc694.");
            return;
        }
        IFile currentFile = (IFile)tf;
        InfoInsertDialog dlg = new InfoInsertDialog(shell);
        if (dlg.open() != 0) {
            return;
        }
        try {
            IProject project = currentFile.getProject();
            IFolder imagesFolder = project.getFolder("OEBPS/Images");
            InsertInfoAtCaretHandler.ensureFolder(imagesFolder);
            String fileName = currentFile.getName();
            String chapterBase = InsertInfoAtCaretHandler.deriveChapterBase(fileName);
            String docText = sourceViewer.getDocument().get();
            int pIndex = InsertInfoAtCaretHandler.nextPIndex(docText, chapterBase);
            String pId = chapterBase + "_p_" + pIndex;
            String colorName = dlg.getSelectedColorName().toLowerCase();
            StringBuffer barColorClass = new StringBuffer();
            barColorClass.append(colorName).append("-bar");
            String html = InsertInfoAtCaretHandler.buildInfoHtml(dlg.getDescription(), pId, barColorClass.toString());
            IDocument doc = sourceViewer.getDocument();
            int offset = sourceViewer.widgetOffset2ModelOffset(sourceViewer.getTextWidget().getCaretOffset());
            doc.replace(offset, 0, "\n" + html + "\n");
        }
        catch (Exception e) {
            InsertInfoAtCaretHandler.msg(shell, "\uc815\ubcf4 \uc0bd\uc785 \uc911 \uc624\ub958: " + e.getMessage());
        }
    }

    private static void msg(Shell shell, String m) {
        MessageBox mb = new MessageBox(shell, 34);
        mb.setText("Insert Figure");
        mb.setMessage(m);
        mb.open();
    }

    private static void ensureFolder(IFolder folder) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            InsertInfoAtCaretHandler.ensureFolder((IFolder)parent);
        }
        if (parent instanceof IProject && !((IProject)parent).isOpen()) {
            ((IProject)parent).open(null);
        }
        folder.create(true, true, null);
    }

    private static String buildInfoHtml(String desc, String nonPId, String barClass) {
        String safeDesc = InsertInfoAtCaretHandler.esc(desc);
        safeDesc = safeDesc.replaceAll("\\r?\\n", "<br/>");
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"info-box\">\n");
        sb.append("  <div class=\"").append(InsertInfoAtCaretHandler.escAttr(barClass)).append("\"></div>\n");
        sb.append("  <div class=\"info-text\">");
        sb.append("  <p id=\"").append(InsertInfoAtCaretHandler.escAttr(nonPId)).append("\"> ");
        sb.append(safeDesc);
        sb.append("  </p>\n");
        sb.append("  </div>");
        sb.append("</div>");
        return sb.toString();
    }

    private static String escapeAttr(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String deriveChapterBase(String fileName) {
        int dot = fileName.indexOf(46);
        String base = dot > 0 ? fileName.substring(0, dot) : fileName;
        return base.toLowerCase().startsWith("chapter") ? base : "chapter";
    }

    private static int nextPIndex(String docText, String chapterBase) {
        Pattern p = Pattern.compile(Pattern.quote(chapterBase) + "_p_(\\d+)");
        Matcher m = p.matcher(docText);
        int max = 0;
        while (m.find()) {
            try {
                int n = Integer.parseInt(m.group(1));
                if (n <= max) continue;
                max = n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max + 1;
    }

    private static String esc(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String escAttr(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private static String uniqueName(IFolder folder, String base, String ext) throws CoreException {
        String cleanBase = base.replaceAll("[^a-zA-Z0-9._-]", "_");
        String candidate = cleanBase + (String)(ext.isEmpty() ? "" : "." + ext);
        int i = 2;
        while (folder.getFile(candidate).exists()) {
            candidate = cleanBase + "_" + i + (String)(ext.isEmpty() ? "" : "." + ext);
            ++i;
        }
        return candidate;
    }
}

