/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.dialogs.TableSizeDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class InsertTableAtCaretHandler {
    @Inject
    @Optional
    private SourceViewer sourceViewer;

    @CanExecute
    public boolean canExecute(EPartService ps, @Optional SourceViewer injectedSV) {
        MPart active = ps.getActivePart();
        if (active == null) {
            return false;
        }
        SourceViewer sv = injectedSV;
        if (sv == null && active.getContext() != null) {
            sv = (SourceViewer)active.getContext().get(SourceViewer.class);
        }
        if (sv == null) {
            return false;
        }
        Object f = active.getTransientData().get("currentFile");
        return f instanceof IFile;
    }

    @Execute
    public void execute(Shell shell, EPartService partService, @Optional SourceViewer injectedSV) {
        IEclipseContext partCtx;
        MPart activePart = partService.getActivePart();
        if (activePart == null) {
            InsertTableAtCaretHandler.msg(shell, "\ud65c\uc131 \ud3b8\uc9d1\uae30\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        SourceViewer sourceViewer = injectedSV;
        if (sourceViewer == null && (partCtx = activePart.getContext()) != null) {
            sourceViewer = (SourceViewer)partCtx.get(SourceViewer.class);
        }
        if (sourceViewer == null) {
            InsertTableAtCaretHandler.msg(shell, "SourceViewer\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc5d0\ub514\ud130\uc5d0\uc11c context.set(SourceViewer.class, viewer) \ud588\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.");
            return;
        }
        Object tf = activePart.getTransientData().get("currentFile");
        if (!(tf instanceof IFile)) {
            InsertTableAtCaretHandler.msg(shell, "\ud604\uc7ac \ud30c\uc77c(IFile)\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. part.getTransientData().put(\"currentFile\", iFile) \uc124\uc815\uc744 \ud655\uc778\ud558\uc138\uc694.");
            return;
        }
        TableSizeDialog dlg = new TableSizeDialog(shell);
        if (dlg.open() != 0) {
            return;
        }
        try {
            String html;
            boolean useSelection;
            IDocument doc = sourceViewer.getDocument();
            String baseName = "table";
            if (tf instanceof IFile) {
                IFile iFile = (IFile)tf;
                String name = iFile.getName();
                int dot = name.lastIndexOf(46);
                baseName = dot > 0 ? name.substring(0, dot) : name;
            }
            int maxIdx = this.findMaxTableIndex(doc.get(), baseName);
            String tableId = baseName + "_table_" + (maxIdx + 1);
            String selected = sourceViewer.getTextWidget().getSelectionText();
            boolean bl = useSelection = dlg.isUseSelection() && selected != null && !selected.isBlank();
            if (useSelection) {
                ParsedTable parsed = this.parseSelection(selected);
                if (parsed.cols == 0 || parsed.rows == 0) {
                    MessageDialog.openWarning((Shell)shell, (String)"\uc120\ud0dd \ud30c\uc2f1 \uc2e4\ud328", (String)"\uc120\ud0dd\ub41c \ud14d\uc2a4\ud2b8\uc5d0\uc11c \ud589/\uc5f4\uc744 \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
                    return;
                }
                html = this.buildTableHtml(parsed.rows, parsed.cols, dlg.isHeader(), dlg.isHeaderFirstCol(), dlg.getCaption(), tableId, dlg.getColPercents(), dlg.getColAligns(), parsed.data);
            } else {
                html = this.buildTableHtml(dlg.getRows(), dlg.getCols(), dlg.isHeader(), dlg.isHeaderFirstCol(), dlg.getCaption(), tableId, dlg.getColPercents(), dlg.getColAligns(), null);
            }
            int caretWidget = sourceViewer.getTextWidget().getCaretOffset();
            int offset = sourceViewer.widgetOffset2ModelOffset(caretWidget);
            String toInsert = "\n" + html + "\n";
            doc.replace(offset, 0, toInsert);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"\uc0bd\uc785 \uc2e4\ud328", (String)("\ud45c \uc0bd\uc785 \uc911 \uc624\ub958:\n" + e.getMessage()));
        }
    }

    private int findMaxTableIndex(String text, String base) {
        Pattern p = Pattern.compile("<table[^>]*\\bid\\s*=\\s*\"" + Pattern.quote(base) + "_table_(\\d+)\"", 2);
        Matcher m = p.matcher(text);
        int max = 0;
        while (m.find()) {
            try {
                int n = Integer.parseInt(m.group(1));
                if (n <= max) continue;
                max = n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max;
    }

    private ParsedTable parseSelection(String text) {
        int c;
        String[] lines = text.replace("\r\n", "\n").replace('\r', '\n').split("\n", -1);
        boolean hasTab = text.contains("\t");
        int rows = 0;
        int cols = 0;
        String[][] data = new String[lines.length][];
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (!line.isEmpty()) {
                String[] cells = hasTab ? line.split("\t", -1) : line.split(",", -1);
                c = 0;
                while (c < cells.length) {
                    cells[c] = cells[c].trim();
                    ++c;
                }
                data[rows++] = cells;
                cols = Math.max(cols, cells.length);
            }
            ++i;
        }
        String[][] trimmed = new String[rows][cols];
        int r = 0;
        while (r < rows) {
            trimmed[r] = new String[cols];
            String[] src = data[r];
            c = 0;
            while (c < cols) {
                trimmed[r][c] = c < src.length ? src[c] : "";
                ++c;
            }
            ++r;
        }
        ParsedTable pt = new ParsedTable();
        pt.rows = rows;
        pt.cols = cols;
        pt.data = trimmed;
        return pt;
    }

    private String buildTableHtml(int rows, int cols, boolean headerRow, boolean headerFirstCol, String caption, String tableId, String colPercents, String colAligns, String[][] data) {
        int bodyRows;
        int startRow;
        int c;
        if (rows < 1) {
            rows = 1;
        }
        if (cols < 1) {
            cols = 1;
        }
        String[] widths = this.splitCsv(colPercents, cols);
        String[] aligns = this.normalizeAligns(this.splitCsv(colAligns, cols), cols);
        StringBuilder sb = new StringBuilder();
        sb.append("<table");
        sb.append(" class=\"table03\" style=\"width:100%; border-collapse:collapse;\" ");
        if (!this.isBlank(tableId)) {
            sb.append(" id=\"").append(this.escapeAttr(tableId)).append("\"");
        }
        sb.append(">\n");
        if (!this.isBlank(caption)) {
            sb.append("  <caption>").append(this.escapeText(caption)).append("</caption>\n");
        }
        if (this.hasAny(widths)) {
            sb.append("  <colgroup>\n");
            c = 0;
            while (c < cols) {
                String w = widths[c];
                if (!this.isBlank(w)) {
                    sb.append("    <col style=\"width:").append(this.escapeCssPercent(w)).append(";\"/>\n");
                } else {
                    sb.append("    <col/>\n");
                }
                ++c;
            }
            sb.append("  </colgroup>\n");
        }
        if (headerRow) {
            sb.append("  <thead>\n    <tr>\n");
            c = 0;
            while (c < cols) {
                String align = aligns[c];
                sb.append("      <th scope=\"col\"");
                if (!this.isBlank(align)) {
                    sb.append(" style=\"text-align:").append(align).append(";\"");
                }
                sb.append(">");
                String cell = data != null && data.length > 0 && data[0].length > c ? data[0][c] : "\ud5e4\ub354" + (c + 1);
                sb.append(this.escapeText(cell)).append("</th>\n");
                ++c;
            }
            sb.append("    </tr>\n  </thead>\n");
        }
        sb.append("  <tbody>\n");
        int n = startRow = headerRow && data != null ? 1 : 0;
        int n2 = data != null ? Math.max(0, data.length - startRow) : (bodyRows = rows - (headerRow ? 1 : 0));
        if (bodyRows < 0) {
            bodyRows = 0;
        }
        int r = 0;
        while (r < bodyRows) {
            sb.append("    <tr>\n");
            int c2 = 0;
            while (c2 < cols) {
                int srcRow;
                String align = aligns[c2];
                boolean isRowHeader = headerFirstCol && c2 == 0;
                String tag = isRowHeader ? "th" : "td";
                sb.append("      <").append(tag);
                if (isRowHeader) {
                    sb.append(" scope=\"row\"");
                }
                if (!this.isBlank(align)) {
                    sb.append(" style=\"text-align:").append(align).append(";\"");
                }
                sb.append(">");
                Object txt = data != null ? ((srcRow = r + startRow) < data.length && c2 < data[srcRow].length ? data[srcRow][c2] : "") : (isRowHeader ? "\ud56d\ubaa9" : "\ub0b4\uc6a9") + (r + 1) + "-" + (c2 + 1);
                sb.append(this.escapeText((String)txt));
                sb.append("</").append(tag).append(">\n");
                ++c2;
            }
            sb.append("    </tr>\n");
            ++r;
        }
        if (data == null && bodyRows <= 0) {
            sb.append("    <tr>\n");
            int c3 = 0;
            while (c3 < cols) {
                String align;
                boolean isRowHeader = headerFirstCol && c3 == 0;
                String tag = isRowHeader ? "th" : "td";
                sb.append("      <").append(tag);
                if (isRowHeader) {
                    sb.append(" scope=\"row\"");
                }
                if (!this.isBlank(align = aligns[c3])) {
                    sb.append(" style=\"text-align:").append(align).append(";\"");
                }
                sb.append(">");
                sb.append(isRowHeader ? "\ud56d\ubaa91" : "\ub0b4\uc6a91-").append(c3 + 1);
                sb.append("</").append(tag).append(">\n");
                ++c3;
            }
            sb.append("    </tr>\n");
        }
        sb.append("  </tbody>\n</table>");
        return sb.toString();
    }

    private String[] splitCsv(String s, int cols) {
        String[] out = new String[cols];
        if (this.isBlank(s)) {
            return out;
        }
        String[] raw = s.split(",", -1);
        int i = 0;
        while (i < cols) {
            out[i] = i < raw.length ? raw[i].trim() : "";
            ++i;
        }
        return out;
    }

    private boolean hasAny(String[] arr) {
        if (arr == null) {
            return false;
        }
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!this.isBlank(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] normalizeAligns(String[] aligns, int cols) {
        String[] out = new String[cols];
        int i = 0;
        while (i < cols) {
            String a;
            String string = a = aligns != null && i < aligns.length ? aligns[i] : "";
            if (a == null) {
                a = "";
            }
            switch (a = a.trim().toUpperCase()) {
                case "L": {
                    out[i] = "left";
                    break;
                }
                case "C": {
                    out[i] = "center";
                    break;
                }
                case "R": {
                    out[i] = "right";
                    break;
                }
                default: {
                    out[i] = "";
                }
            }
            ++i;
        }
        return out;
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private String escapeText(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String escapeAttr(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private String escapeCssPercent(String s) {
        String t = s.trim();
        if (t.endsWith("%")) {
            return t;
        }
        return t + "%";
    }

    private static void msg(Shell shell, String m) {
        MessageBox mb = new MessageBox(shell, 34);
        mb.setText("Insert Figure");
        mb.setMessage(m);
        mb.open();
    }

    private static class ParsedTable {
        int rows;
        int cols;
        String[][] data;

        private ParsedTable() {
        }
    }
}

