/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Optional;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.ContentOpfUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpfDedupeHandler {
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(final Shell shell, @Named(value="org.eclipse.ui.selection") Object selection) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        final IFile opfFile = iFolder.getProject().getFile("OEBPS/content.opf");
        Job job = new Job("Deduplicate content.opf (metadata & spine)"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Cleaning duplicates in " + String.valueOf(opfFile.getFullPath()), -1);
                try {
                    opfFile.getWorkspace().run(pm -> {
                        try {
                            ContentOpfUtil.dedupeMetadataManifestAndSpine(opfFile);
                            opfFile.refreshLocal(0, pm);
                        }
                        catch (Exception e) {
                            throw new CoreException((IStatus)new Status(4, "epubtest03", e.getMessage(), (Throwable)e));
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                    OpfDedupeHandler.this.eventBroker.post("gomsbook/opf/updated", Map.of("file", opfFile));
                    Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)"OPF \uc911\ubcf5 \uc81c\uac70", (String)("\uc644\ub8cc: " + String.valueOf(opfFile.getFullPath()))));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CoreException e) {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"OPF \uc911\ubcf5 \uc81c\uac70 \uc2e4\ud328", (String)(e.getStatus() != null ? e.getStatus().getMessage() : e.getMessage())));
                    IStatus iStatus = e.getStatus() != null ? e.getStatus() : new Status(4, "epubtest03", e.getMessage(), (Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }

    private Optional<IFile> resolveContentOpf(Object selection) {
        try {
            if (selection instanceof IFile) {
                IFile sibling;
                IFile f = (IFile)selection;
                if ("content.opf".equalsIgnoreCase(f.getName())) {
                    return Optional.of(f);
                }
                if (f.getParent() instanceof IContainer && (sibling = f.getParent().getFile((IPath)new Path("content.opf"))).exists()) {
                    return Optional.of(sibling);
                }
            } else if (selection instanceof IContainer) {
                IFile f = this.findOpfIn((IContainer)selection);
                if (f != null) {
                    return Optional.of(f);
                }
            } else if (selection instanceof IAdaptable) {
                IFile f;
                IResource r = (IResource)((IAdaptable)selection).getAdapter(IResource.class);
                if (r instanceof IFile) {
                    return this.resolveContentOpf(r);
                }
                if (r instanceof IContainer && (f = this.findOpfIn((IContainer)r)) != null) {
                    return Optional.of(f);
                }
            }
        }
        catch (Exception exception) {}
        return Optional.empty();
    }

    private Optional<IFile> resolveContentOpf(IResource r) {
        if (r instanceof IFile) {
            IFile sibling;
            IFile f = (IFile)r;
            if ("content.opf".equalsIgnoreCase(f.getName())) {
                return Optional.of(f);
            }
            if (f.getParent() instanceof IContainer && (sibling = f.getParent().getFile((IPath)new Path("content.opf"))).exists()) {
                return Optional.of(sibling);
            }
        } else if (r instanceof IContainer) {
            IFile f = null;
            try {
                f = this.findOpfIn((IContainer)r);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (f != null) {
                return Optional.of(f);
            }
        }
        return Optional.empty();
    }

    private IFile findOpfIn(IContainer container) throws CoreException {
        if (container == null || !container.exists()) {
            return null;
        }
        IFile[] found = new IFile[1];
        container.accept(res -> {
            if (found[0] != null) {
                return false;
            }
            if (res.getType() == 1 && "content.opf".equalsIgnoreCase(res.getName())) {
                iFileArray[0] = (IFile)res;
                return false;
            }
            return true;
        });
        return found[0];
    }
}

