/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ResizeImageHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext parentContext) {
        System.out.println("EPub ResizeImageHandler");
        String oebpsImagesFolder = EpubBuildUtil.getProjectOEBPSSubFolder("Images");
        File imagesFolder = new File(oebpsImagesFolder);
        File[] imageFiles = imagesFolder.listFiles();
        StringBuilder listItems = new StringBuilder();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        try {
            progressDialog.run(true, true, monitor -> {
                monitor.beginTask("\uc774\ubbf8\uc9c0 \ub9ac\uc0ac\uc774\uc988 \uc911...", imageFiles.length);
                File[] fileArray2 = imageFiles;
                int n = imageFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    if (monitor.isCanceled()) break;
                    monitor.subTask(file.getName());
                    try {
                        StringBuilder item = ResizeImageHandler.resizeImageIfNeeded(file);
                        listItems.append((CharSequence)item);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"\ucc98\ub9ac \uc2e4\ud328", (String)(file.getName() + " \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd:\n" + e.getMessage())));
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            });
            MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)"\uc774\ubbf8\uc9c0 \ub9ac\uc0ac\uc774\uc988 \uc644\ub8cc!");
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("\ucc98\ub9ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4:\n" + e.getMessage()));
        }
    }

    private static StringBuilder resizeImageIfNeeded(File file) {
        BufferedImage original;
        StringBuilder log = new StringBuilder();
        if (file == null || !file.isFile()) {
            return log.append("Skip: not a file\n");
        }
        String name = file.getName().toLowerCase();
        if (name.contains("cover")) {
            return log.append("Skip: cover image (").append(name).append(")\n");
        }
        String ext = ResizeImageHandler.getExtension(name);
        if (!(ext.equals("jpg") || ext.equals("jpeg") || ext.equals("png") || ext.equals("gif"))) {
            return log.append("Skip: not an image (").append(name).append(")\n");
        }
        try {
            original = ImageIO.read(file);
            if (original == null) {
                return log.append("Skip: unreadable image (").append(name).append(")\n");
            }
        }
        catch (IOException e) {
            return log.append("Error reading ").append(name).append(": ").append(e.getMessage()).append("\n");
        }
        int width = original.getWidth();
        int height = original.getHeight();
        if (width <= 950) {
            return log.append("Keep: ").append(name).append(" (").append(width).append("x").append(height).append(")\n");
        }
        int newWidth = 950;
        int newHeight = (int)Math.round((double)height * (950.0 / (double)width));
        int type = ext.equals("png") || ext.equals("gif") ? 2 : 1;
        BufferedImage resized = new BufferedImage(newWidth, newHeight, type);
        Graphics2D g2d = resized.createGraphics();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawImage(original, 0, 0, newWidth, newHeight, null);
        }
        finally {
            g2d.dispose();
        }
        try {
            if (ext.equals("jpg") || ext.equals("jpeg")) {
                ResizeImageHandler.saveJpegWithQuality(resized, file, 0.85f);
            } else {
                ImageIO.write((RenderedImage)resized, ext, file);
            }
            log.append("Resized: ").append(name).append(" ").append(width).append("x").append(height).append(" -> ").append(newWidth).append("x").append(newHeight).append("\n");
        }
        catch (IOException e) {
            log.append("Error writing ").append(name).append(": ").append(e.getMessage()).append("\n");
        }
        return log;
    }

    private static String getExtension(String name) {
        int idx = name.lastIndexOf(46);
        return idx >= 0 && idx < name.length() - 1 ? name.substring(idx + 1).toLowerCase() : "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveJpegWithQuality(BufferedImage image, File file, float quality) throws IOException {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        if (jpgWriteParam.canWriteCompressed()) {
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(quality);
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    try (ImageOutputStream ios = ImageIO.createImageOutputStream(fos);){
                        jpgWriter.setOutput(ios);
                        jpgWriter.write(null, new IIOImage(image, null, null), jpgWriteParam);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            jpgWriter.dispose();
        }
    }
}

