/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Named;
import java.util.HashMap;
import kr.co.goms.epub.menu.ExplorerNode;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class SaveAsXhtmlFileHandler {
    /*
     * WARNING - void declaration
     */
    @CanExecute
    public boolean canExec(@Named(value="org.eclipse.ui.selection") IStructuredSelection sel) {
        void f;
        if (sel == null || sel.isEmpty() || sel.size() != 1) {
            return false;
        }
        Object o = sel.getFirstElement();
        IFile file = (IFile)Platform.getAdapterManager().getAdapter(o, IFile.class);
        if (file == null || !file.exists()) {
            return false;
        }
        if (!"xhtml".equalsIgnoreCase(file.getFileExtension())) {
            return false;
        }
        IContainer parent = file.getParent();
        if (!(parent instanceof IFolder)) {
            return false;
        }
        IFolder iFolder = (IFolder)parent;
        String path = f.getFullPath().toString().toLowerCase();
        return path.contains("/oebps/text") || path.endsWith("/text") || path.contains("/text/");
    }

    @Execute
    public void run(Shell shell, @Optional @Named(value="org.eclipse.ui.selection") Object selection, IEventBroker eventBroker, ExplorerNode fileNode) throws Exception {
        IFolder targetFolder;
        IFolder pf;
        IFile src = EpubBuildUtil.fileOf(selection).orElse(null);
        if (src == null || !src.exists()) {
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)"\uc120\ud0dd\ud55c \ud56d\ubaa9\uc774 \ud30c\uc77c\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
            return;
        }
        IProject project = src.getProject();
        IContainer parent = src.getParent();
        if (parent instanceof IFolder && EpubBuildUtil.isTextFolder(pf = (IFolder)parent)) {
            targetFolder = (IFolder)parent;
        } else {
            targetFolder = EpubBuildUtil.getProjectIFolder("OEBPS/Text");
            EpubBuildUtil.ensureFolder(targetFolder);
        }
        IInputValidator validator = name -> {
            if (name == null || name.trim().isEmpty()) {
                return "\ud30c\uc77c\uba85\uc744 \uc785\ub825\ud558\uc138\uc694.";
            }
            String n = EpubBuildUtil.ensureXhtmlExt(name);
            if (!n.matches("[A-Za-z0-9_\\-\\.]+\\.xhtml")) {
                return "\uc601\ubb38/\uc22b\uc790/._-\ub9cc \ud5c8\uc6a9, .xhtml \ud655\uc7a5\uc790 \ud544\uc694";
            }
            if (src.getName().equals(n) && targetFolder.equals((Object)src.getParent())) {
                return "\uc6d0\ubcf8\uacfc \uc644\uc804\ud788 \ub3d9\uc77c\ud569\ub2c8\ub2e4.";
            }
            if (targetFolder.getFile(n).exists()) {
                return "\uac19\uc740 \uc774\ub984\uc758 \ud30c\uc77c\uc774 \uc774\ubbf8 \uc788\uc2b5\ub2c8\ub2e4.";
            }
            return null;
        };
        String suggest = src.getName().replace(".xhtml", "") + "_copy.xhtml";
        InputDialog ndlg = new InputDialog(shell, "\ub2e4\ub978 \uc774\ub984\uc73c\ub85c \uc800\uc7a5", "\uc0c8 \ud30c\uc77c\uba85\uc744 \uc785\ub825\ud558\uc138\uc694", suggest, validator);
        if (ndlg.open() != 0) {
            return;
        }
        String newName = EpubBuildUtil.ensureXhtmlExt(ndlg.getValue());
        IFile dst = targetFolder.getFile(newName);
        dst.create(src.getContents(), true, (IProgressMonitor)new NullProgressMonitor());
        targetFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        boolean addToSpine = true;
        boolean scripted = false;
        boolean linearNo = false;
        EpubBuildUtil.addToOpfIfXhtml(project, newName, addToSpine, scripted, linearNo);
        HashMap<String, ExplorerNode> data = new HashMap<String, ExplorerNode>();
        data.put("node", fileNode);
        eventBroker.post("gomsbook/menu/refresh", data);
        MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)("\ubcf5\uc0ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4:\n" + dst.getFullPath().toString()));
    }
}

