/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers.table;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class HtmlTableOps {
    private static final Pattern TABLE_OPEN = Pattern.compile("<table\\b", 2);
    private static final Pattern TABLE_CLOSE = Pattern.compile("</table\\s*>", 2);
    private static final Pattern TR_OPEN = Pattern.compile("<tr\\b[^>]*>", 2);
    private static final Pattern TR_CLOSE = Pattern.compile("</tr\\s*>", 2);
    private static final Pattern CELL_OPEN = Pattern.compile("<t[dh]\\b[^>]*>", 2);
    private static final Pattern CELL_CLOSE = Pattern.compile("</t[dh]\\s*>", 2);
    private static final Pattern STYLE_ATTR = Pattern.compile("(?i)\\bstyle\\s*=\\s*\"([^\"]*)\"");
    private static final Pattern TEXT_ALIGN_DECL = Pattern.compile("(?i)\\btext-align\\s*:\\s*[^;]+;?");
    private static final Pattern CLASS_ATTR = Pattern.compile("(?i)\\bclass\\s*=\\s*\"([^\"]*)\"");

    public static TableContext locateTableAtCaret(IDocument doc, int caret) throws BadLocationException {
        String whole = doc.get();
        int left = HtmlTableOps.lastMatchBefore(TABLE_OPEN, whole, caret);
        if (left < 0) {
            return null;
        }
        int right = HtmlTableOps.findMatchingTableClose(whole, left);
        if (right < 0 || right <= caret) {
            return null;
        }
        String html = whole.substring(left, right);
        TableContext ctx = new TableContext();
        ctx.tableStart = left;
        ctx.tableEnd = right;
        ctx.tableHtml = html;
        ctx.caretInTable = caret - left;
        HtmlTableOps.parseRowsAndCells(ctx);
        int rIdx = 0;
        for (Row r : ctx.rows) {
            if (ctx.caretInTable >= r.start && ctx.caretInTable <= r.end) {
                ctx.rowIndex = rIdx;
                int cIdx = 0;
                for (Cell c : r.cells) {
                    if (ctx.caretInTable >= c.start && ctx.caretInTable <= c.end) {
                        ctx.colIndex = cIdx;
                        return ctx;
                    }
                    ++cIdx;
                }
                ctx.colIndex = Math.max(0, r.cells.size() - 1);
                return ctx;
            }
            ++rIdx;
        }
        ctx.rowIndex = Math.max(0, ctx.rows.size() - 1);
        ctx.colIndex = 0;
        return ctx;
    }

    private static int lastMatchBefore(Pattern p, String s, int pos) {
        Matcher m = p.matcher(s);
        int last = -1;
        while (m.find()) {
            if (m.start() >= pos) break;
            last = m.start();
        }
        return last;
    }

    private static int findMatchingTableClose(String s, int tableOpenPos) {
        Matcher open = TABLE_OPEN.matcher(s);
        Matcher close = TABLE_CLOSE.matcher(s);
        int depth = 0;
        int i = tableOpenPos;
        while (true) {
            boolean fOpen = open.find(i);
            boolean fClose = close.find(i);
            if (!fClose) {
                return -1;
            }
            if (fOpen && open.start() < close.start()) {
                ++depth;
                i = open.end();
                continue;
            }
            i = close.end();
            if (--depth < 0) break;
        }
        return i;
    }

    private static void parseRowsAndCells(TableContext ctx) {
        String t = ctx.tableHtml;
        Matcher mTrOpen = TR_OPEN.matcher(t);
        while (mTrOpen.find()) {
            int trStart = mTrOpen.start();
            int trEnd = HtmlTableOps.findClosingTag(t, TR_CLOSE, mTrOpen.end());
            if (trEnd < 0) break;
            Row row = new Row();
            row.start = trStart;
            row.end = trEnd;
            String rowHtml = t.substring(trStart, trEnd);
            Matcher mCellOpen = CELL_OPEN.matcher(rowHtml);
            while (mCellOpen.find()) {
                int cellOpenStart = mCellOpen.start();
                int cellOpenEnd = mCellOpen.end();
                int cellCloseEnd = HtmlTableOps.findClosingTag(rowHtml, CELL_CLOSE, cellOpenEnd);
                if (cellCloseEnd < 0) break;
                String openTag = rowHtml.substring(cellOpenStart, cellOpenEnd);
                String inner = rowHtml.substring(cellOpenEnd, cellCloseEnd - "</x>".length());
                String closeTag = rowHtml.substring(cellCloseEnd - "</td>".length(), cellCloseEnd);
                int closeTagStart = HtmlTableOps.findCellCloseTagStart(rowHtml, cellOpenEnd);
                if (closeTagStart > 0) {
                    inner = rowHtml.substring(cellOpenEnd, closeTagStart);
                    closeTag = rowHtml.substring(closeTagStart, Math.min(rowHtml.length(), closeTagStart + 5));
                }
                Cell cell = new Cell();
                cell.start = trStart + cellOpenStart;
                cell.end = trStart + cellCloseEnd;
                cell.openTag = openTag;
                cell.isHeader = openTag.toLowerCase().startsWith("<th");
                cell.innerHtml = inner;
                cell.closeTag = closeTag;
                row.cells.add(cell);
            }
            ctx.rows.add(row);
        }
    }

    private static int findClosingTag(String s, Pattern close, int from) {
        Matcher m = close.matcher(s);
        if (m.find(from)) {
            return m.end();
        }
        return -1;
    }

    private static int findCellCloseTagStart(String rowHtml, int from) {
        int td = rowHtml.toLowerCase().indexOf("</td>", from);
        int th = rowHtml.toLowerCase().indexOf("</th>", from);
        if (td < 0) {
            return th;
        }
        if (th < 0) {
            return td;
        }
        return Math.min(td, th);
    }

    public static String insertRowBelow(TableContext ctx) {
        int target = ctx.rowIndex;
        int cols = ctx.rows.get((int)target).cells.size();
        StringBuilder newRow = new StringBuilder();
        newRow.append("    <tr>\n");
        int c = 0;
        while (c < cols) {
            newRow.append("      <td>\ub0b4\uc6a9</td>\n");
            ++c;
        }
        newRow.append("    </tr>\n");
        Row r = ctx.rows.get(target);
        return ctx.tableHtml.substring(0, r.end) + String.valueOf(newRow) + ctx.tableHtml.substring(r.end);
    }

    public static String deleteCurrentRow(TableContext ctx) {
        if (ctx.rows.size() <= 1) {
            return ctx.tableHtml;
        }
        Row r = ctx.rows.get(ctx.rowIndex);
        return ctx.tableHtml.substring(0, r.start) + ctx.tableHtml.substring(r.end);
    }

    public static String insertColRight(TableContext ctx) {
        int col = ctx.colIndex;
        String t = ctx.tableHtml;
        StringBuilder out = new StringBuilder();
        int cursor = 0;
        for (Row r : ctx.rows) {
            out.append(t, cursor, r.start);
            String rowHtml = t.substring(r.start, r.end);
            List<int[]> cells = HtmlTableOps.findCellRanges(rowHtml);
            out.append(rowHtml, 0, cells.get(Math.min(col, cells.size() - 1))[1]);
            out.append("<td>\ub0b4\uc6a9</td>");
            out.append(rowHtml.substring(cells.get(Math.min(col, cells.size() - 1))[1]));
            cursor = r.end;
        }
        out.append(t.substring(cursor));
        return out.toString();
    }

    public static String deleteCurrentCol(TableContext ctx) {
        int col = ctx.colIndex;
        String t = ctx.tableHtml;
        StringBuilder out = new StringBuilder();
        int cursor = 0;
        for (Row r : ctx.rows) {
            out.append(t, cursor, r.start);
            String rowHtml = t.substring(r.start, r.end);
            List<int[]> cells = HtmlTableOps.findCellRanges(rowHtml);
            if (cells.size() <= 1) {
                out.append(rowHtml);
            } else {
                int[] rng = cells.get(Math.min(col, cells.size() - 1));
                out.append(rowHtml, 0, rng[0]).append(rowHtml.substring(rng[1]));
            }
            cursor = r.end;
        }
        out.append(t.substring(cursor));
        return out.toString();
    }

    public static String alignColumn(TableContext ctx, String align) {
        int col = ctx.colIndex;
        String t = ctx.tableHtml;
        StringBuilder out = new StringBuilder();
        int cursor = 0;
        for (Row r : ctx.rows) {
            out.append(t, cursor, r.start);
            String rowHtml = t.substring(r.start, r.end);
            List<int[]> cells = HtmlTableOps.findCellRanges(rowHtml);
            int idx = Math.min(col, cells.size() - 1);
            int[] rng = cells.get(idx);
            String cell = rowHtml.substring(rng[0], rng[1]);
            String aligned = HtmlTableOps.applyTextAlignToCell(cell, align);
            out.append(rowHtml, 0, rng[0]).append(aligned).append(rowHtml.substring(rng[1]));
            cursor = r.end;
        }
        out.append(t.substring(cursor));
        return out.toString();
    }

    public static String toggleHeaderRow(TableContext ctx) {
        if (ctx.rows.isEmpty()) {
            return ctx.tableHtml;
        }
        Row first = ctx.rows.get(0);
        String t = ctx.tableHtml;
        String rowHtml = t.substring(first.start, first.end);
        List<int[]> cells = HtmlTableOps.findCellRanges(rowHtml);
        StringBuilder sb = new StringBuilder(rowHtml);
        int i = cells.size() - 1;
        while (i >= 0) {
            int[] rng = cells.get(i);
            String cell = sb.substring(rng[0], rng[1]);
            String toggled = HtmlTableOps.toggleCellThTd(cell);
            sb.replace(rng[0], rng[1], toggled);
            --i;
        }
        return t.substring(0, first.start) + String.valueOf(sb) + t.substring(first.end);
    }

    public static String toggleZebraClass(TableContext ctx) {
        String t = ctx.tableHtml;
        int openEnd = t.indexOf(62);
        if (openEnd < 0) {
            return t;
        }
        String open = t.substring(0, openEnd + 1);
        String rest = t.substring(openEnd + 1);
        String updated = HtmlTableOps.toggleClassToken(open, "zebra");
        return updated + rest;
    }

    private static List<int[]> findCellRanges(String rowHtml) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        Matcher op = CELL_OPEN.matcher(rowHtml);
        while (op.find()) {
            int openStart = op.start();
            int cellClose = HtmlTableOps.findCellCloseTagStart(rowHtml, op.end());
            if (cellClose < 0) break;
            int closeEnd = cellClose + 5;
            ranges.add(new int[]{openStart, Math.min(rowHtml.length(), closeEnd)});
        }
        return ranges;
    }

    private static String applyTextAlignToCell(String cellHtml, String align) {
        int gt = cellHtml.indexOf(62);
        if (gt < 0) {
            return cellHtml;
        }
        Object open = cellHtml.substring(0, gt);
        String rest = cellHtml.substring(gt);
        String newDecl = "text-align:" + align + ";";
        Matcher m = STYLE_ATTR.matcher((CharSequence)open);
        if (m.find()) {
            Object styleVal = m.group(1);
            styleVal = TEXT_ALIGN_DECL.matcher((CharSequence)styleVal).replaceAll("");
            if (!((String)(styleVal = ((String)styleVal).trim())).isEmpty() && !((String)styleVal).endsWith(";")) {
                styleVal = (String)styleVal + ";";
            }
            String finalVal = (String)(((String)(styleVal = ((String)styleVal).replaceAll("\\s*;\\s*", ";"))).isEmpty() ? "" : styleVal) + newDecl;
            StringBuffer buf = new StringBuffer();
            m.reset();
            if (m.find()) {
                m.appendReplacement(buf, Matcher.quoteReplacement("style=\"" + finalVal + "\""));
                m.appendTail(buf);
                open = buf.toString();
            }
        } else {
            open = (String)open + " style=\"" + newDecl + "\"";
        }
        return (String)open + rest;
    }

    private static String toggleCellThTd(String cell) {
        if (cell.toLowerCase().startsWith("<th")) {
            cell = cell.replaceFirst("(?i)^<th", "<td").replaceFirst("(?i)</th\\s*>\\s*$", "</td>");
            cell = cell.replaceFirst("(?i)\\s*scope\\s*=\\s*\"row|col\"", "");
        } else {
            cell = cell.replaceFirst("(?i)^<td", "<th").replaceFirst("(?i)</td\\s*>\\s*$", "</th>");
        }
        return cell;
    }

    private static String toggleClassToken(String openTag, String token) {
        String lower = openTag.toLowerCase();
        if (!lower.startsWith("<table")) {
            return openTag;
        }
        Matcher m = CLASS_ATTR.matcher(openTag);
        if (m.find()) {
            String cls = m.group(1).trim();
            String[] parts = cls.isEmpty() ? new String[]{} : cls.split("\\s+");
            boolean has = false;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (p.equals(token)) {
                    has = true;
                } else if (!p.isEmpty()) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(p);
                }
                ++n2;
            }
            if (!has) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(token);
            }
            String newClassAttr = "class=\"" + sb.toString() + "\"";
            StringBuffer buf = new StringBuffer();
            m.reset();
            if (m.find()) {
                m.appendReplacement(buf, Matcher.quoteReplacement(newClassAttr));
                m.appendTail(buf);
                return buf.toString();
            }
            return openTag;
        }
        int gt = openTag.indexOf(62);
        if (gt < 0) {
            return openTag;
        }
        Object before = openTag.substring(0, gt);
        String after = openTag.substring(gt);
        if (!((String)before).endsWith(" ")) {
            before = (String)before + " ";
        }
        return (String)before + "class=\"" + token + "\"" + after;
    }

    public static class Cell {
        public int start;
        public int end;
        public boolean isHeader;
        public String openTag;
        public String innerHtml;
        public String closeTag;
    }

    public static class Row {
        public int start;
        public int end;
        public List<Cell> cells = new ArrayList<Cell>();
    }

    public static class TableContext {
        public int tableStart;
        public int tableEnd;
        public String tableHtml;
        public int caretInTable;
        public int rowIndex;
        public int colIndex;
        public List<Row> rows = new ArrayList<Row>();
    }
}

