/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.pages;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.dialogs.ColorPaletteDialog;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.TemplateTreeItemContentProvider;
import kr.co.goms.epub.solution.ui.TemplateItem;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.EpubColorUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class AuthorTemplateEditorPage {
    private Text authorInfoText;
    private Text imagePathText;
    private Text authorNameText;
    private TreeViewer treeViewer;
    private Browser browser;
    Preferences prefs;
    private List<TemplateItem> templateList;
    private TemplateItem selectedTemplateItem;
    Map<String, String> selectedColorMap = new HashMap<String, String>();
    Button bgColorCheck;
    Button authorInfoColorCheck;
    Button authorNameColorCheck;
    StyledText bgColorValue;
    StyledText authorInfoColorValue;
    StyledText authorNameColorValue;
    @Inject
    private Shell shell;

    @PostConstruct
    public void createControls(Composite parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent composite cannot be null");
        }
        this.prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftTreeViewer((Composite)sashForm);
        this.createRightForm((Composite)sashForm);
        this.createPreview((Composite)sashForm);
        sashForm.setWeights(new int[]{25, 35, 40});
    }

    private void createLeftTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.templateList = ResourceUtil.getTemplateFolderList("author");
        this.treeViewer.setContentProvider((IContentProvider)new TemplateTreeItemContentProvider());
        this.treeViewer.setInput(this.templateList);
        this.treeViewer.addSelectionChangedListener(event -> {
            ITreeSelection selection = this.treeViewer.getStructuredSelection();
            this.selectedTemplateItem = (TemplateItem)selection.getFirstElement();
            System.out.println("\uc120\ud0dd\ud55c \ud15c\ud50c\ub9bf : " + this.selectedTemplateItem.displayName);
            this.showPreview();
        });
    }

    private void createRightForm(Composite parent) {
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(backgroundColor);
        Label authorNameLabel = new Label(container, 0);
        authorNameLabel.setText("\uc791\uac00\uba85");
        authorNameLabel.setBackground(backgroundColor);
        this.authorNameText = new Text(container, 2048);
        this.authorNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.authorNameText.setText(EpubPreferenceManager.getInstance().getProjectAuthor());
        this.authorNameText.addModifyListener(e -> this.showPreview());
        Label authorLebel = new Label(container, 0);
        authorLebel.setText("\uc791\uac00\uc18c\uac1c");
        authorLebel.setBackground(backgroundColor);
        this.authorInfoText = new Text(container, 2626);
        GridData gdTitleText = new GridData(4, 128, true, false, 2, 1);
        int lineHeight = this.authorInfoText.getLineHeight();
        gdTitleText.heightHint = lineHeight * 3;
        this.authorInfoText.setLayoutData((Object)gdTitleText);
        this.authorInfoText.addModifyListener(e -> this.showPreview());
        Label imgPath = new Label(container, 0);
        imgPath.setText("\uc791\uac00\uc774\ubbf8\uc9c0\uacbd\ub85c");
        imgPath.setBackground(backgroundColor);
        this.imagePathText = new Text(container, 2048);
        this.imagePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseBtn = new Button(container, 8);
        browseBtn.setText("\ucc3e\uae30");
        browseBtn.addListener(13, e -> {
            FileDialog dialog = new FileDialog(container.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.jpg", "*.jpeg", "*.png", "*.gif"});
            String selectedImagePath = dialog.open();
            if (selectedImagePath != null) {
                this.imagePathText.setText(selectedImagePath);
                this.showPreview();
            }
        });
        Group group = new Group(container, 0);
        group.setText("EPUB Color");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = 3;
        group.setLayoutData((Object)groupData);
        group.setBackground(backgroundColor);
        Group targetGroup = new Group((Composite)group, 0);
        targetGroup.setText("\uc0c9\uc0c1 \uc801\uc6a9 \ub300\uc0c1");
        targetGroup.setLayout((Layout)new GridLayout(1, false));
        targetGroup.setBackground(backgroundColor);
        Composite bgColorRow = new Composite((Composite)targetGroup, 0);
        bgColorRow.setLayout((Layout)new GridLayout(2, false));
        bgColorRow.setBackground(backgroundColor);
        this.bgColorCheck = new Button(bgColorRow, 32);
        this.bgColorCheck.setText("\ubc30\uacbd\uc0c9");
        this.bgColorCheck.setBackground(backgroundColor);
        Canvas bgColorPreview = new Canvas(bgColorRow, 2048);
        bgColorPreview.setLayoutData((Object)new GridData(12, 12));
        bgColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite authorInfoColorRow = new Composite((Composite)targetGroup, 0);
        authorInfoColorRow.setLayout((Layout)new GridLayout(2, false));
        authorInfoColorRow.setBackground(backgroundColor);
        this.authorInfoColorCheck = new Button(authorInfoColorRow, 32);
        this.authorInfoColorCheck.setText("\uc791\uac00\uc18c\uac1c");
        this.authorInfoColorCheck.setBackground(backgroundColor);
        Canvas authorInfoColorPreview = new Canvas(authorInfoColorRow, 2048);
        authorInfoColorPreview.setLayoutData((Object)new GridData(12, 12));
        authorInfoColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite authorNameColorRow = new Composite((Composite)targetGroup, 0);
        authorNameColorRow.setLayout((Layout)new GridLayout(2, false));
        authorNameColorRow.setBackground(backgroundColor);
        this.authorNameColorCheck = new Button(authorNameColorRow, 32);
        this.authorNameColorCheck.setText("\uc791\uac00\uc0c9");
        this.authorNameColorCheck.setBackground(backgroundColor);
        Canvas authorNameColorPreview = new Canvas(authorNameColorRow, 2048);
        authorNameColorPreview.setLayoutData((Object)new GridData(12, 12));
        authorNameColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Group targetPreviewGroup = new Group((Composite)group, 0);
        targetPreviewGroup.setText("\uc0c9\uc0c1\uac12");
        targetPreviewGroup.setLayout((Layout)new GridLayout(1, false));
        targetPreviewGroup.setBackground(backgroundColor);
        Composite bgColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        bgColorValueRow.setLayout((Layout)new GridLayout(2, false));
        bgColorValueRow.setBackground(backgroundColor);
        Label bgColor = new Label(bgColorValueRow, 0);
        bgColor.setText("\ubc30\uacbd\uc0c9");
        bgColor.setBackground(backgroundColor);
        this.bgColorValue = new StyledText(bgColorValueRow, 2048);
        this.bgColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite authorInfoColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        authorInfoColorValueRow.setLayout((Layout)new GridLayout(2, false));
        authorInfoColorValueRow.setBackground(backgroundColor);
        Label authorInfoColor = new Label(authorInfoColorValueRow, 0);
        authorInfoColor.setText("\uc81c\ubaa9\uc0c9");
        authorInfoColor.setBackground(backgroundColor);
        this.authorInfoColorValue = new StyledText(authorInfoColorValueRow, 2048);
        this.authorInfoColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite authorNameColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        authorNameColorValueRow.setLayout((Layout)new GridLayout(2, false));
        authorNameColorValueRow.setBackground(backgroundColor);
        Label authorNameColor = new Label(authorNameColorValueRow, 0);
        authorNameColor.setText("\uc791\uac00\uba85\uc0c9");
        authorNameColor.setBackground(backgroundColor);
        this.authorNameColorValue = new StyledText(authorNameColorValueRow, 2048);
        this.authorNameColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button colorBtn = new Button((Composite)group, 8);
        colorBtn.setText("\uc0c9\uc0c1 \uc120\ud0dd");
        colorBtn.addListener(13, e -> {
            ColorPaletteDialog dlg = new ColorPaletteDialog(parent.getShell(), hsv -> {
                System.out.printf("\uc120\ud0dd\ub41c HSV: H=%.2f, S=%.2f, V=%.2f%n", Float.valueOf(hsv[0]), Float.valueOf(hsv[1]), Float.valueOf(hsv[2]));
                RGB rgb = EpubColorUtil.hsvToRGB(hsv);
                String hexColor = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                System.out.println("HEX: " + String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue));
                RGB previewRGB = EpubColorUtil.hsvToRGB(hsv);
                Color color = new Color((Device)parent.getDisplay(), previewRGB);
                if (this.bgColorCheck.getSelection()) {
                    this.selectedColorMap.put("bg", hexColor);
                    this.prefs.put("color.bg", hexColor);
                    System.out.println("\u2192 \ubc30\uacbd \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    bgColorPreview.setBackground(color);
                    bgColorPreview.addDisposeListener(ev -> color.dispose());
                    this.bgColorValue.setText(hexColor);
                }
                if (this.authorInfoColorCheck.getSelection()) {
                    this.selectedColorMap.put("title", hexColor);
                    this.prefs.put("color.title", hexColor);
                    System.out.println("\u2192 \uc81c\ubaa9 \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    authorInfoColorPreview.setBackground(color);
                    authorInfoColorPreview.addDisposeListener(ev -> color.dispose());
                    this.authorInfoColorValue.setText(hexColor);
                }
                if (this.authorNameColorCheck.getSelection()) {
                    this.selectedColorMap.put("author", hexColor);
                    this.prefs.put("color.author", hexColor);
                    System.out.println("\u2192 \uc791\uac00\uba85 \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    authorNameColorPreview.setBackground(color);
                    authorNameColorPreview.addDisposeListener(ev -> color.dispose());
                    this.authorNameColorValue.setText(hexColor);
                }
                try {
                    this.prefs.flush();
                }
                catch (BackingStoreException ex) {
                    ex.printStackTrace();
                }
                this.showPreview();
                parent.addDisposeListener(ev -> bgColorPreview.dispose());
                parent.addDisposeListener(ev -> authorInfoColorPreview.dispose());
                parent.addDisposeListener(ev -> authorNameColorPreview.dispose());
            });
            dlg.open();
        });
        Button previewBtn = new Button(container, 8);
        previewBtn.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        previewBtn.addListener(13, e -> this.showPreview());
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        Button saveBtn = new Button(container, 8);
        saveBtn.setText("\uc800\uc7a5");
        GridData btnData = new GridData();
        btnData.horizontalSpan = 2;
        btnData.horizontalAlignment = 131072;
        saveBtn.setLayoutData((Object)btnData);
        saveBtn.addListener(13, e -> this.saveXHTML());
    }

    private void createPreview(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(container, 2048);
        GridData browserData = new GridData(4, 4, true, true, 2, 1);
        this.browser.setLayoutData((Object)browserData);
        this.browser.setText("<p>\ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uace0 \ubbf8\ub9ac\ubcf4\uae30 \ubc84\ud2bc\uc744 \ub20c\ub7ec\uc8fc\uc138\uc694.</p>");
    }

    private void showPreview() {
        System.out.println("showPreview()");
        if (this.selectedTemplateItem == null) {
            this.browser.setText("<p>\uba3c\uc800 \ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uc138\uc694.</p>");
            return;
        }
        String fileName = this.selectedTemplateItem.fileName;
        System.out.println("fileName : " + fileName);
        if (fileName == null) {
            this.browser.setText("<p>\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud15c\ud50c\ub9bf\uc785\ub2c8\ub2e4.</p>");
            return;
        }
        String authorInfo = this.authorInfoText.getText().trim();
        String authorName = this.authorNameText.getText().trim();
        String alt = "\uc791\uac00\uc0ac\uc9c4";
        String imgPath = this.imagePathText.getText().trim();
        authorInfo = authorInfo.replaceAll("\\r?\\n", "<br/>");
        String bgColor = this.prefs.get("color.bg", "#FFC0CB");
        String authorInfoColor = this.prefs.get("color.title", "#000000");
        String authorNameColor = this.prefs.get("color.author", "#666666");
        String templateHtml = ResourceUtil.loadFromBundle("resources/templates/author", fileName);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("\uc791\uac00\uc18c\uac1c", authorInfo);
        values.put("\uc791\uac00\uba85", authorName == null ? "" : authorName);
        values.put("\uc774\ubbf8\uc9c0\uc124\uba85", alt);
        values.put("\uc774\ubbf8\uc9c0\uacbd\ub85c", imgPath);
        values.put("\uc791\uac00\uc18c\uac1c\uc0c9", authorInfoColor);
        values.put("\uc791\uac00\uc0c9", authorNameColor);
        values.put("\ubc30\uacbd\uc0c9", bgColor);
        String renderedHtml = this.replaceVariables(templateHtml, values);
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String resultHtmlContent = this.changeStypePath(projectFullPath, renderedHtml);
        this.browser.setText(resultHtmlContent);
    }

    private void saveXHTML() {
        System.out.println("saveXHTML()");
        String authorInfo = this.authorInfoText.getText().trim();
        String authorName = this.authorNameText.getText().trim();
        String alt = "\uc791\uac00\uc0ac\uc9c4";
        String imgPath = this.imagePathText.getText().trim();
        authorInfo = authorInfo.replaceAll("\\r?\\n", "<br/>");
        String selectedTemplate = "\ud15c\ud50c\ub9bf 1 - \uae30\ubcf8\ud615";
        try {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            selectedTemplate = (String)selection.getFirstElement();
        }
        catch (Exception exception) {}
        int index = -1;
        int i = 0;
        while (i < this.templateList.size()) {
            if (this.templateList.get(i).equals(selectedTemplate)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        String templateFileName = "author_template" + index + ".xhtml";
        System.out.println("\uc791\uac00\ud15c\ud50c\ub9bf\uba85 : " + templateFileName);
        try {
            String xhtmlContent = ResourceUtil.loadFromBundle("resources/templates/author", templateFileName);
            String bgColor = this.prefs.get("color.bg", "#FFC0CB");
            String authorInfoColor = this.prefs.get("color.title", "#000000");
            String authorNameColor = this.prefs.get("color.author", "#666666");
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("\uc791\uac00\uc18c\uac1c", authorInfo);
            values.put("\uc791\uac00\uba85", authorName == null ? "" : authorName);
            values.put("\uc774\ubbf8\uc9c0\uc124\uba85", alt);
            values.put("\uc791\uac00\uc18c\uac1c\uc0c9", authorInfoColor);
            values.put("\uc791\uac00\uc0c9", authorNameColor);
            values.put("\ubc30\uacbd\uc0c9", bgColor);
            xhtmlContent = this.replaceVariables(xhtmlContent, values);
            xhtmlContent = xhtmlContent.replace("<p><p>", "<p>").replace("</p></p>", "</p>");
            xhtmlContent = this.processImageBase64(xhtmlContent, imgPath);
            Path outputDir = Paths.get(EpubBuildUtil.getProjectFullPath(), "OEBPS", "Text");
            Files.createDirectories(outputDir, new FileAttribute[0]);
            long count = Files.list(outputDir).filter(p -> p.getFileName().toString().startsWith("author") && p.toString().endsWith(".xhtml")).count();
            String fileName = "author.xhtml";
            if (count == 0L) {
                fileName = "author.xhtml";
                Files.writeString(outputDir.resolve(fileName), (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
                String message = fileName + " \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\\nProject Explorer Reload\ud6c4 \ud655\uc778 \ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.";
                this.applyOpf(this.shell, fileName, message);
            } else {
                fileName = String.format("author%d.xhtml", count + 1L);
                this.openMessage(this.shell, outputDir, fileName, xhtmlContent);
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)"\uc624\ub958", (String)e.getMessage());
        }
    }

    private void openMessage(Shell parentShell, Path outputDir, String fileName, String xhtmlContent) {
        MessageBox messageBox = new MessageBox(parentShell, 452);
        messageBox.setText("\ud30c\uc77c \uc874\uc7ac");
        messageBox.setMessage("author.xhtml\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4.\n\ub36e\uc5b4\uc4f0\uc2dc\uaca0\uc2b5\ub2c8\uae4c? (\uc544\ub2c8\uc624 \uc120\ud0dd \uc2dc author2.xhtml \uc0dd\uc131)");
        int response = messageBox.open();
        Path targetPath = outputDir.resolve(fileName);
        Object message = "";
        if (response == 64) {
            fileName = "author.xhtml";
            targetPath = outputDir.resolve(fileName);
            try {
                Files.writeString(targetPath, (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ResourceUtil.createXhtmlFile(outputDir, fileName, xhtmlContent);
            message = fileName + " \ud30c\uc77c\uc774 \ub36e\uc5b4\uc4f0\uae30\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            CommonUtil.showMessageBox(this.shell, (String)message);
        } else if (response == 128) {
            ResourceUtil.createXhtmlFile(outputDir, fileName, xhtmlContent);
            message = fileName + " \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            this.applyOpf(this.shell, fileName, (String)message);
        }
    }

    private void applyOpf(Shell shell, String fileName, String message) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        boolean isXhtml = true;
        boolean addToScripted = true;
        boolean addToLinearNo = false;
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
        String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
        OpfNcxUpdater.addFileToOpf(iFolder.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addToLinearNo);
        CommonUtil.showMessageBox(shell, message);
    }

    private String replaceVariables(String template, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Object value = entry.getValue();
            if ("\uba85\uc5b8".equals(entry.getKey()) && !((String)value).isEmpty()) {
                value = "\u201c" + entry.getValue() + "\u201d";
            }
            template = template.replace("${" + entry.getKey() + "}", (CharSequence)value);
        }
        return template;
    }

    public static String convertNewlinesToParagraphs(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String[] lines = text.split("\\r?\\n");
        StringBuilder html = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                html.append("<p>").append(AuthorTemplateEditorPage.escapeHtml(line)).append("</p>");
            }
            ++n2;
        }
        return html.toString();
    }

    public static String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private String changeStypePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Styles/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String styleFileName = matcher.group(1);
            File styleFile = new File(projectFullPath, "OEBPS/Styles/" + styleFileName);
            String styleUri = styleFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String changeImagePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Images/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String imageFileName = matcher.group(1);
            File imageFile = new File(projectFullPath, "OEBPS/Images/" + imageFileName);
            String imageUri = imageFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(imageUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String processImageBase64(String xhtml, String imagePath) {
        String finalHtml = "";
        if (imagePath != null) {
            String mimeType = ResourceUtil.getMimeType(imagePath);
            String base64Image = ResourceUtil.encodeImageToBase64(imagePath);
            if (base64Image != null) {
                String base64Src = "data:" + mimeType + ";base64," + base64Image;
                finalHtml = xhtml.replace("${\uc774\ubbf8\uc9c0\uacbd\ub85c}", base64Src);
                System.out.println(finalHtml);
            }
        }
        return finalHtml;
    }
}

