/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.pages;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.managers.ContentOpfManager;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.dialogs.ColorPaletteDialog;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.TemplateTreeItemContentProvider;
import kr.co.goms.epub.solution.ui.TemplateItem;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.EpubColorUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CoverTemplateEditorPage {
    private Text titleText;
    private Text subTitleText;
    private Text altText;
    private Text imagePathText;
    private Text authorText;
    private TreeViewer treeViewer;
    private Browser browser;
    Preferences prefs;
    private List<TemplateItem> templateList;
    private TemplateItem selectedTemplateItem;
    Map<String, String> selectedColorMap = new HashMap<String, String>();
    Button bgColorCheck;
    Button titleColorCheck;
    Button subtitleColorCheck;
    Button authorColorCheck;
    StyledText bgColorValue;
    StyledText titleColorValue;
    StyledText subTitleColorValue;
    StyledText authorColorValue;
    @Inject
    private Shell shell;
    @Inject
    EPartService partService;

    @PostConstruct
    public void createControls(Composite parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent composite cannot be null");
        }
        this.prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftTreeViewer((Composite)sashForm);
        this.createRightForm((Composite)sashForm);
        this.createPreview((Composite)sashForm);
        sashForm.setWeights(new int[]{25, 35, 40});
    }

    private void createLeftTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.templateList = ResourceUtil.getTemplateFolderList("cover");
        this.treeViewer.setContentProvider((IContentProvider)new TemplateTreeItemContentProvider());
        this.treeViewer.setInput(this.templateList);
        this.treeViewer.addSelectionChangedListener(event -> {
            ITreeSelection selection = this.treeViewer.getStructuredSelection();
            this.selectedTemplateItem = (TemplateItem)selection.getFirstElement();
            System.out.println("\uc120\ud0dd\ud55c \ud15c\ud50c\ub9bf : " + this.selectedTemplateItem.displayName);
            this.showPreview();
        });
    }

    private void createRightForm(Composite parent) {
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(backgroundColor);
        Label title = new Label(container, 0);
        title.setText("\uc81c\ubaa9");
        title.setBackground(backgroundColor);
        this.titleText = new Text(container, 2626);
        GridData gdTitleText = new GridData(4, 128, true, false, 2, 1);
        int lineHeight = this.titleText.getLineHeight();
        gdTitleText.heightHint = lineHeight * 3;
        this.titleText.setLayoutData((Object)gdTitleText);
        this.titleText.addModifyListener(e -> this.showPreview());
        Label subTitle = new Label(container, 0);
        subTitle.setText("\ubd80\uc81c");
        subTitle.setBackground(backgroundColor);
        this.subTitleText = new Text(container, 2626);
        GridData gdSubTitleText = new GridData(4, 128, true, false, 2, 1);
        int lineHeightSubTitle = this.subTitleText.getLineHeight();
        gdSubTitleText.heightHint = lineHeightSubTitle * 3;
        this.subTitleText.setLayoutData((Object)gdSubTitleText);
        this.subTitleText.addModifyListener(e -> this.showPreview());
        Label author = new Label(container, 0);
        author.setText("\uc800\uc790\uba85");
        author.setBackground(backgroundColor);
        this.authorText = new Text(container, 2048);
        this.authorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.authorText.setText(EpubPreferenceManager.getInstance().getProjectAuthor());
        this.authorText.addModifyListener(e -> this.showPreview());
        Label imgDesc = new Label(container, 0);
        imgDesc.setText("\uc774\ubbf8\uc9c0\uc124\uba85");
        imgDesc.setBackground(backgroundColor);
        this.altText = new Text(container, 2048);
        this.altText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.altText.setText("\ud45c\uc9c0");
        this.altText.addModifyListener(e -> this.showPreview());
        Label imgPath = new Label(container, 0);
        imgPath.setText("\uc774\ubbf8\uc9c0\uacbd\ub85c");
        imgPath.setBackground(backgroundColor);
        this.imagePathText = new Text(container, 2048);
        this.imagePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseBtn = new Button(container, 8);
        browseBtn.setText("\ucc3e\uae30");
        browseBtn.addListener(13, e -> {
            FileDialog dialog = new FileDialog(container.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.jpg", "*.jpeg", "*.png", "*.gif"});
            String selectedImagePath = dialog.open();
            if (selectedImagePath != null) {
                this.imagePathText.setText(selectedImagePath);
                this.showPreview();
            }
        });
        Group group = new Group(container, 0);
        group.setText("EPUB Color");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = 3;
        group.setLayoutData((Object)groupData);
        group.setBackground(backgroundColor);
        Group targetGroup = new Group((Composite)group, 0);
        targetGroup.setText("\uc0c9\uc0c1 \uc801\uc6a9 \ub300\uc0c1");
        targetGroup.setLayout((Layout)new GridLayout(1, false));
        targetGroup.setBackground(backgroundColor);
        Composite bgColorRow = new Composite((Composite)targetGroup, 0);
        bgColorRow.setLayout((Layout)new GridLayout(2, false));
        bgColorRow.setBackground(backgroundColor);
        this.bgColorCheck = new Button(bgColorRow, 32);
        this.bgColorCheck.setText("\ubc30\uacbd");
        this.bgColorCheck.setBackground(backgroundColor);
        Canvas bgColorPreview = new Canvas(bgColorRow, 2048);
        bgColorPreview.setLayoutData((Object)new GridData(12, 12));
        bgColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite titleColorRow = new Composite((Composite)targetGroup, 0);
        titleColorRow.setLayout((Layout)new GridLayout(2, false));
        titleColorRow.setBackground(backgroundColor);
        this.titleColorCheck = new Button(titleColorRow, 32);
        this.titleColorCheck.setText("\uc81c\ubaa9");
        this.titleColorCheck.setBackground(backgroundColor);
        Canvas titleColorPreview = new Canvas(titleColorRow, 2048);
        titleColorPreview.setLayoutData((Object)new GridData(12, 12));
        titleColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite subTitleColorRow = new Composite((Composite)targetGroup, 0);
        subTitleColorRow.setLayout((Layout)new GridLayout(2, false));
        subTitleColorRow.setBackground(backgroundColor);
        this.subtitleColorCheck = new Button(subTitleColorRow, 32);
        this.subtitleColorCheck.setText("\ubd80\uc81c");
        this.subtitleColorCheck.setBackground(backgroundColor);
        Canvas subTitleColorPreview = new Canvas(subTitleColorRow, 2048);
        subTitleColorPreview.setLayoutData((Object)new GridData(12, 12));
        subTitleColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite authorColorRow = new Composite((Composite)targetGroup, 0);
        authorColorRow.setLayout((Layout)new GridLayout(2, false));
        authorColorRow.setBackground(backgroundColor);
        this.authorColorCheck = new Button(authorColorRow, 32);
        this.authorColorCheck.setText("\uc800\uc790");
        this.authorColorCheck.setBackground(backgroundColor);
        Canvas authorColorPreview = new Canvas(authorColorRow, 2048);
        authorColorPreview.setLayoutData((Object)new GridData(12, 12));
        authorColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Group targetPreviewGroup = new Group((Composite)group, 0);
        targetPreviewGroup.setText("\uc0c9\uc0c1\uac12");
        targetPreviewGroup.setLayout((Layout)new GridLayout(1, false));
        targetPreviewGroup.setBackground(backgroundColor);
        Composite bgColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        bgColorValueRow.setLayout((Layout)new GridLayout(2, false));
        bgColorValueRow.setBackground(backgroundColor);
        Label bgColor = new Label(bgColorValueRow, 0);
        bgColor.setText("\ubc30\uacbd\uc0c9");
        bgColor.setBackground(backgroundColor);
        this.bgColorValue = new StyledText(bgColorValueRow, 2048);
        this.bgColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite titleColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        titleColorValueRow.setLayout((Layout)new GridLayout(2, false));
        titleColorValueRow.setBackground(backgroundColor);
        Label titleColor = new Label(titleColorValueRow, 0);
        titleColor.setText("\uc81c\ubaa9\uc0c9");
        titleColor.setBackground(backgroundColor);
        this.titleColorValue = new StyledText(titleColorValueRow, 2048);
        this.titleColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite subTitleColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        subTitleColorValueRow.setLayout((Layout)new GridLayout(2, false));
        subTitleColorValueRow.setBackground(backgroundColor);
        Label subTitleColor = new Label(subTitleColorValueRow, 0);
        subTitleColor.setText("\ubd80\uc81c\uc0c9");
        subTitleColor.setBackground(backgroundColor);
        this.subTitleColorValue = new StyledText(subTitleColorValueRow, 2048);
        this.subTitleColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite authorColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        authorColorValueRow.setLayout((Layout)new GridLayout(2, false));
        authorColorValueRow.setBackground(backgroundColor);
        Label authorColor = new Label(authorColorValueRow, 0);
        authorColor.setText("\uc800\uc790\uc0c9");
        authorColor.setBackground(backgroundColor);
        this.authorColorValue = new StyledText(authorColorValueRow, 2048);
        this.authorColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button colorBtn = new Button((Composite)group, 8);
        colorBtn.setText("\uc0c9\uc0c1 \uc120\ud0dd");
        colorBtn.addListener(13, e -> {
            ColorPaletteDialog dlg = new ColorPaletteDialog(parent.getShell(), hsv -> {
                System.out.printf("\uc120\ud0dd\ub41c HSV: H=%.2f, S=%.2f, V=%.2f%n", Float.valueOf(hsv[0]), Float.valueOf(hsv[1]), Float.valueOf(hsv[2]));
                RGB rgb = EpubColorUtil.hsvToRGB(hsv);
                String hexColor = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                System.out.println("HEX: " + String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue));
                RGB previewRGB = EpubColorUtil.hsvToRGB(hsv);
                Color color = new Color((Device)parent.getDisplay(), previewRGB);
                if (this.bgColorCheck.getSelection()) {
                    this.selectedColorMap.put("bg", hexColor);
                    this.prefs.put("color.bg", hexColor);
                    System.out.println("\u2192 \ubc30\uacbd \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    bgColorPreview.setBackground(color);
                    bgColorPreview.addDisposeListener(ev -> color.dispose());
                    this.bgColorValue.setText(hexColor);
                }
                if (this.titleColorCheck.getSelection()) {
                    this.selectedColorMap.put("title", hexColor);
                    this.prefs.put("color.title", hexColor);
                    System.out.println("\u2192 \uc81c\ubaa9 \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    titleColorPreview.setBackground(color);
                    titleColorPreview.addDisposeListener(ev -> color.dispose());
                    this.titleColorValue.setText(hexColor);
                }
                if (this.subtitleColorCheck.getSelection()) {
                    this.selectedColorMap.put("subtitle", hexColor);
                    this.prefs.put("color.subtitle", hexColor);
                    System.out.println("\u2192 \ubd80\uc81c \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    subTitleColorPreview.setBackground(color);
                    subTitleColorPreview.addDisposeListener(ev -> color.dispose());
                    this.subTitleColorValue.setText(hexColor);
                }
                if (this.authorColorCheck.getSelection()) {
                    this.selectedColorMap.put("author", hexColor);
                    this.prefs.put("color.author", hexColor);
                    System.out.println("\u2192 \uc800\uc790\uba85 \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    authorColorPreview.setBackground(color);
                    authorColorPreview.addDisposeListener(ev -> color.dispose());
                    this.authorColorValue.setText(hexColor);
                }
                try {
                    this.prefs.flush();
                }
                catch (BackingStoreException ex) {
                    ex.printStackTrace();
                }
                this.showPreview();
                parent.addDisposeListener(ev -> bgColorPreview.dispose());
                parent.addDisposeListener(ev -> titleColorPreview.dispose());
                parent.addDisposeListener(ev -> subTitleColorPreview.dispose());
                parent.addDisposeListener(ev -> authorColorPreview.dispose());
            });
            dlg.open();
        });
        Button previewBtn = new Button(container, 8);
        previewBtn.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        previewBtn.addListener(13, e -> this.showPreview());
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        Button saveBtn = new Button(container, 8);
        saveBtn.setText("\uc800\uc7a5");
        GridData btnData = new GridData();
        btnData.horizontalSpan = 2;
        btnData.horizontalAlignment = 131072;
        saveBtn.setLayoutData((Object)btnData);
        saveBtn.addListener(13, e -> this.saveXHTML());
    }

    private void createPreview(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(container, 2048);
        GridData browserData = new GridData(4, 4, true, true, 2, 1);
        this.browser.setLayoutData((Object)browserData);
        this.browser.setText("<p>\ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uace0 \ubbf8\ub9ac\ubcf4\uae30 \ubc84\ud2bc\uc744 \ub20c\ub7ec\uc8fc\uc138\uc694.</p>");
    }

    private void showPreview() {
        System.out.println("showPreview()");
        if (this.selectedTemplateItem == null) {
            this.browser.setText("<p>\uba3c\uc800 \ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uc138\uc694.</p>");
            return;
        }
        String fileName = this.selectedTemplateItem.fileName;
        System.out.println("fileName : " + fileName);
        if (fileName == null) {
            this.browser.setText("<p>\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud15c\ud50c\ub9bf\uc785\ub2c8\ub2e4.</p>");
            return;
        }
        String title = this.titleText.getText().trim();
        String subTitle = this.subTitleText.getText().trim();
        String author = this.authorText.getText().trim();
        String alt = this.altText.getText().trim();
        String imgPath = this.imagePathText.getText().trim();
        title = title.replaceAll("\\r?\\n", "<br/>");
        subTitle = subTitle.replaceAll("\\r?\\n", "<br/>");
        String bgColor = this.prefs.get("color.bg", "#FFC0CB");
        String titleColor = this.prefs.get("color.title", "#000000");
        String subTitleColor = this.prefs.get("color.subtitle", "#222222");
        String authorColor = this.prefs.get("color.author", "#666666");
        String templateHtml = ResourceUtil.loadFromBundle("resources/templates/cover", fileName);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("\uc81c\ubaa9", title);
        values.put("\ubd80\uc81c", subTitle);
        values.put("\uc800\uc790\uba85", author == null ? "" : author);
        values.put("\uc774\ubbf8\uc9c0\uc124\uba85", alt);
        values.put("\uc774\ubbf8\uc9c0\uacbd\ub85c", imgPath);
        values.put("\uc81c\ubaa9\uc0c9", titleColor);
        values.put("\ubd80\uc81c\uc0c9", subTitleColor);
        values.put("\uc800\uc790\uc0c9", authorColor);
        values.put("\ubc30\uacbd\uc0c9", bgColor);
        if ("cover_template3.xhtml".equalsIgnoreCase(this.selectedTemplateItem.fileName)) {
            String base64Data = ResourceUtil.convertImageTobase64Data(imgPath);
            String imageData = "data:image/jpeg;base64," + base64Data;
            values.put("\uc774\ubbf8\uc9c0\uacbd\ub85c", imageData);
        } else {
            values.put("\uc774\ubbf8\uc9c0\uacbd\ub85c", imgPath);
        }
        String renderedHtml = this.replaceVariables(templateHtml, values);
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String resultHtmlContent = this.changeStypePath(projectFullPath, renderedHtml);
        this.browser.setText(resultHtmlContent);
    }

    private void saveXHTML() {
        System.out.println("saveXHTML()");
        String title = this.titleText.getText().trim();
        String subTitle = this.subTitleText.getText().trim();
        String author = this.authorText.getText().trim();
        String alt = this.altText.getText().trim();
        String imgPath = this.imagePathText.getText().trim();
        title = title.replaceAll("\\r?\\n", "<br/>");
        subTitle = subTitle.replaceAll("\\r?\\n", "<br/>");
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        TemplateItem selectedTemplate = null;
        if (selection != null && !selection.isEmpty()) {
            selectedTemplate = (TemplateItem)selection.getFirstElement();
        } else {
            Object data;
            TreeItem[] items = this.treeViewer.getTree().getItems();
            if (items.length > 0 && (data = items[0].getData()) instanceof String) {
                selectedTemplate = (TemplateItem)data;
                this.treeViewer.setSelection((ISelection)new StructuredSelection(data));
            }
        }
        if (selectedTemplate == null) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.templateList.size()) {
            if (this.templateList.get(i).equals(selectedTemplate)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        String templateFileName = "cover_template" + index + ".xhtml";
        try {
            String xhtmlContent = ResourceUtil.loadFromBundle("resources/templates/cover", templateFileName);
            String bgColor = this.prefs.get("color.bg", "#FFC0CB");
            String titleColor = this.prefs.get("color.title", "#000000");
            String subTitleColor = this.prefs.get("color.subtitle", "#222222");
            String authorColor = this.prefs.get("color.author", "#666666");
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("\uc81c\ubaa9", title);
            values.put("\ubd80\uc81c", subTitle);
            values.put("\uc800\uc790\uba85", author == null ? "" : author);
            values.put("\uc774\ubbf8\uc9c0\uc124\uba85", alt);
            values.put("\uc81c\ubaa9\uc0c9", titleColor);
            values.put("\ubd80\uc81c\uc0c9", subTitleColor);
            values.put("\uc800\uc790\uc0c9", authorColor);
            values.put("\ubc30\uacbd\uc0c9", bgColor);
            xhtmlContent = this.replaceVariables(xhtmlContent, values);
            xhtmlContent = xhtmlContent.replace("<p><p>", "<p>").replace("</p></p>", "</p>");
            xhtmlContent = this.processImageBase64(xhtmlContent, imgPath);
            Path outputDir = Paths.get(EpubBuildUtil.getProjectFullPath(), "OEBPS", "Text");
            Files.createDirectories(outputDir, new FileAttribute[0]);
            long count = Files.list(outputDir).filter(p -> p.getFileName().toString().startsWith("cover") && p.toString().endsWith(".xhtml")).count();
            String fileName = String.format("cover%d.xhtml", count + 1L);
            if (count == 0L) {
                fileName = "cover.xhtml";
                Files.writeString(outputDir.resolve(fileName), (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
                ContentOpfManager.getInstance().updateMenifestAndSpine(fileName);
                EpubPartManager.getInstance().refreshProjectExplorer(this.partService, fileName);
                String message = "\ud45c\uc9c0 \uc0dd\uc131\ud558\uc600\uc2b5\ub2c8\ub2e4.";
                CommonUtil.showMessageBox(this.shell, message);
            } else {
                this.openMessage(this.shell, outputDir, fileName, xhtmlContent);
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)"\uc624\ub958", (String)e.getMessage());
        }
    }

    private void openMessage(Shell parentShell, Path outputDir, String fileName, String xhtmlContent) {
        MessageBox messageBox = new MessageBox(parentShell, 452);
        messageBox.setText("\ud30c\uc77c \uc874\uc7ac");
        messageBox.setMessage("cover.xhtml\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4.\n\ub36e\uc5b4\uc4f0\uc2dc\uaca0\uc2b5\ub2c8\uae4c? (\uc544\ub2c8\uc624 \uc120\ud0dd \uc2dc cover2.xhtml \uc0dd\uc131)");
        int response = messageBox.open();
        Path targetPath = outputDir.resolve(fileName);
        Object message = "";
        if (response == 64) {
            fileName = "cover.xhtml";
            targetPath = outputDir.resolve(fileName);
            try {
                Files.writeString(targetPath, (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ResourceUtil.createXhtmlFile(outputDir, fileName, xhtmlContent);
            message = fileName + " \ud30c\uc77c\uc774 \ub36e\uc5b4\uc4f0\uae30\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            CommonUtil.showMessageBox(this.shell, (String)message);
        } else if (response == 128) {
            ResourceUtil.createXhtmlFile(outputDir, fileName, xhtmlContent);
            message = fileName + " \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            this.applyOpf(this.shell, fileName, (String)message);
        }
    }

    private void applyOpf(Shell shell, String fileName, String message) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        boolean isXhtml = true;
        boolean addToScripted = true;
        boolean addToLinearNo = true;
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
        String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
        OpfNcxUpdater.addFileToOpf(iFolder.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addToLinearNo);
        CommonUtil.showMessageBox(shell, message);
    }

    private String replaceVariables(String template, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Object value = entry.getValue();
            if ("\uba85\uc5b8".equals(entry.getKey()) && !((String)value).isEmpty()) {
                value = "\u201c" + entry.getValue() + "\u201d";
            }
            template = template.replace("${" + entry.getKey() + "}", (CharSequence)value);
        }
        return template;
    }

    public static String convertNewlinesToParagraphs(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String[] lines = text.split("\\r?\\n");
        StringBuilder html = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                html.append("<p>").append(CoverTemplateEditorPage.escapeHtml(line)).append("</p>");
            }
            ++n2;
        }
        return html.toString();
    }

    public static String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private String changeStypePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Styles/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String styleFileName = matcher.group(1);
            File styleFile = new File(projectFullPath, "OEBPS/Styles/" + styleFileName);
            String styleUri = styleFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String changeImagePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Images/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String imageFileName = matcher.group(1);
            File imageFile = new File(projectFullPath, "OEBPS/Images/" + imageFileName);
            String imageUri = imageFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(imageUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String processImageBase64(String xhtml, String imagePath) {
        String finalHtml = "";
        if (imagePath != null) {
            String mimeType = ResourceUtil.getMimeType(imagePath);
            String base64Image = ResourceUtil.encodeImageToBase64(imagePath);
            if (base64Image != null) {
                String base64Src = "data:" + mimeType + ";base64," + base64Image;
                finalHtml = xhtml.replace("${\uc774\ubbf8\uc9c0\uacbd\ub85c}", base64Src);
                System.out.println(finalHtml);
            }
        }
        return finalHtml;
    }
}

