/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.pages;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.dialogs.ColorPaletteDialog;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.TemplateTreeContentProvider;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.EpubColorUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TemplateEditorPage {
    private Text titleText;
    private Text contentText;
    private Text altText;
    private Text imagePathText;
    private Text quoteText;
    private TreeViewer treeViewer;
    private Browser browser;
    private Preferences prefs;
    private String[] templates = new String[]{"\ud15c\ud50c\ub9bf 1 - \uae30\ubcf8\ud615", "\ud15c\ud50c\ub9bf 2 - \uc774\ubbf8\uc9c0 \uc67c\ucabd", "\ud15c\ud50c\ub9bf 3 - \uc0c1\ub2e8 \uc774\ubbf8\uc9c0 + \uba85\uc5b8 \ubc15\uc2a4", "\ud15c\ud50c\ub9bf 4 - \uce74\ub4dc\ud615 \uc911\uc559 \ubc15\uc2a4", "\ud15c\ud50c\ub9bf 5 - \ub2e4\ud06c \ubaa8\ub4dc", "\ud15c\ud50c\ub9bf 6 - \uc0c1\ub2e8\uc774\ubbf8\uc9c0 + \uc6b0\uce21\uae00"};
    private String selectedTemplate = "";
    Map<String, String> selectedColorMap = new HashMap<String, String>();
    Button bgColorCheck;
    Button titleColorCheck;
    Button textColorCheck;
    StyledText bgColorValue;
    StyledText titleColorValue;
    StyledText textColorValue;
    @Inject
    private Shell shell;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;

    @PostConstruct
    public void createControls(Composite parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent composite cannot be null");
        }
        this.prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftTreeViewer((Composite)sashForm);
        this.createRightForm((Composite)sashForm);
        this.createPreview((Composite)sashForm);
        sashForm.setWeights(new int[]{20, 35, 45});
    }

    private void createLeftTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new TemplateTreeContentProvider());
        this.treeViewer.setInput((Object)this.templates);
        this.treeViewer.addSelectionChangedListener(event -> {
            ITreeSelection selection = this.treeViewer.getStructuredSelection();
            this.selectedTemplate = (String)selection.getFirstElement();
            System.out.println("\uc120\ud0dd\ud55c \ud15c\ud50c\ub9bf : " + this.selectedTemplate);
            this.showPreview();
        });
    }

    private void createRightForm(Composite parent) {
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(backgroundColor);
        Label titleLabel = new Label(container, 0);
        titleLabel.setText("\uc81c\ubaa9");
        titleLabel.setBackground(backgroundColor);
        this.titleText = new Text(container, 2626);
        GridData gdTitleText = new GridData(4, 16512, true, false, 2, 1);
        int lineHeight = this.titleText.getLineHeight();
        gdTitleText.heightHint = lineHeight * 3;
        this.titleText.setLayoutData((Object)gdTitleText);
        this.titleText.addModifyListener(e -> this.showPreview());
        Label contentLabel = new Label(container, 0);
        contentLabel.setText("\ub0b4\uc6a9");
        contentLabel.setBackground(backgroundColor);
        this.contentText = new Text(container, 2626);
        GridData gdContent = new GridData(4, 4, true, false, 2, 1);
        int lineHeightContent = this.contentText.getLineHeight();
        gdContent.heightHint = lineHeightContent * 10;
        this.contentText.setLayoutData((Object)gdContent);
        this.contentText.addModifyListener(e -> this.showPreview());
        Label quoteLabel = new Label(container, 0);
        quoteLabel.setText("\uba85\uc5b8");
        quoteLabel.setBackground(backgroundColor);
        this.quoteText = new Text(container, 2048);
        this.quoteText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button quoteBtn = new Button(container, 8);
        quoteBtn.setText("\ucc3e\uae30");
        quoteBtn.addListener(13, e -> {
            Object result;
            ParameterizedCommand cmd = this.commandService.createCommand("kr.co.goms.epub.solution.command.openepubquotemain", null);
            if (cmd != null && (result = this.handlerService.executeHandler(cmd)) instanceof String) {
                String quote = (String)result;
                this.quoteText.setText(quote);
            }
        });
        this.quoteText.addModifyListener(e -> this.showPreview());
        Label imgLabel = new Label(container, 0);
        imgLabel.setText("\uc774\ubbf8\uc9c0\uacbd\ub85c");
        imgLabel.setBackground(backgroundColor);
        this.imagePathText = new Text(container, 2048);
        this.imagePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseBtn = new Button(container, 8);
        browseBtn.setText("\ucc3e\uae30");
        browseBtn.addListener(13, e -> {
            FileDialog dialog = new FileDialog(container.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.jpg", "*.jpeg", "*.png", "*.gif"});
            String selectedImagePath = dialog.open();
            if (selectedImagePath != null) {
                this.imagePathText.setText(selectedImagePath);
            }
        });
        Label altLabel = new Label(container, 0);
        altLabel.setText("\uc774\ubbf8\uc9c0\uc124\uba85");
        altLabel.setBackground(backgroundColor);
        this.altText = new Text(container, 2048);
        this.altText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.altText.addModifyListener(e -> this.showPreview());
        Group group = new Group(container, 0);
        group.setText("EPUB Color");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = 3;
        group.setLayoutData((Object)groupData);
        group.setBackground(backgroundColor);
        Group targetGroup = new Group((Composite)group, 0);
        targetGroup.setText("\uc0c9\uc0c1 \uc801\uc6a9 \ub300\uc0c1");
        targetGroup.setLayout((Layout)new GridLayout(1, false));
        targetGroup.setBackground(backgroundColor);
        Composite bgColorRow = new Composite((Composite)targetGroup, 0);
        bgColorRow.setLayout((Layout)new GridLayout(2, false));
        bgColorRow.setBackground(backgroundColor);
        this.bgColorCheck = new Button(bgColorRow, 32);
        this.bgColorCheck.setText("\ubc30\uacbd\uc0c9");
        this.bgColorCheck.setBackground(backgroundColor);
        Canvas bgColorPreview = new Canvas(bgColorRow, 2048);
        bgColorPreview.setLayoutData((Object)new GridData(12, 12));
        bgColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite titleColorRow = new Composite((Composite)targetGroup, 0);
        titleColorRow.setLayout((Layout)new GridLayout(2, false));
        titleColorRow.setBackground(backgroundColor);
        this.titleColorCheck = new Button(titleColorRow, 32);
        this.titleColorCheck.setText("\uc81c\ubaa9\uc0c9");
        this.titleColorCheck.setBackground(backgroundColor);
        Canvas titleColorPreview = new Canvas(titleColorRow, 2048);
        titleColorPreview.setLayoutData((Object)new GridData(12, 12));
        titleColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Composite textColorRow = new Composite((Composite)targetGroup, 0);
        textColorRow.setLayout((Layout)new GridLayout(2, false));
        textColorRow.setBackground(backgroundColor);
        this.textColorCheck = new Button(textColorRow, 32);
        this.textColorCheck.setText("\uae00\uc790\uc0c9");
        this.textColorCheck.setBackground(backgroundColor);
        Canvas textColorPreview = new Canvas(textColorRow, 2048);
        textColorPreview.setLayoutData((Object)new GridData(12, 12));
        textColorPreview.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 0));
        Group targetPreviewGroup = new Group((Composite)group, 0);
        targetPreviewGroup.setText("\uc0c9\uc0c1\uac12");
        targetPreviewGroup.setLayout((Layout)new GridLayout(1, false));
        targetPreviewGroup.setBackground(backgroundColor);
        Composite bgColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        bgColorValueRow.setLayout((Layout)new GridLayout(2, false));
        bgColorValueRow.setBackground(backgroundColor);
        Label bgColor = new Label(bgColorValueRow, 0);
        bgColor.setText("\ubc30\uacbd\uc0c9");
        bgColor.setBackground(backgroundColor);
        this.bgColorValue = new StyledText(bgColorValueRow, 2048);
        this.bgColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite titleColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        titleColorValueRow.setLayout((Layout)new GridLayout(2, false));
        titleColorValueRow.setBackground(backgroundColor);
        Label authorInfoColor = new Label(titleColorValueRow, 0);
        authorInfoColor.setText("\uc81c\ubaa9\uc0c9");
        authorInfoColor.setBackground(backgroundColor);
        this.titleColorValue = new StyledText(titleColorValueRow, 2048);
        this.titleColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite textInfoColorValueRow = new Composite((Composite)targetPreviewGroup, 0);
        textInfoColorValueRow.setLayout((Layout)new GridLayout(2, false));
        textInfoColorValueRow.setBackground(backgroundColor);
        Label titleInfoColor = new Label(textInfoColorValueRow, 0);
        titleInfoColor.setText("\uae00\uc790\uc0c9");
        titleInfoColor.setBackground(backgroundColor);
        this.textColorValue = new StyledText(textInfoColorValueRow, 2048);
        this.textColorValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button colorBtn = new Button((Composite)group, 8);
        colorBtn.setText("\uc0c9\uc0c1 \uc120\ud0dd");
        colorBtn.addListener(13, e -> {
            ColorPaletteDialog dlg = new ColorPaletteDialog(parent.getShell(), hsv -> {
                System.out.printf("\uc120\ud0dd\ub41c HSV: H=%.2f, S=%.2f, V=%.2f%n", Float.valueOf(hsv[0]), Float.valueOf(hsv[1]), Float.valueOf(hsv[2]));
                RGB rgb = EpubColorUtil.hsvToRGB(hsv);
                String hexColor = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                System.out.println("HEX: " + String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue));
                RGB previewRGB = EpubColorUtil.hsvToRGB(hsv);
                Color color = new Color((Device)parent.getDisplay(), previewRGB);
                if (this.bgColorCheck.getSelection()) {
                    this.selectedColorMap.put("bg", hexColor);
                    this.prefs.put("page.color.bg", hexColor);
                    System.out.println("\u2192 \ubc30\uacbd \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    bgColorPreview.setBackground(color);
                    bgColorPreview.addDisposeListener(ev -> color.dispose());
                    this.bgColorValue.setText(hexColor);
                }
                if (this.titleColorCheck.getSelection()) {
                    this.selectedColorMap.put("title", hexColor);
                    this.prefs.put("page.color.title", hexColor);
                    System.out.println("\u2192 \uc81c\ubaa9 \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    titleColorPreview.setBackground(color);
                    titleColorPreview.addDisposeListener(ev -> color.dispose());
                    this.titleColorValue.setText(hexColor);
                }
                if (this.textColorCheck.getSelection()) {
                    this.selectedColorMap.put("text", hexColor);
                    this.prefs.put("page.color.text", hexColor);
                    System.out.println("\u2192 \ub0b4\uc6a9 \uc0c9\uc0c1 \uc801\uc6a9: " + hexColor);
                    textColorPreview.setBackground(color);
                    textColorPreview.addDisposeListener(ev -> color.dispose());
                    this.textColorValue.setText(hexColor);
                }
                try {
                    this.prefs.flush();
                }
                catch (BackingStoreException ex) {
                    ex.printStackTrace();
                }
                this.showPreview();
                parent.addDisposeListener(ev -> bgColorPreview.dispose());
                parent.addDisposeListener(ev -> titleColorPreview.dispose());
                parent.addDisposeListener(ev -> textColorPreview.dispose());
            });
            dlg.open();
        });
        new Label(container, 0);
        Button previewBtn = new Button(container, 8);
        previewBtn.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        previewBtn.addListener(13, e -> this.showPreview());
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        Button saveBtn = new Button(container, 8);
        saveBtn.setText("\uc800\uc7a5");
        GridData btnData = new GridData();
        btnData.horizontalSpan = 2;
        btnData.horizontalAlignment = 131072;
        saveBtn.setLayoutData((Object)btnData);
        saveBtn.addListener(13, e -> this.saveXHTML());
    }

    private void createPreview(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(container, 2048);
        GridData browserData = new GridData(4, 4, true, true, 2, 1);
        this.browser.setLayoutData((Object)browserData);
        this.browser.setText("<p>\ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uace0 \ubbf8\ub9ac\ubcf4\uae30 \ubc84\ud2bc\uc744 \ub20c\ub7ec\uc8fc\uc138\uc694.</p>");
    }

    private void showPreview() {
        System.out.println("showPreview()");
        if (this.selectedTemplate.isEmpty()) {
            this.browser.setText("<p>\uba3c\uc800 \ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uc138\uc694.</p>");
            return;
        }
        String fileName = switch (this.selectedTemplate) {
            case "\ud15c\ud50c\ub9bf 1 - \uae30\ubcf8\ud615" -> "template1.xhtml";
            case "\ud15c\ud50c\ub9bf 2 - \uc774\ubbf8\uc9c0 \uc67c\ucabd" -> "template2.xhtml";
            case "\ud15c\ud50c\ub9bf 3 - \uc0c1\ub2e8 \uc774\ubbf8\uc9c0 + \uba85\uc5b8 \ubc15\uc2a4" -> "template3.xhtml";
            case "\ud15c\ud50c\ub9bf 4 - \uce74\ub4dc\ud615 \uc911\uc559 \ubc15\uc2a4" -> "template4.xhtml";
            case "\ud15c\ud50c\ub9bf 5 - \ub2e4\ud06c \ubaa8\ub4dc" -> "template5.xhtml";
            case "\ud15c\ud50c\ub9bf 6 - \uc0c1\ub2e8\uc774\ubbf8\uc9c0 + \uc6b0\uce21\uae00" -> "template6.xhtml";
            default -> null;
        };
        System.out.println("fileName : " + fileName);
        if (fileName == null) {
            this.browser.setText("<p>\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud15c\ud50c\ub9bf\uc785\ub2c8\ub2e4.</p>");
            return;
        }
        String title = CommonUtil.convertNltoBr(this.titleText.getText());
        String htmlContent = TemplateEditorPage.convertNewlinesToParagraphs(this.contentText.getText());
        String alt = this.altText.getText();
        String imgDesc = this.imagePathText.getText();
        String quote = this.quoteText.getText();
        System.out.println("content : " + this.contentText.getText());
        System.out.println("htmlContent : " + htmlContent);
        String bgColor = this.prefs.get("page.color.bg", "#08203c");
        String titleColor = this.prefs.get("page.color.title", "#ffffff");
        String textColor = this.prefs.get("page.color.text", "#ffffff");
        String templateHtml = ResourceUtil.loadFromBundle("resources/templates", fileName);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("\uc81c\ubaa9", title);
        values.put("\ub0b4\uc6a9", htmlContent);
        values.put("\uc774\ubbf8\uc9c0\uc124\uba85", alt);
        values.put("\uc774\ubbf8\uc9c0\uacbd\ub85c", imgDesc);
        values.put("\uba85\uc5b8", quote == null ? "" : quote);
        values.put("\ubc30\uacbd\uc0c9", bgColor);
        values.put("\uc81c\ubaa9\uc0c9", titleColor);
        values.put("\uae00\uc790\uc0c9", textColor);
        String renderedHtml = this.replaceVariables(templateHtml, values);
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String resultHtmlContent = this.changeStypePath(projectFullPath, renderedHtml);
        this.browser.setText(resultHtmlContent);
    }

    private void saveXHTML() {
        System.out.println("saveXHTML()");
        this.titleText.getText().trim();
        String content = this.contentText.getText().trim();
        this.quoteText.getText().trim();
        this.altText.getText().trim();
        String imgPath = this.imagePathText.getText().trim();
        String htmlContent = TemplateEditorPage.convertNewlinesToParagraphs(content);
        System.out.println("content : " + content);
        System.out.println("htmlContent : " + htmlContent);
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        String selectedTemplate = (String)selection.getFirstElement();
        if (selectedTemplate == null) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.templates.length) {
            if (this.templates[i].equals(selectedTemplate)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        String templateFileName = "template" + index + ".xhtml";
        try {
            String bgColor = this.prefs.get("page.color.bg", "#08203c");
            String titleColor = this.prefs.get("page.color.title", "#ffffff");
            String textColor = this.prefs.get("page.color.text", "#ffffff");
            String renderedHtml = ResourceUtil.loadFromBundle("resources/templates", templateFileName);
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("\uc81c\ubaa9", this.titleText.getText());
            values.put("\ub0b4\uc6a9", htmlContent);
            values.put("\uc774\ubbf8\uc9c0\uc124\uba85", this.altText.getText());
            values.put("\uba85\uc5b8", this.quoteText.getText() == null ? "" : this.quoteText.getText());
            values.put("\ubc30\uacbd\uc0c9", bgColor);
            values.put("\uc81c\ubaa9\uc0c9", titleColor);
            values.put("\uae00\uc790\uc0c9", textColor);
            renderedHtml = this.replaceVariables(renderedHtml, values);
            renderedHtml = renderedHtml.replace("<p><p>", "<p>").replace("</p></p>", "</p>");
            renderedHtml = this.processImageBase64(renderedHtml, imgPath);
            Path outputDir = Paths.get(EpubBuildUtil.getProjectFullPath(), "OEBPS", "Text");
            Files.createDirectories(outputDir, new FileAttribute[0]);
            long count = Files.list(outputDir).filter(p -> p.getFileName().toString().startsWith("chapter") && p.toString().endsWith(".xhtml")).count();
            String fileName = String.format("chapter%d.xhtml", count + 1L);
            Files.writeString(outputDir.resolve(fileName), (CharSequence)renderedHtml, StandardCharsets.UTF_8, new OpenOption[0]);
            String projectName = EpubPreferenceManager.getInstance().getProjectName();
            boolean isXhtml = true;
            boolean addToScripted = true;
            boolean addToLinearNo = false;
            ResourceUtil.loadFromBundle("OEBPS", "content.opf");
            IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
            String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
            String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
            OpfNcxUpdater.addFileToOpf(iFolder.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addToLinearNo);
            MessageDialog.openInformation((Shell)this.shell, (String)"\uc800\uc7a5 \uc644\ub8cc", (String)(fileName + " \uc0dd\uc131 \uc644\ub8cc"));
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)"\uc624\ub958", (String)e.getMessage());
        }
    }

    private String replaceVariables(String template, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Object value = entry.getValue();
            if ("\uba85\uc5b8".equals(entry.getKey()) && !((String)value).isEmpty()) {
                value = "\u201c" + entry.getValue() + "\u201d";
            }
            template = template.replace("${" + entry.getKey() + "}", (CharSequence)value);
        }
        return template;
    }

    public static String convertNewlinesToParagraphs(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String[] lines = text.split("\\r?\\n");
        StringBuilder html = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                html.append("<p>").append(TemplateEditorPage.escapeHtml(line)).append("</p>");
            }
            ++n2;
        }
        return html.toString();
    }

    public static String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private String changeStypePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Styles/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String styleFileName = matcher.group(1);
            File styleFile = new File(projectFullPath, "OEBPS/Styles/" + styleFileName);
            String styleUri = styleFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String changeImagePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Images/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String imageFileName = matcher.group(1);
            File imageFile = new File(projectFullPath, "OEBPS/Images/" + imageFileName);
            String imageUri = imageFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(imageUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String processImageBase64(String xhtml, String imagePath) {
        String finalHtml = "";
        if (imagePath != null) {
            String mimeType = ResourceUtil.getMimeType(imagePath);
            String base64Image = ResourceUtil.encodeImageToBase64(imagePath);
            if (base64Image != null) {
                String base64Src = "data:" + mimeType + ";base64," + base64Image;
                finalHtml = xhtml.replace("${\uc774\ubbf8\uc9c0\uacbd\ub85c}", base64Src);
                System.out.println(finalHtml);
            }
        }
        return finalHtml;
    }
}

