/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kr.co.goms.epub.solution.accessibility.HeadingIssue;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AccessibilityHeadingCheckResultPart {
    private TableViewer viewer;
    private List<HeadingIssue> rows;
    @Inject
    IEclipseContext context;

    @PostConstruct
    public void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List issues = (List)this.context.get("headingIssues");
        if (issues == null) {
            issues = Collections.emptyList();
        }
        this.rows = new ArrayList(issues);
        this.rows.sort(this.getHeadingIssueComparator());
        this.viewer.setInput(this.rows);
    }

    private void createColumns() {
        TableViewerColumn colFile = new TableViewerColumn(this.viewer, 16384);
        colFile.getColumn().setText("\ud30c\uc77c");
        colFile.getColumn().setWidth(250);
        colFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingIssue i = (HeadingIssue)element;
                return i.getFile().getName();
            }
        });
        TableViewerColumn colType = new TableViewerColumn(this.viewer, 16384);
        colType.getColumn().setText("\uc720\ud615");
        colType.getColumn().setWidth(130);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingIssue i = (HeadingIssue)element;
                return i.getType().name();
            }
        });
        TableViewerColumn colTag = new TableViewerColumn(this.viewer, 16384);
        colTag.getColumn().setText("\ud0dc\uadf8");
        colTag.getColumn().setWidth(60);
        colTag.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingIssue i = (HeadingIssue)element;
                return i.getTagName();
            }
        });
        TableViewerColumn colMsg = new TableViewerColumn(this.viewer, 16384);
        colMsg.getColumn().setText("\uba54\uc2dc\uc9c0");
        colMsg.getColumn().setWidth(400);
        colMsg.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingIssue i = (HeadingIssue)element;
                return i.getMessage();
            }
        });
    }

    private Comparator<HeadingIssue> getHeadingIssueComparator() {
        return Comparator.comparingInt(issue -> {
            String name = issue.getFile().getName().toLowerCase();
            if (name.equals("cover.xhtml")) {
                return 1;
            }
            if (name.equals("nav.xhtml")) {
                return 2;
            }
            if (name.equals("loi.xhtml")) {
                return 3;
            }
            if (name.equals("lot.xhtml")) {
                return 4;
            }
            if (name.equals("author.xhtml")) {
                return 5;
            }
            if (name.startsWith("chapter")) {
                int[] numbers = this.extractChapterNumbers(name);
                int main = numbers[0];
                int sub = numbers[1];
                return main * 10000 + sub;
            }
            return Integer.MAX_VALUE;
        });
    }

    private int[] extractChapterNumbers(String name) {
        String s = name.replace("chapter", "").replace(".xhtml", "");
        int main = 0;
        int sub = 0;
        try {
            if (s.contains("-")) {
                String[] parts = s.split("-");
                main = Integer.parseInt(parts[0].replaceAll("[^0-9]", ""));
                sub = Integer.parseInt(parts[1].replaceAll("[^0-9]", ""));
            } else {
                main = Integer.parseInt(s.replaceAll("[^0-9]", ""));
                sub = 0;
            }
        }
        catch (Exception exception) {
            return new int[]{999999, 999999};
        }
        return new int[]{main, sub};
    }
}

