/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.co.goms.epub.solution.accessibility.HeadingRow;
import kr.co.goms.epub.solution.accessibility.NavXhtmlSync;
import kr.co.goms.epub.solution.accessibility.NavXhtmlWriter;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AccessibilityHeadingEditPart {
    @Inject
    MApplication application;
    private TableViewer viewer;
    private List<HeadingRow> rows;

    @PostConstruct
    public void createControls(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        Table table = new Table(parent, 67620);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        CheckboxTableViewer checkboxViewer = new CheckboxTableViewer(table);
        this.viewer = checkboxViewer;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTable());
        checkboxViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                HeadingRow row = (HeadingRow)element;
                return row.isInToc();
            }
        });
        checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                HeadingRow row = (HeadingRow)event.getElement();
                row.setInToc(event.getChecked());
            }
        });
        this.createColumns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IEclipseContext appCtx = this.application.getContext();
        List list = (List)appCtx.get("headingRowsForEdit");
        this.rows = list != null ? new ArrayList<HeadingRow>(list) : new ArrayList();
        this.rows.sort(this.getHeadingRowComparator());
        Path navPath = this.getCurrentNavFile().toPath();
        try {
            NavXhtmlSync.syncInTocFromNav(navPath, this.rows);
        }
        catch (Exception exception) {}
        this.viewer.setInput(this.rows);
        this.viewer.refresh();
        Composite btnArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        btnArea.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)btnArea);
        Button btnNav = new Button(btnArea, 8);
        btnNav.setText("nav.xhtml\uc0dd\uc131");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)btnNav);
        btnNav.addListener(13, e -> {
            try {
                this.generateNav();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        Button btnSave = new Button(btnArea, 8);
        btnSave.setText("\uc800\uc7a5 (\uc18c\uc2a4\uc5d0 \ubc18\uc601)");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)btnSave);
    }

    private void generateNav() throws Exception {
        String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        Path navPath = Path.of(textPath, new String[0]).resolve("nav.xhtml");
        List list = (List)this.viewer.getInput();
        if (list == null || list.isEmpty()) {
            GomsLogPart.log("[Nav\uc0dd\uc131] \ud5e4\ub529 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        NavXhtmlWriter.writeNav(navPath, list, this.getHeadingRowComparator());
        NavXhtmlSync.syncInTocFromNav(navPath, list);
        this.viewer.refresh();
    }

    private void createColumns(final TableViewer viewer) {
        TableViewerColumn tocCol = new TableViewerColumn(viewer, 0);
        TableColumn tc = tocCol.getColumn();
        tc.setWidth(50);
        tc.setText("TOC");
        tc.setResizable(true);
        tc.setMoveable(true);
        tocCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        TableViewerColumn colFile = new TableViewerColumn(viewer, 16384);
        colFile.getColumn().setText("\ud30c\uc77c");
        colFile.getColumn().setWidth(220);
        colFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingRow row = (HeadingRow)element;
                return row.getFile().getName();
            }
        });
        TableViewerColumn colType = new TableViewerColumn(viewer, 16384);
        colType.getColumn().setText("\ud0c0\uc785");
        colType.getColumn().setWidth(80);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingRow row = (HeadingRow)element;
                return row.getRowType().name();
            }
        });
        TableViewerColumn colTag = new TableViewerColumn(viewer, 16384);
        colTag.getColumn().setText("\ud0dc\uadf8");
        colTag.getColumn().setWidth(60);
        colTag.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingRow row = (HeadingRow)element;
                return row.getTagName();
            }
        });
        TableViewerColumn colText = new TableViewerColumn(viewer, 16384);
        colText.getColumn().setText("\ud14d\uc2a4\ud2b8");
        colText.getColumn().setWidth(400);
        colText.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HeadingRow row = (HeadingRow)element;
                return row.getText();
            }
        });
        tocCol.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((HeadingRow)element).isInToc();
            }

            protected void setValue(Object element, Object value) {
                HeadingRow row = (HeadingRow)element;
                row.setInToc((Boolean)value);
                viewer.update((Object)row, null);
            }
        });
    }

    private void saveToSource() {
        if (this.rows == null || this.rows.isEmpty()) {
            return;
        }
        Map<File, List<HeadingRow>> byFile = this.rows.stream().collect(Collectors.groupingBy(HeadingRow::getFile));
        for (Map.Entry<File, List<HeadingRow>> entry : byFile.entrySet()) {
            File file = entry.getKey();
            List<HeadingRow> fileRows = entry.getValue();
            try {
                Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
                List titleRows = fileRows.stream().filter(r -> r.getRowType() == HeadingRow.RowType.TITLE).collect(Collectors.toList());
                if (!titleRows.isEmpty()) {
                    HeadingRow tr = (HeadingRow)titleRows.get(0);
                    String newTitle = tr.getText() != null ? tr.getText() : "";
                    Element titleEl = doc.selectFirst("head > title");
                    if (titleEl == null) {
                        Element head = doc.selectFirst("head");
                        if (head != null) {
                            head.appendElement("title").text(newTitle);
                        }
                    } else {
                        titleEl.text(newTitle);
                    }
                }
                Elements headings = doc.select("h1, h2, h3, h4, h5");
                List headingRows = fileRows.stream().filter(r -> r.getRowType() == HeadingRow.RowType.HEADING).collect(Collectors.toList());
                for (HeadingRow hr : headingRows) {
                    int idx = hr.getIndex();
                    if (idx < 0 || idx >= headings.size()) continue;
                    Element hEl = (Element)headings.get(idx);
                    hEl.text(hr.getText() != null ? hr.getText() : "");
                }
                FileUtils.writeStringToFile((File)file, (String)doc.outerHtml(), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("\uc81c\ubaa9/Heading \ubcc0\uacbd \ub0b4\uc6a9\uc774 \uc18c\uc2a4\uc5d0 \ubc18\uc601\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
    }

    private Comparator<HeadingRow> getHeadingRowComparator() {
        return Comparator.comparingInt(row -> {
            String name = row.getFile().getName().toLowerCase();
            if (name.equals("cover.xhtml")) {
                return 1;
            }
            if (name.equals("nav.xhtml")) {
                return 2;
            }
            if (name.equals("loi.xhtml")) {
                return 3;
            }
            if (name.equals("lot.xhtml")) {
                return 4;
            }
            if (name.equals("author.xhtml")) {
                return 5;
            }
            if (name.startsWith("chapter")) {
                int[] parts = this.extractChapterNumbers(name);
                return 100000 + parts[0] * 1000 + parts[1];
            }
            return Integer.MAX_VALUE;
        });
    }

    private int[] extractChapterNumbers(String name) {
        String numbers = name.replace("chapter", "").replace(".xhtml", "");
        int main = 0;
        int sub = 0;
        try {
            if (numbers.contains("-")) {
                String[] tokens = numbers.split("-");
                main = Integer.parseInt(tokens[0].replaceAll("[^0-9]", ""));
                sub = Integer.parseInt(tokens[1].replaceAll("[^0-9]", ""));
            } else {
                main = Integer.parseInt(numbers.replaceAll("[^0-9]", ""));
            }
        }
        catch (Exception exception) {
            return new int[]{999999, 999999};
        }
        return new int[]{main, sub};
    }

    @PreDestroy
    public void dispose() {
    }

    private File getCurrentNavFile() {
        String contentNavPath = EpubBuildUtil.getProjectOEBPSNavFile();
        return new File(contentNavPath);
    }
}

