/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.co.goms.epub.solution.accessibility.ImageRow;
import kr.co.goms.epub.solution.accessibility.NavXhtmlWriter;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AccessibilityImageEditPart {
    @Inject
    MApplication application;
    private TableViewer viewer;
    private List<ImageRow> rows;

    @PostConstruct
    public void createControls(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTable());
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IEclipseContext appCtx = this.application.getContext();
        List list = (List)appCtx.get("ImageRowsForEdit");
        this.rows = list != null ? new ArrayList<ImageRow>(list) : new ArrayList();
        this.rows.sort(this.getImageRowComparator());
        this.viewer.setInput(this.rows);
        Composite btnArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        btnArea.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)btnArea);
        Button btnNav = new Button(btnArea, 8);
        btnNav.setText("loi.xhtml\uc0dd\uc131");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)btnNav);
        btnNav.addListener(13, e -> this.generateLoi());
    }

    private void generateLoi() {
        String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        Path loiPath = Path.of(textPath, new String[0]).resolve("loi.xhtml");
        List list = (List)this.viewer.getInput();
        if (list == null || list.isEmpty()) {
            GomsLogPart.log("[Loi\uc0dd\uc131] \uc774\ubbf8\uc9c0 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        try {
            NavXhtmlWriter.writeLoi(loiPath, list, this.getImageRowComparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createColumns() {
        TableViewerColumn colFile = new TableViewerColumn(this.viewer, 16384);
        colFile.getColumn().setText("\ud30c\uc77c");
        colFile.getColumn().setWidth(160);
        colFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImageRow row = (ImageRow)element;
                return row.getFile().getName();
            }
        });
        TableViewerColumn colSrc = new TableViewerColumn(this.viewer, 16384);
        colSrc.getColumn().setText("src");
        colSrc.getColumn().setWidth(260);
        colSrc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImageRow row = (ImageRow)element;
                return row.getSrc();
            }
        });
        TableViewerColumn colImgId = new TableViewerColumn(this.viewer, 16384);
        colImgId.getColumn().setText("id");
        colImgId.getColumn().setWidth(160);
        colImgId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImageRow row = (ImageRow)element;
                return row.getImgId();
            }
        });
        TableViewerColumn colAlt = new TableViewerColumn(this.viewer, 16384);
        colAlt.getColumn().setText("alt");
        colAlt.getColumn().setWidth(260);
        colAlt.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImageRow row = (ImageRow)element;
                return row.getAlt();
            }
        });
        colAlt.setEditingSupport((EditingSupport)new TextEditingSupport(this.viewer){

            @Override
            protected String get(Object element) {
                return ((ImageRow)element).getAlt();
            }

            @Override
            protected void set(Object element, String value) {
                ((ImageRow)element).setAlt(value);
            }
        });
        TableViewerColumn colRole = new TableViewerColumn(this.viewer, 16384);
        colRole.getColumn().setText("role");
        colRole.getColumn().setWidth(120);
        colRole.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImageRow row = (ImageRow)element;
                return row.getRole();
            }
        });
        colRole.setEditingSupport((EditingSupport)new TextEditingSupport(this.viewer){

            @Override
            protected String get(Object element) {
                return ((ImageRow)element).getRole();
            }

            @Override
            protected void set(Object element, String value) {
                ((ImageRow)element).setRole(value);
            }
        });
        TableViewerColumn colAria = new TableViewerColumn(this.viewer, 16384);
        colAria.getColumn().setText("aria-hidden");
        colAria.getColumn().setWidth(100);
        colAria.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImageRow row = (ImageRow)element;
                return row.getAriaHidden();
            }
        });
        colAria.setEditingSupport((EditingSupport)new TextEditingSupport(this.viewer){

            @Override
            protected String get(Object element) {
                return ((ImageRow)element).getAriaHidden();
            }

            @Override
            protected void set(Object element, String value) {
                ((ImageRow)element).setAriaHidden(value);
            }
        });
    }

    private void saveToSource() {
        if (this.rows == null || this.rows.isEmpty()) {
            return;
        }
        Map<File, List<ImageRow>> byFile = this.rows.stream().collect(Collectors.groupingBy(ImageRow::getFile));
        for (Map.Entry<File, List<ImageRow>> entry : byFile.entrySet()) {
            File file = entry.getKey();
            List<ImageRow> fileRows = entry.getValue();
            try {
                Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
                Elements imgs = doc.select("img");
                for (ImageRow row : fileRows) {
                    int idx = row.getIndex();
                    if (idx < 0 || idx >= imgs.size()) continue;
                    Element img = (Element)imgs.get(idx);
                    String alt = row.getAlt();
                    if (alt == null || alt.isEmpty()) {
                        img.removeAttr("alt");
                    } else {
                        img.attr("alt", alt);
                    }
                    String role = row.getRole();
                    if (role == null || role.isEmpty()) {
                        img.removeAttr("role");
                    } else {
                        img.attr("role", role);
                    }
                    String aria = row.getAriaHidden();
                    if (aria == null || aria.isEmpty()) {
                        img.removeAttr("aria-hidden");
                        continue;
                    }
                    img.attr("aria-hidden", aria);
                }
                FileUtils.writeStringToFile((File)file, (String)doc.outerHtml(), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("img \ud0dc\uadf8\uc5d0 \uc811\uadfc\uc131 \uc18d\uc131\uc774 \ubc18\uc601\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
    }

    private Comparator<ImageRow> getImageRowComparator() {
        return Comparator.comparingInt(row -> {
            String name = row.getFile().getName().toLowerCase();
            if (name.equals("cover.xhtml")) {
                return 1;
            }
            if (name.equals("nav.xhtml")) {
                return 2;
            }
            if (name.equals("loi.xhtml")) {
                return 3;
            }
            if (name.equals("lot.xhtml")) {
                return 4;
            }
            if (name.equals("author.xhtml")) {
                return 5;
            }
            if (name.startsWith("chapter")) {
                int[] parts = this.extractChapterNumbers(name);
                return 100000 + parts[0] * 1000 + parts[1];
            }
            return Integer.MAX_VALUE;
        });
    }

    private int[] extractChapterNumbers(String name) {
        String numbers = name.replace("chapter", "").replace(".xhtml", "");
        int main = 0;
        int sub = 0;
        try {
            if (numbers.contains("-")) {
                String[] tokens = numbers.split("-");
                main = Integer.parseInt(tokens[0].replaceAll("[^0-9]", ""));
                sub = Integer.parseInt(tokens[1].replaceAll("[^0-9]", ""));
            } else {
                main = Integer.parseInt(numbers.replaceAll("[^0-9]", ""));
            }
        }
        catch (Exception exception) {
            return new int[]{999999, 999999};
        }
        return new int[]{main, sub};
    }

    @PreDestroy
    public void dispose() {
    }

    private static abstract class TextEditingSupport
    extends EditingSupport {
        private final TextCellEditor editor;

        public TextEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            String v = this.get(element);
            return v != null ? v : "";
        }

        protected void setValue(Object element, Object value) {
            this.set(element, String.valueOf(value));
            this.getViewer().update(element, null);
        }

        protected abstract String get(Object var1);

        protected abstract void set(Object var1, String var2);
    }
}

