/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kr.co.goms.epub.solution.accessibility.AccessibilityMetaUtil;
import kr.co.goms.epub.solution.accessibility.MetaRow;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AccessibilityMetaEditPart {
    @Inject
    MApplication application;
    private TableViewer viewer;
    private List<MetaRow> rows = new ArrayList<MetaRow>();
    private File opfFile;

    @PostConstruct
    public void createControls(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTable());
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IEclipseContext appCtx = this.application.getContext();
        List list = (List)appCtx.get("MetaRowsForEdit");
        this.rows = list != null ? new ArrayList<MetaRow>(list) : Collections.emptyList();
        this.opfFile = (File)appCtx.get("opfFile");
        this.viewer.setInput(this.rows);
        Composite btnArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(btnArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btnArea);
        Button btnApply = new Button(btnArea, 8);
        btnApply.setText("\ud544\uc218 \ud56d\ubaa9 \uae30\ubcf8\uac12 \uc801\uc6a9");
        btnApply.addListener(13, e -> this.applyRequiredDefaults());
        Button btnSave = new Button(btnArea, 8);
        btnSave.setText("\uc800\uc7a5 (content.opf \ubc18\uc601)");
        btnSave.addListener(13, e -> this.saveToOpf());
    }

    private void createColumns() {
        TableViewerColumn colProperty = new TableViewerColumn(this.viewer, 16384);
        colProperty.getColumn().setText("property");
        colProperty.getColumn().setWidth(200);
        colProperty.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaRow row = (MetaRow)element;
                return row.getProperty();
            }
        });
        TableViewerColumn colLabel = new TableViewerColumn(this.viewer, 16384);
        colLabel.getColumn().setText("\uc124\uba85");
        colLabel.getColumn().setWidth(250);
        colLabel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaRow row = (MetaRow)element;
                return row.getLabel();
            }
        });
        TableViewerColumn colValue = new TableViewerColumn(this.viewer, 16384);
        colValue.getColumn().setText("\uac12");
        colValue.getColumn().setWidth(400);
        colValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaRow row = (MetaRow)element;
                String v = row.getValue();
                return v != null ? v : "";
            }
        });
        colValue.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){
            private final TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)AccessibilityMetaEditPart.this.viewer.getTable());
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                MetaRow row = (MetaRow)element;
                String v = row.getValue();
                return v != null ? v : "";
            }

            protected void setValue(Object element, Object value) {
                MetaRow row = (MetaRow)element;
                row.setValue(String.valueOf(value));
                AccessibilityMetaEditPart.this.viewer.update((Object)row, null);
            }
        });
        TableViewerColumn colRequired = new TableViewerColumn(this.viewer, 0x1000000);
        colRequired.getColumn().setText("\ud544\uc218");
        colRequired.getColumn().setWidth(60);
        colRequired.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaRow row = (MetaRow)element;
                return row.isRequired() ? "Y" : "";
            }
        });
        TableViewerColumn colStatus = new TableViewerColumn(this.viewer, 0x1000000);
        colStatus.getColumn().setText("\uc0c1\ud0dc");
        colStatus.getColumn().setWidth(80);
        colStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaRow row = (MetaRow)element;
                String v = row.getValue();
                if (row.isRequired() && (v == null || v.trim().isEmpty())) {
                    return "\ub204\ub77d";
                }
                return "OK";
            }
        });
    }

    private void applyRequiredDefaults() {
        if (this.rows == null) {
            return;
        }
        for (MetaRow row : this.rows) {
            String defVal;
            String v;
            if (!row.isRequired() || (v = row.getValue()) != null && !v.trim().isEmpty() || (defVal = row.getDef().getDefaultValue()) == null || defVal.isEmpty()) continue;
            row.setValue(defVal);
        }
        this.viewer.refresh();
    }

    private void saveToOpf() {
        if (this.opfFile == null || this.rows == null) {
            return;
        }
        try {
            AccessibilityMetaUtil.saveToOpf(this.opfFile, this.rows);
            System.out.println("\uc811\uadfc\uc131 \uba54\ud0c0\ub370\uc774\ud130 \uc800\uc7a5 \uc644\ub8cc: " + this.opfFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

