/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class AccessibilityNldPart {
    private static final String NLD_EAC_URL = "https://www.nld.go.kr/eac/verifSelf.do";
    private static final String DEFAULT_ORG_NAME = "GomsBook";
    private static final String DEFAULT_EMAIL = "omaro7@hanmail.net";
    private static final String DEFAULT_PASSWORD = "1234";
    private Browser browser;
    private Label lblEpubPath;
    private Path currentEpub;

    @Inject
    public AccessibilityNldPart() {
    }

    @PostConstruct
    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite topBar = new Composite(parent, 0);
        topBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        topBar.setLayout((Layout)new GridLayout(4, false));
        Label lblTitle = new Label(topBar, 0);
        lblTitle.setText("\uad6d\ub9bd\uc7a5\uc560\uc778\ub3c4\uc11c\uad00 \uc804\uc790\ucd9c\ud310\ubb3c \uc811\uadfc\uc131 \uc790\uac00\uac80\uc99d (NLD)");
        new Label(topBar, 0);
        this.lblEpubPath = new Label(topBar, 0);
        this.lblEpubPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lblEpubPath.setText("EPUB \ud30c\uc77c: (\uac80\uc0c9 \uc911...)");
        Button btnOpenFolder = new Button(topBar, 8);
        btnOpenFolder.setText("EPUB \ud3f4\ub354 \uc5f4\uae30");
        btnOpenFolder.addListener(13, e -> {
            try {
                this.openEpubFolder();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        Composite browserArea = new Composite(parent, 0);
        browserArea.setLayoutData((Object)new GridData(4, 4, true, true));
        browserArea.setLayout((Layout)new FillLayout());
        this.browser = new Browser(browserArea, 0);
        this.browser.setUrl(NLD_EAC_URL);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                AccessibilityNldPart.this.injectAutoFillScript();
            }
        });
        this.currentEpub = Paths.get(EpubBuildUtil.getProjectPublishFolder(), new String[0]);
        if (this.currentEpub != null) {
            this.lblEpubPath.setText("EPUB \ud30c\uc77c: " + this.currentEpub.toString());
        } else {
            this.lblEpubPath.setText("EPUB \ud30c\uc77c: (\ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uba3c\uc800 \uc804\uc790\ucc45\uc744 \uc0dd\uc131\ud574\uc8fc\uc138\uc694.)");
        }
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void onFocus() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }

    private void openEpubFolder() throws IOException {
        try {
            File dir;
            if (this.currentEpub != null && (dir = this.currentEpub.toFile()).exists()) {
                Desktop.getDesktop().open(dir);
                return;
            }
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
            String projectName = prefs.get("ebook_project_name", DEFAULT_ORG_NAME);
            String publishPath = prefs.get("ebook_publish_folder", "C:\\1004.GomsBook\\02.Publish");
            String publishFullPath = publishPath + "/" + projectName;
            Path publishDir = Paths.get(publishFullPath, new String[0]);
            File dir2 = publishDir.toFile();
            if (dir2.exists()) {
                Desktop.getDesktop().open(dir2);
            } else {
                MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                mb.setText("\ud3f4\ub354 \uc5c6\uc74c");
                mb.setMessage("EPUB \ucd9c\ub825 \ud3f4\ub354\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n\uacbd\ub85c: " + publishDir.toString());
                mb.open();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void injectAutoFillScript() {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        String orgName = AccessibilityNldPart.jsEscape(DEFAULT_ORG_NAME);
        String email = AccessibilityNldPart.jsEscape(DEFAULT_EMAIL);
        String password = AccessibilityNldPart.jsEscape(DEFAULT_PASSWORD);
        StringBuilder sb = new StringBuilder();
        sb.append("try {");
        sb.append("var org = document.querySelector('input[name=\"verifyOrg\"]');");
        sb.append("if (org) org.value = '").append(orgName).append("';");
        sb.append("var email = document.querySelector('input[name=\"verifyEmail\"]');");
        sb.append("if (email) email.value = '").append(email).append("';");
        sb.append("var pw = document.querySelector('input[name=\"verifyTempPwd\"]');");
        sb.append("if (pw) pw.value = '").append(password).append("';");
        sb.append("} catch(e) { console && console.log(e); }");
        this.browser.execute(sb.toString());
    }

    private static String jsEscape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("'", "\\'").replace("\r", "\\r").replace("\n", "\\n");
    }
}

