/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kr.co.goms.epub.ai.OllamaCaller;
import kr.co.goms.epub.ai.XhtmlMemoryService;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class AiHtmlChatViewPart {
    public static final String ID = "kr.co.goms.epub.solution.parts.AiHtmlChatViewPart";
    @Inject
    IEventBroker eventBroker;
    @Inject
    XhtmlMemoryService memory;
    private Browser browser;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final HttpClient http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final String OLLAMA_GENERATE_URL = "http://localhost:11434/api/generate";
    private volatile boolean cancelRequested = false;

    @PostConstruct
    public void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browser = new Browser(parent, 0);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"epubtest03"), (IPath)new Path("resources/html/chat/viewer.html"), null);
        if (url == null) {
            throw new RuntimeException("viewer.html\uc744 \ubc88\ub4e4\uc5d0\uc11c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uacbd\ub85c\ub97c \ud655\uc778\ud558\uc138\uc694: resources/html/chat/viewer.html");
        }
        System.out.println("url : " + String.valueOf(url));
        this.memory.initIfNeeded();
        try {
            this.browser.setUrl(FileLocator.toFileURL((URL)url).toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new BrowserFunction(this.browser, "requestButtons"){

            public Object function(Object[] args) {
                String query = args != null && args.length > 0 ? Objects.toString(args[0], "") : "";
                List<ActionItem> items = AiHtmlChatViewPart.this.suggestActions(query);
                return AiHtmlChatViewPart.toJson(items);
            }
        };
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                new BrowserFunction(AiHtmlChatViewPart.this.browser, "sendToOllama"){

                    public Object function(Object[] args) {
                        String msg = args != null && args.length > 0 ? String.valueOf(args[0]) : "";
                        AiHtmlChatViewPart.this.handleUserInput(msg);
                        return "OK";
                    }
                };
                new BrowserFunction(AiHtmlChatViewPart.this.browser, "sendToOllamaWithTemplate"){

                    public Object function(Object[] args) {
                        String msg = args != null && args.length > 0 ? String.valueOf(args[0]) : "";
                        String tpl = args != null && args.length > 1 ? String.valueOf(args[1]) : "";
                        AiHtmlChatViewPart.this.handleUserInputWithTemplate_generate(msg, tpl);
                        return "OK";
                    }
                };
                try {
                    Boolean res = AiHtmlChatViewPart.this.browser.execute("(function(){try{window.javaConnector=window.javaConnector||{};window.javaConnector.sendToOllama=function(m){return window.sendToOllama(m)};window.javaConnector.sendToOllamaWithTemplate=function(m,t){return window.sendToOllamaWithTemplate(m,t)};window.javaConnector.requestButtons=function(q){return window.requestButtons(q)};window.javaConnector.requestButtonsEx=function(p){return window.requestButtonsEx(p)};window.javaConnector.runAction=function(j){return window.runAction(j)};if(typeof bridgeStatus==='function'){bridgeStatus('OK');}if(typeof onBridgeReady==='function'){onBridgeReady();}}catch(e){if(typeof bridgeStatus==='function'){bridgeStatus('ERR:'+e.message);} }})();");
                    System.out.println("bridge injected11 : " + String.valueOf(res));
                    Object ok = AiHtmlChatViewPart.this.browser.evaluate("(function(){var b=window.javaConnector;if(!b) return 'NO:javaConnector';if(typeof b.requestButtonsEx!=='function') return 'NO:requestButtonsEx';if(typeof b.runAction!=='function') return 'NO:runAction';return (window.__bridge_ok===true)?'OK':(window.__bridge_ok||'UNKNOWN');})()");
                    System.out.println("bridge check: " + String.valueOf(ok));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        new BrowserFunction(this.browser, "requestButtonsEx"){

            public Object function(Object[] args) {
                try {
                    Map<String, Object> m = Json.minParse(args != null && args.length > 0 ? Objects.toString(args[0], "{}") : "{}");
                    String query = Objects.toString(m.get("query"), "");
                    ArrayList<String> history = new ArrayList<String>();
                    Object h = m.get("history");
                    if (h instanceof List) {
                        for (Object o : (List)h) {
                            history.add(Objects.toString(o, ""));
                        }
                    }
                    return AiHtmlChatViewPart.toJson(AiHtmlChatViewPart.this.suggestActionsWeighted(query, history));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "[]";
                }
            }
        };
        new BrowserFunction(this.browser, "runAction"){

            public Object function(Object[] args) {
                String json = args != null && args.length > 0 ? Objects.toString(args[0], "") : "";
                try {
                    ActionItem item = ActionItem.fromJson(json);
                    return AiHtmlChatViewPart.this.runActionWithContext(item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "\uc2e4\ud589 \uc2e4\ud328: " + e.getClass().getSimpleName() + ": " + e.getMessage();
                }
            }
        };
        new BrowserFunction(this.browser, "javaLog"){

            public Object function(Object[] args) {
                System.out.println("[JS] " + (args != null && args.length > 0 ? String.valueOf(args[0]) : ""));
                return null;
            }
        };
        new BrowserFunction(this.browser, "bridgeStatus"){

            public Object function(Object[] args) {
                String m = args != null && args.length > 0 ? String.valueOf(args[0]) : "(no message)";
                System.out.println("[bridge] " + m);
                return null;
            }
        };
    }

    public void handleUserInputWithTemplate_generate(String userMsg, String template) {
        this.cancelRequested = false;
        this.executor.submit(() -> {
            String prompt = this.buildPrompt(userMsg, template);
            LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
            body.put("model", "llama3.2");
            body.put("prompt", prompt);
            body.put("stream", true);
            HashMap<String, Double> opts = new HashMap<String, Double>();
            opts.put("temperature", 0.7);
            body.put("options", opts);
            HttpRequest req = HttpRequest.newBuilder(URI.create("http://localhost:11434/api/generate")).timeout(Duration.ofSeconds(60L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(gson.toJson(body), StandardCharsets.UTF_8)).build();
            try {
                this.runOnUI(() -> {
                    boolean bl = this.browser.execute("if (typeof beginAssistantMessage==='function'){beginAssistantMessage();}else{addMessage('assistant','');}");
                });
                HttpResponse<InputStream> resp = this.http.send(req, HttpResponse.BodyHandlers.ofInputStream());
                if (resp.statusCode() / 100 != 2) {
                    String err = new String(resp.body().readAllBytes(), StandardCharsets.UTF_8);
                    this.runOnUI(() -> {
                        boolean bl = this.browser.execute("addMessage('assistant', " + AiHtmlChatViewPart.jsString("Ollama \uc624\ub958: HTTP " + resp.statusCode() + "\n" + err) + ");");
                    });
                    return;
                }
                Throwable err = null;
                Object var9_13 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(resp.body(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null && !this.cancelRequested) {
                        String chunk;
                        if (line.isBlank()) continue;
                        JsonObject obj = JsonParser.parseString((String)line).getAsJsonObject();
                        String string3 = chunk = obj.has("response") ? obj.get("response").getAsString() : null;
                        if (chunk != null && !chunk.isEmpty()) {
                            String piece = chunk;
                            this.runOnUI(() -> {
                                boolean bl = this.browser.execute("if (typeof appendAssistantChunk==='function'){appendAssistantChunk(" + AiHtmlChatViewPart.jsString(piece) + ");}else{var el=document.querySelector('.msg.assistant:last-child');if(!el){addMessage('assistant',''); el=document.querySelector('.msg.assistant:last-child');}el.innerText = el.innerText + " + AiHtmlChatViewPart.jsString(piece) + ";}");
                            });
                        }
                        if (!obj.has("done") || !obj.get("done").getAsBoolean()) continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (err == null) {
                        err = throwable;
                    } else if (err != throwable) {
                        err.addSuppressed(throwable);
                    }
                    throw err;
                }
                this.runOnUI(() -> {
                    boolean bl = this.browser.execute("if (typeof endAssistantMessage==='function'){endAssistantMessage();}");
                });
            }
            catch (Exception e) {
                String em = e.getMessage() == null ? e.toString() : e.getMessage();
                this.runOnUI(() -> {
                    boolean bl = this.browser.execute("addMessage('assistant', " + AiHtmlChatViewPart.jsString("\uc5d0\ub7ec: " + em) + ");");
                });
            }
        });
    }

    private void handleUserInput(String userInput) {
        new Thread(() -> {
            String response = OllamaCaller.sendPrompt(userInput);
            Display.getDefault().asyncExec(() -> this.browser.evaluate("showAIResponse(" + this.toJSString(response) + ");"));
        }).start();
    }

    public void handleUserInputWithTemplate(String msg, String template) {
        System.out.println("handleUserInputWithTemplate() > \uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694");
        this.cancelRequested = false;
        this.executor.submit(() -> {
            String prompt = this.buildPrompt(msg, template);
            System.out.println("executor() > \uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694");
            String reqJson = "{\n  \"model\": \"llama3.2\",\n  \"prompt\": %s,\n  \"stream\": true,\n  \"options\": { \"temperature\": 0.8 }\n}\n".formatted(AiHtmlChatViewPart.toJsonString(prompt));
            HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:11434/api/generate")).timeout(Duration.ofSeconds(60L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(reqJson)).build();
            try {
                this.runOnUI(() -> this.browser.execute("if (typeof beginAssistantMessage==='function'){beginAssistantMessage();}else{addMessage('assistant','');}"));
                HttpResponse<InputStream> resp = this.http.send(request, HttpResponse.BodyHandlers.ofInputStream());
                Throwable throwable = null;
                Object var8_11 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(resp.body(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null && !this.cancelRequested) {
                        if (line.isBlank()) continue;
                        String raw = AiHtmlChatViewPart.extractField(line, "response");
                        String chunk = AiHtmlChatViewPart.decodeJsonEscapes(raw);
                        if (chunk != null && !chunk.isEmpty()) {
                            String piece = chunk;
                            this.runOnUI(() -> this.browser.execute("if (typeof appendAssistantChunk==='function'){appendAssistantChunk(" + AiHtmlChatViewPart.jsString(piece) + ");}else{var el=document.querySelector('.msg.assistant:last-child');if(!el){addMessage('assistant',''); el=document.querySelector('.msg.assistant:last-child');}el.innerText = el.innerText + " + AiHtmlChatViewPart.jsString(piece) + ";}"));
                        }
                        if (!line.contains("\"done\":true")) continue;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.runOnUI(() -> this.browser.execute("if (typeof endAssistantMessage==='function'){endAssistantMessage();}"));
            }
            catch (Exception e) {
                e.printStackTrace();
                String msgErr = e.getMessage() == null ? e.toString() : e.getMessage();
                this.runOnUI(() -> {
                    boolean bl = this.browser.execute("addMessage('assistant', " + AiHtmlChatViewPart.jsString("\uc5d0\ub7ec: " + msgErr) + ");");
                });
            }
        });
    }

    private void runOnUI(Runnable r) {
        Display.getDefault().asyncExec(() -> {
            if (this.browser != null && !this.browser.isDisposed()) {
                r.run();
            }
        });
    }

    private String buildPrompt(String userMsg, String template) {
        System.out.println("buildPrompt() > \uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694");
        switch (template == null ? "" : template.toLowerCase()) {
            case "classic": {
                return "[STYLE: classic XHTML]\n- \uac04\uacb0\ud55c \ubb38\uc7a5, \uae30\ubcf8 HTML\ub9cc \uc0ac\uc6a9.\n- <p>, <strong>, <em> \uc815\ub3c4\ub9cc.\nUSER:\n%s\n".formatted(userMsg);
            }
            case "modern": {
                return "[STYLE: modern XHTML]\n- \uc720\ub824\ud55c \ud1a4, <section><h2><p> \uad6c\uc870 \uad8c\uc7a5.\n- \uc811\uadfc\uc131 alt/aria \uc900\uc218.\nUSER:\n%s\n".formatted(userMsg);
            }
        }
        return "USER:\n" + userMsg;
    }

    private static String decodeJsonEscapes(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < s.length()) {
                char n = s.charAt(i++);
                switch (n) {
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    case 'u': {
                        if (i + 4 <= s.length()) {
                            String hex = s.substring(i, i + 4);
                            try {
                                out.append((char)Integer.parseInt(hex, 16));
                            }
                            catch (Exception exception) {
                                out.append("\\u").append(hex);
                            }
                            i += 4;
                            break;
                        }
                        out.append("\\u");
                        break;
                    }
                    default: {
                        out.append(n);
                        break;
                    }
                }
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static String jsString(String s) {
        if (s == null) {
            return "''";
        }
        String esc = s.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        return "'" + esc + "'";
    }

    private static String toJsonString(String s) {
        if (s == null) {
            return "\"\"";
        }
        String esc = s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        return "\"" + esc + "\"";
    }

    private String toJSString(String s) {
        return "\"" + s.replace("\"", "\\\"").replace("\n", "\\n") + "\"";
    }

    private static String extractField(String jsonLine, String key) {
        String needle = "\"" + key + "\":\"";
        int i = jsonLine.indexOf(needle);
        if (i < 0) {
            return null;
        }
        int start = i + needle.length();
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        int p = start;
        while (p < jsonLine.length()) {
            char c = jsonLine.charAt(p);
            if (escape) {
                switch (c) {
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                escape = false;
            } else if (c == '\\') {
                escape = true;
            } else {
                if (c == '\"') break;
                sb.append(c);
            }
            ++p;
        }
        return sb.toString();
    }

    @PreDestroy
    public void dispose() {
        this.cancelRequested = true;
        this.executor.shutdownNow();
        try {
            if (this.memory != null) {
                this.memory.close();
            }
        }
        catch (Exception exception) {}
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.dispose();
        }
    }

    @Focus
    public void setFocus() {
        this.browser.setFocus();
    }

    private List<ActionItem> suggestActions(String query) {
        String q = query.toLowerCase(Locale.ROOT);
        ArrayList<ActionItem> list = new ArrayList<ActionItem>();
        if (q.contains("\uc774\ubbf8\uc9c0\ubaa9\ucc28") || q.contains("lot")) {
            list.add(new ActionItem("gen_image_toc", "\uc774\ubbf8\uc9c0\ubaa9\ucc28 \uc0dd\uc131"));
        }
        if (q.contains("\ud45c \ubaa9\ucc28") || q.contains("table")) {
            list.add(new ActionItem("gen_table_toc", "\ud45c \ubaa9\ucc28 \uc0dd\uc131"));
        }
        if (q.contains("\ucf54\ub4dc \uc815\ub9ac") || q.contains("clean")) {
            list.add(new ActionItem("code_clean", "\ucf54\ub4dc \uc815\ub9ac"));
        }
        list.add(new ActionItem("gen_ai_xhtml", "AI\ub85c XHTML \uc0dd\uc131(\ucee8\ud14d\uc2a4\ud2b8 \ubc18\uc601)"));
        if (list.isEmpty()) {
            list.add(new ActionItem("gen_image_toc", "\uc774\ubbf8\uc9c0\ubaa9\ucc28 \uc0dd\uc131"));
            list.add(new ActionItem("gen_table_toc", "\ud45c \ubaa9\ucc28 \uc0dd\uc131"));
            list.add(new ActionItem("code_clean", "\ucf54\ub4dc \uc815\ub9ac"));
            list.add(new ActionItem("gen_ai_xhtml", "AI\ub85c XHTML \uc0dd\uc131(\ucee8\ud14d\uc2a4\ud2b8 \ubc18\uc601)"));
        }
        return list;
    }

    private String runActionWithContext(ActionItem item) throws Exception {
        String userQuery = item.query != null && !item.query.isBlank() ? item.query : item.title;
        List<XhtmlMemoryService.Result> ctx = this.memory.searchSimilarFts(userQuery, 200, 5);
        StringBuilder context = new StringBuilder();
        context.append("\ub108\ub294 XHTML \uc804\ubb38\uac00\ub2e4. \uc544\ub798\ub294 \uacfc\uac70 \ud504\ub85c\uc81d\ud2b8\uc5d0\uc11c \uc0ac\uc6a9\ud55c XHTML \uc608\uc2dc\ub4e4\uc774\ub2e4.\n").append("\uc774 \uc2a4\ud0c0\uc77c\uc744 \ucd5c\ub300\ud55c \uc720\uc9c0\ud558\uace0, \uc720\ud6a8\ud55c XHTML 1.1/EPUB3 \uce5c\ud654 \ucf54\ub4dc\ub97c \ub9cc\ub4e4\uc5b4\ub77c.\n\n");
        int i = 0;
        while (i < ctx.size()) {
            XhtmlMemoryService.Result r = ctx.get(i);
            context.append("[\uc608\uc2dc ").append(i + 1).append("] (").append(r.filePath).append("#").append(r.anchor == null ? "" : r.anchor).append(")\n").append(r.text).append("\n\n");
            ++i;
        }
        switch (item.id) {
            case "gen_image_toc": {
                return Actions.generateImageTOC();
            }
            case "gen_table_toc": {
                return Actions.generateTableTOC();
            }
            case "code_clean": {
                return Actions.cleanCurrentXhtml();
            }
            case "gen_ai_xhtml": {
                String prompt = String.valueOf(context) + "\uc694\uccad: \"" + userQuery + "\"\n\n\ubc18\ud658 \ud615\uc2dd: \uc644\uc804\ud55c XHTML \ubb38\uc11c\ub85c, <html>~</html> \uc804\uccb4\ub97c \ucd9c\ub825.1) \uc608\uc2dc\uc758 \ud14d\uc2a4\ud2b8/\ub9c1\ud06c\ub97c \ubcf5\uc0ac\ud558\uc9c0 \ub9d0\uace0, \uc2a4\ud0c0\uc77c/\uad6c\uc870\ub9cc \ubaa8\uc0ac\ud558\ub77c.\n2) \uc720\ud6a8\ud55c XHTML 1.1\ub85c\ub9cc \ucd9c\ub825(\ub2e8\uc77c \ub8e8\ud2b8, \uc62c\ubc14\ub978 \ub124\uc784\uc2a4\ud398\uc774\uc2a4, \ub2eb\ud798 \ud0dc\uadf8 \ud544\uc218).\n3) EPUB3 \ud638\ud658: nav/alt/\uc5b8\uc5b4 \uc18d\uc131 \ub4f1 \uc811\uadfc\uc131 \uc694\uc18c \uc900\uc218.\n4) \ucf54\ub4dc\ub9cc \ucd9c\ub825(\uc124\uba85 \uae08\uc9c0).\n";
                String xhtml = OllamaTextClient.generate("llama3.2", prompt, 1024);
                return Actions.saveAndPreviewGeneratedXhtml(xhtml, "generated_ai.xhtml", this::previewRefresh);
            }
        }
        return "\uc54c \uc218 \uc5c6\ub294 \uc561\uc158: " + item.id;
    }

    private String resolveBundleResource(String path) {
        try {
            Bundle b = FrameworkUtil.getBundle(this.getClass());
            URL u = b.getEntry(path);
            URL fileURL = FileLocator.toFileURL((URL)u);
            return fileURL.toURI().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("viewer.html \uacbd\ub85c \ud655\uc778 \ud544\uc694: " + e.getMessage(), e);
        }
    }

    private static String toJson(List<ActionItem> items) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < items.size()) {
            ActionItem a = items.get(i);
            sb.append("{\"id\":\"").append(AiHtmlChatViewPart.esc(a.id)).append("\",\"title\":\"").append(AiHtmlChatViewPart.esc(a.title)).append("\"}");
            if (i < items.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.append("]").toString();
    }

    private static String esc(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private List<ActionItem> suggestActionsWeighted(String query, List<String> history) {
        List<ActionItem> base = this.suggestActions(query);
        Set<String> qTokens = AiHtmlChatViewPart.tokens(query);
        HashMap<String, Integer> histTf = new HashMap<String, Integer>();
        int i = 0;
        while (i < history.size()) {
            String s = history.get(i);
            int weight = Math.max(1, 20 - i);
            for (String t : AiHtmlChatViewPart.tokens(s)) {
                histTf.merge(t, weight, Integer::sum);
            }
            ++i;
        }
        class Scored {
            ActionItem a;
            double score;

            Scored(ActionItem a, double s) {
                this.a = a;
                this.score = s;
            }
        }
        ArrayList<Scored> scored = new ArrayList<Scored>();
        for (ActionItem a : base) {
            double s = 0.0;
            if (AiHtmlChatViewPart.containsAny(qTokens, Set.of("\uc774\ubbf8\uc9c0", "\uc774\ubbf8\uc9c0\ubaa9\ucc28", "lot", "image", "img")) && a.id.equals("gen_image_toc")) {
                s += 5.0;
            }
            if (AiHtmlChatViewPart.containsAny(qTokens, Set.of("\ud45c", "\ud45c\ubaa9\ucc28", "table", "toc")) && a.id.equals("gen_table_toc")) {
                s += 5.0;
            }
            if (AiHtmlChatViewPart.containsAny(qTokens, Set.of("\ucf54\ub4dc", "\uc815\ub9ac", "clean", "tidy", "htmlcleaner")) && a.id.equals("code_clean")) {
                s += 5.0;
            }
            if (AiHtmlChatViewPart.containsAny(qTokens, Set.of("ai", "\uc0dd\uc131", "xhtml", "\ud15c\ud50c\ub9bf", "\uc790\ub3d9"))) {
                s += (double)(a.id.equals("gen_ai_xhtml") ? 4 : 0);
            }
            double histBonus = 0.0;
            for (String t : qTokens) {
                histBonus += (double)histTf.getOrDefault(t, 0).intValue();
            }
            scored.add(new Scored(a, s += Math.min(20.0, histBonus * 0.1)));
        }
        scored.sort((x, y) -> Double.compare(y.score, x.score));
        LinkedHashMap<String, ActionItem> dedup = new LinkedHashMap<String, ActionItem>();
        for (Scored sc : scored) {
            dedup.putIfAbsent(sc.a.id, sc.a);
        }
        if (dedup.isEmpty()) {
            return Arrays.asList(new ActionItem("gen_image_toc", "\uc774\ubbf8\uc9c0\ubaa9\ucc28 \uc0dd\uc131"), new ActionItem("gen_table_toc", "\ud45c \ubaa9\ucc28 \uc0dd\uc131"), new ActionItem("code_clean", "\ucf54\ub4dc \uc815\ub9ac"), new ActionItem("gen_ai_xhtml", "AI\ub85c XHTML \uc0dd\uc131(\ucee8\ud14d\uc2a4\ud2b8 \ubc18\uc601)"));
        }
        return new ArrayList<ActionItem>(dedup.values());
    }

    private void previewRefresh(File out) {
        Map<String, String> data = Map.of("path", out.getAbsolutePath());
        Display.getDefault().asyncExec(() -> {
            if (this.eventBroker != null) {
                this.eventBroker.post("gomsbook/preview/refresh", (Object)data);
            } else {
                System.err.println("[WARN] eventBroker is null; PREVIEW_REFRESH not posted.");
            }
        });
    }

    private static Set<String> tokens(String s) {
        if (s == null) {
            return Set.of();
        }
        String norm = s.toLowerCase(Locale.ROOT).replaceAll("[^\\p{L}\\p{N}\\s]", " ").trim();
        if (norm.isEmpty()) {
            return Set.of();
        }
        return new HashSet<String>(Arrays.asList(norm.split("\\s+")));
    }

    private static boolean containsAny(Set<String> a, Set<String> b) {
        for (String x : b) {
            if (!a.contains(x)) continue;
            return true;
        }
        return false;
    }

    static class ActionItem {
        String id;
        String title;
        String query;

        ActionItem() {
        }

        ActionItem(String id, String title) {
            this.id = id;
            this.title = title;
        }

        static ActionItem fromJson(String j) {
            try {
                Gson g = new Gson();
                ActionItem a = (ActionItem)g.fromJson(j, ActionItem.class);
                if (a.id == null) {
                    a.id = "";
                }
                if (a.title == null) {
                    a.title = "";
                }
                if (a.query == null) {
                    a.query = "";
                }
                return a;
            }
            catch (Exception e) {
                throw new RuntimeException("JSON parse \uc2e4\ud328: " + e.getMessage(), e);
            }
        }
    }

    static class Actions {
        Actions() {
        }

        static String generateImageTOC() {
            return "\uc774\ubbf8\uc9c0\ubaa9\ucc28 \uc0dd\uc131 \uc644\ub8cc";
        }

        static String generateTableTOC() {
            return "\ud45c \ubaa9\ucc28 \uc0dd\uc131 \uc644\ub8cc";
        }

        static String cleanCurrentXhtml() {
            return "\ucf54\ub4dc \uc815\ub9ac \uc644\ub8cc";
        }

        static String saveAndPreviewGeneratedXhtml(String xhtml, String fileName, Consumer<File> onSaved) {
            try {
                String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
                File targetTextDir = new File(textPath);
                File out = new File(targetTextDir, fileName);
                Files.writeString(out.toPath(), (CharSequence)xhtml, StandardCharsets.UTF_8, new OpenOption[0]);
                if (onSaved != null) {
                    onSaved.accept(out);
                }
                return "AI \uc0dd\uc131 XHTML \uc800\uc7a5: " + fileName;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "\uc800\uc7a5 \uc2e4\ud328: " + e.getMessage();
            }
        }

        private static String idFor(String file) {
            return file.replaceAll("[^A-Za-z0-9]", "_");
        }
    }

    static class Json {
        Json() {
        }

        static Map<String, Object> minParse(String j) {
            try {
                Type t = new TypeToken<Map<String, Object>>(){}.getType();
                return (Map)new Gson().fromJson(j, t);
            }
            catch (Exception e) {
                throw new RuntimeException("JSON parse \uc2e4\ud328: " + e.getMessage(), e);
            }
        }
    }

    static class OllamaTextClient {
        private static final HttpClient HTTP = HttpClient.newHttpClient();
        private static final String OLLAMA = "http://localhost:11434";

        OllamaTextClient() {
        }

        static String generate(String model, String prompt, int numPredict) throws Exception {
            String body = "  {\n    \"model\": \"%s\",\n    \"prompt\": %s,\n    \"stream\": false,\n    \"options\": {\"num_predict\": %d}\n  }\n".formatted(model, OllamaTextClient.quote(prompt), numPredict);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/generate")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
            HttpResponse<String> res = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() / 100 != 2) {
                throw new RuntimeException("Ollama text gen HTTP " + res.statusCode() + " : " + res.body());
            }
            JsonObject obj = JsonParser.parseString((String)res.body()).getAsJsonObject();
            return obj.has("response") ? obj.get("response").getAsString() : "";
        }

        private static String quote(String s) {
            return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n") + "\"";
        }
    }

    static class Workspace {
        Workspace() {
        }

        static File currentTextDir() {
            return new File(EpubPreferenceManager.getInstance().getProjectPath(), "OEBPS/Text");
        }
    }
}

