/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kr.co.goms.epub.solution.service.GoogleAiTtsService;
import kr.co.goms.epub.solution.tts.GoogleAiTtsVoiceOptions;
import kr.co.goms.epub.solution.tts.TTSMp3Player;
import kr.co.goms.epub.solution.utils.LogViewUtil;
import kr.co.goms.epub.solution.utils.Mp3Util;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EpubAiGoogleTTSViewPart {
    private Combo comboVoice;
    private StyledText textArea;
    private TableViewer mp3Table;
    private Button batchButton;
    private Button fileButton;
    private final List<Mp3Item> mp3Items = new ArrayList<Mp3Item>();
    private TTSMp3Player player;
    private Path outputDir;
    private final List<TableEditor> rowEditors = new ArrayList<TableEditor>();
    private final List<Button> rowButtons = new ArrayList<Button>();
    private ProgressBar progressBar;
    private Label progressLabel;
    private ScheduledExecutorService progressExec;
    private ScheduledFuture<?> progressTask;
    private volatile long playStartMs = 0L;
    private volatile long playTotalMs = 0L;
    private volatile File playingFile = null;
    private Menu tableContextMenu;
    private Shell shell;
    private Map<String, Image> thumbnailCache = new HashMap<String, Image>();
    private ExecutorService imagePool = Executors.newFixedThreadPool(3);
    private final AtomicInteger seqCounter = new AtomicInteger(1);
    private Text txtApiKey;

    @PostConstruct
    public void createControls(Composite parent) {
        this.shell = parent.getShell();
        parent.setLayout((Layout)new GridLayout(1, false));
        new Label(parent, 0).setText("Google API Key:");
        this.txtApiKey = new Text(parent, 2048);
        this.txtApiKey.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtApiKey.setText("AIzaSyCxPFn5ei4McCoSAKG1mTUoZZFYuXOkgjs");
        new Label(parent, 0).setText("TTS Voice:");
        this.comboVoice = new Combo(parent, 12);
        this.comboVoice.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GoogleAiTtsVoiceOptions.initVoiceCombo(this.comboVoice);
        final Composite topBar = new Composite(parent, 0);
        topBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        topBar.setLayout((Layout)new GridLayout(2, false));
        this.fileButton = new Button(topBar, 8);
        this.fileButton.setText("\ud30c\uc77c \uc5f4\uae30 (*.txt)...");
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpubAiGoogleTTSViewPart.this.openTextFile(topBar.getShell());
            }
        });
        Label tip = new Label(topBar, 0);
        tip.setText("\ud55c \uc904\ub9c8\ub2e4 \ud55c \ud56d\ubaa9\uc73c\ub85c \ucc98\ub9ac\ub429\ub2c8\ub2e4.");
        this.textArea = new StyledText(parent, 2816);
        this.textArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gdTextArea = new GridData(4, 4, true, true);
        gdTextArea.heightHint = 80;
        gdTextArea.minimumHeight = 60;
        this.textArea.setLayoutData((Object)gdTextArea);
        this.textArea.setAlwaysShowScrollBars(false);
        Composite inputRow = new Composite(parent, 0);
        inputRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        inputRow.setLayout((Layout)new GridLayout(2, false));
        Group mp3Group = new Group(parent, 0);
        mp3Group.setText("MP3 \uacb0\uacfc");
        mp3Group.setLayoutData((Object)new GridData(4, 4, true, true));
        mp3Group.setLayout((Layout)new GridLayout(1, false));
        this.mp3Table = new TableViewer((Composite)mp3Group, 67586);
        Table table = this.mp3Table.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn col0 = new TableViewerColumn(this.mp3Table, 0);
        col0.getColumn().setText("\uc21c\ubc88");
        col0.getColumn().setWidth(50);
        col0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return String.format("%03d", ((Mp3Item)e).seq);
            }
        });
        TableViewerColumn col1 = new TableViewerColumn(this.mp3Table, 0);
        col1.getColumn().setText("\uc6d0\ubb38");
        col1.getColumn().setWidth(420);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Mp3Item)e).text;
            }
        });
        TableViewerColumn col2 = new TableViewerColumn(this.mp3Table, 0);
        col2.getColumn().setText("MP3 \ud30c\uc77c");
        col2.getColumn().setWidth(320);
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Mp3Item)e).file.getName();
            }
        });
        this.mp3Table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.mp3Table.setInput(this.mp3Items);
        Composite bottomBar = new Composite(parent, 0);
        bottomBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bottomBar.setLayout((Layout)new GridLayout(2, false));
        this.batchButton = new Button(bottomBar, 8);
        this.batchButton.setText("\uc77c\uad04 \ubcc0\ud658");
        this.batchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewUtil.logger("\uc74c\uc131 \ud30c\uc77c \uc0dd\uc131 \uc2dc\uc791");
                String apiKey = EpubAiGoogleTTSViewPart.this.txtApiKey.getText().trim();
                String text = EpubAiGoogleTTSViewPart.this.textArea.getText().trim();
                EpubAiGoogleTTSViewPart.this.synthGoogleAi(EpubAiGoogleTTSViewPart.this.shell, apiKey, text);
            }
        });
        TableColumn colDown = new TableColumn(table, 0x1000000);
        colDown.setText("\ub2e4\uc6b4\ub85c\ub4dc");
        colDown.setWidth(100);
        Composite progressRow = new Composite(parent, 0);
        progressRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        progressRow.setLayout((Layout)new GridLayout(2, false));
        this.progressLabel = new Label(progressRow, 0);
        this.progressLabel.setText("\ub300\uae30 \uc911");
        this.progressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressBar = new ProgressBar(progressRow, 0);
        GridData gdPb = new GridData(4, 0x1000000, false, false);
        gdPb.widthHint = 240;
        this.progressBar.setLayoutData((Object)gdPb);
        this.progressExec = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "tts-progress");
            t.setDaemon(true);
            return t;
        });
        this.player = new TTSMp3Player();
        this.outputDir = this.makeOutputDir();
        this.createContextMenuForTable();
    }

    private void createContextMenuForTable() {
        Table table = this.mp3Table.getTable();
        this.tableContextMenu = new Menu((Control)table);
        table.setMenu(this.tableContextMenu);
        Runnable ensureSelection = () -> {
            if (table.getSelectionCount() == 0 && table.getItemCount() > 0) {
                table.setSelection(0);
            }
        };
        MenuItem miPlayToggle = new MenuItem(this.tableContextMenu, 8);
        miPlayToggle.setText("\uc7ac\uc0dd/\uc815\uc9c0");
        miPlayToggle.addListener(13, e -> {
            TableItem it;
            ensureSelection.run();
            TableItem tableItem = it = table.getSelectionIndex() >= 0 ? table.getItem(table.getSelectionIndex()) : null;
            if (it == null) {
                return;
            }
            Mp3Item data = (Mp3Item)it.getData();
            if (data == null) {
                return;
            }
            if (this.player.isPlayingThis(data.file)) {
                this.stopPlay();
            } else {
                this.resetAllPlayButtonsToPlay();
                this.play(data.file);
            }
        });
        new MenuItem(this.tableContextMenu, 2);
        MenuItem miOpen = new MenuItem(this.tableContextMenu, 8);
        miOpen.setText("\ud30c\uc77c \uc5f4\uae30");
        miOpen.addListener(13, e -> {
            ensureSelection.run();
            TableItem[] tableItemArray = table.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem it = tableItemArray[n2];
                Mp3Item d = (Mp3Item)it.getData();
                if (d != null) {
                    this.openWithOS(d.file);
                }
                ++n2;
            }
        });
        MenuItem miReveal = new MenuItem(this.tableContextMenu, 8);
        miReveal.setText("\ud3f4\ub354\uc5d0\uc11c \ubcf4\uae30");
        miReveal.addListener(13, e -> {
            TableItem it;
            ensureSelection.run();
            TableItem tableItem = it = table.getSelectionIndex() >= 0 ? table.getItem(table.getSelectionIndex()) : null;
            if (it == null) {
                return;
            }
            Mp3Item d = (Mp3Item)it.getData();
            if (d == null) {
                return;
            }
            this.revealInOS(d.file.getParentFile());
        });
        MenuItem miCopyPath = new MenuItem(this.tableContextMenu, 8);
        miCopyPath.setText("\ud30c\uc77c \uacbd\ub85c \ubcf5\uc0ac");
        miCopyPath.addListener(13, e -> {
            ensureSelection.run();
            StringBuilder sb = new StringBuilder();
            TableItem[] tableItemArray = table.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem it = tableItemArray[n2];
                Mp3Item d = (Mp3Item)it.getData();
                if (d != null) {
                    sb.append(d.file.getAbsolutePath()).append(System.lineSeparator());
                }
                ++n2;
            }
            this.copyToClipboard(sb.toString());
        });
        new MenuItem(this.tableContextMenu, 2);
        MenuItem miBatchDownload = new MenuItem(this.tableContextMenu, 8);
        miBatchDownload.setText("\uc120\ud0dd \ud56d\ubaa9 \uc77c\uad04 \ub2e4\uc6b4\ub85c\ub4dc\u2026");
        miBatchDownload.addListener(13, e -> this.handleBatchDownload());
        MenuItem miDelete = new MenuItem(this.tableContextMenu, 8);
        miDelete.setText("\uc120\ud0dd \ud56d\ubaa9 \uc0ad\uc81c");
        miDelete.addListener(13, e -> this.handleDeleteSelected());
    }

    private void openWithOS(File f) {
        try {
            if (f.exists()) {
                Program.launch((String)f.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
    }

    private void revealInOS(File dir) {
        try {
            if (dir != null && dir.exists()) {
                Program.launch((String)dir.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
    }

    private void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getDefault());
        cb.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        cb.dispose();
    }

    private void handleBatchDownload() {
        Table table = this.mp3Table.getTable();
        if (table.getSelectionCount() == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\uc54c\ub9bc", (String)"\uba3c\uc800 \ud56d\ubaa9\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
            return;
        }
        DirectoryDialog dd = new DirectoryDialog(this.shell);
        dd.setMessage("\uc800\uc7a5\ud560 \ud3f4\ub354\ub97c \uc120\ud0dd\ud558\uc138\uc694.");
        String targetDir = dd.open();
        if (targetDir == null) {
            return;
        }
        int ok = 0;
        int fail = 0;
        TableItem[] tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            Mp3Item d = (Mp3Item)it.getData();
            if (d != null) {
                try {
                    Path dest = Path.of(targetDir, d.file.getName());
                    Files.copy(d.file.toPath(), dest, StandardCopyOption.REPLACE_EXISTING);
                    ++ok;
                }
                catch (Exception exception) {
                    ++fail;
                }
            }
            ++n2;
        }
        MessageDialog.openInformation((Shell)this.shell, (String)"\uc644\ub8cc", (String)("\ub2e4\uc6b4\ub85c\ub4dc \uc644\ub8cc\n\uc131\uacf5: " + ok + "  \uc2e4\ud328: " + fail + "\n\ud3f4\ub354: " + targetDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeleteSelected() {
        Table table = this.mp3Table.getTable();
        if (table.getSelectionCount() == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\uc54c\ub9bc", (String)"\uc0ad\uc81c\ud560 \ud56d\ubaa9\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
            return;
        }
        boolean yes = MessageDialog.openConfirm((Shell)this.shell, (String)"\uc0ad\uc81c \ud655\uc778", (String)"\uc120\ud0dd\ud55c MP3 \ud30c\uc77c\uc744 \uc2e4\uc81c \ub514\uc2a4\ud06c\uc5d0\uc11c \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?");
        if (!yes) {
            return;
        }
        int ok = 0;
        int fail = 0;
        ArrayList<Mp3Item> toRemove = new ArrayList<Mp3Item>();
        TableItem[] tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            Mp3Item d = (Mp3Item)it.getData();
            if (d != null) {
                try {
                    boolean deleted;
                    if (this.playingFile != null && d.file.equals(this.playingFile)) {
                        this.stopPlay();
                    }
                    if (deleted = d.file.delete()) {
                        ++ok;
                        toRemove.add(d);
                    } else {
                        ++fail;
                    }
                }
                catch (Exception exception) {
                    ++fail;
                }
            }
            ++n2;
        }
        List<Mp3Item> list = this.mp3Items;
        synchronized (list) {
            this.mp3Items.removeAll(toRemove);
        }
        this.refreshTable();
        MessageDialog.openInformation((Shell)this.shell, (String)"\uc0ad\uc81c \uacb0\uacfc", (String)("\uc0ad\uc81c \uc131\uacf5: " + ok + "  \uc2e4\ud328: " + fail));
    }

    private Path makeOutputDir() {
        try {
            String ts = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            Path dir = Path.of(System.getProperty("user.home"), "TtsOutputs", ts);
            Files.createDirectories(dir, new FileAttribute[0]);
            return dir;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void refreshTable() {
        this.mp3Table.refresh();
        this.installRowEditors();
    }

    private void openTextFile(Shell shell) {
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setFilterExtensions(new String[]{"*.txt"});
        dlg.setText("\ud14d\uc2a4\ud2b8 \ud30c\uc77c \uc120\ud0dd");
        String path = dlg.open();
        if (path == null) {
            return;
        }
        try {
            String content = Files.readString(Path.of(path, new String[0]), StandardCharsets.UTF_8);
            this.textArea.setText(content);
            MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)"*.txt \ub0b4\uc6a9\uc774 textarea\uc5d0 \ub85c\ub4dc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\uc904\ubc14\uafc8(\\n) \uae30\uc900\uc73c\ub85c \uc77c\uad04 \ubcc0\ud658\ub429\ub2c8\ub2e4.");
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("\ud30c\uc77c\uc744 \uc77d\ub294 \uc911 \uc624\ub958: " + ex.getMessage()));
        }
    }

    private void synthGoogleAi(Shell shell, String apiKey, String text) {
        if (apiKey.isEmpty()) {
            MessageDialog.openWarning((Shell)shell, (String)"\uc785\ub825 \uc624\ub958", (String)"Google API Key\ub97c \uc785\ub825\ud558\uc138\uc694.");
            return;
        }
        if (text.isEmpty()) {
            MessageDialog.openWarning((Shell)shell, (String)"\uc785\ub825 \uc624\ub958", (String)"\uc77d\uc744 \ud14d\uc2a4\ud2b8\ub97c \uc785\ub825\ud558\uc138\uc694.");
            return;
        }
        if (this.outputDir.getFileName().toString().isEmpty()) {
            MessageDialog.openWarning((Shell)shell, (String)"\uc785\ub825 \uc624\ub958", (String)"\ucd9c\ub825 WAV \uacbd\ub85c\ub97c \uc785\ub825\ud558\uc138\uc694.");
            return;
        }
        String selectedVoice = GoogleAiTtsVoiceOptions.getSelectedVoiceCode(this.comboVoice);
        int seq = this.seqCounter.getAndIncrement();
        Object fname = EpubAiGoogleTTSViewPart.buildFileName(seq, text);
        if (!((String)fname).toLowerCase().endsWith(".wav")) {
            fname = (String)fname + ".wav";
        }
        Path outputWav = this.outputDir.resolve((String)fname);
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(shell);
        try {
            dlg.run(true, false, monitor -> {
                try {
                    try {
                        monitor.beginTask("Google AI TTS \uc0dd\uc131 \uc911...", -1);
                        LogViewUtil.logger("\uc74c\uc131 \ud30c\uc77c \uc0dd\uc131 \uc2dc\uc791 : " + String.valueOf(outputWav) + ", Voice:" + selectedVoice);
                        GoogleAiTtsService tts = new GoogleAiTtsService(apiKey);
                        tts.synthesizeToWav(text, outputWav, selectedVoice);
                        Mp3Item item = new Mp3Item(seq, text, outputWav.toFile());
                        List<Mp3Item> list = this.mp3Items;
                        synchronized (list) {
                            this.mp3Items.add(item);
                        }
                        Display.getDefault().asyncExec(() -> {
                            this.refreshTable();
                            MessageDialog.openInformation((Shell)shell, (String)"TTS \uc644\ub8cc", (String)("\uc74c\uc131 \ud30c\uc77c \uc0dd\uc131 \uc644\ub8cc:\n" + String.valueOf(outputWav) + "\n\nVoice: " + selectedVoice));
                            LogViewUtil.logger("\uc74c\uc131 \ud30c\uc77c \uc0dd\uc131 \uc644\ub8cc:\n" + String.valueOf(outputWav) + ", Voice: " + selectedVoice);
                        });
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        LogViewUtil.logger("TTS \uc624\ub958 : " + ex.getMessage());
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"TTS \uc624\ub958", (String)ex.getMessage()));
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"TTS \uc624\ub958", (String)ex.getMessage());
        }
    }

    @Focus
    public void onFocus() {
        if (this.textArea != null && !this.textArea.isDisposed()) {
            this.textArea.setFocus();
        }
    }

    private void togglePlay(Mp3Item item) {
        if (this.player.isPlayingThis(item.file)) {
            this.stopPlay();
        } else {
            this.play(item.file);
        }
    }

    private void play(File file) {
        this.resetAllPlayButtonsToPlay();
        long totalMs = 0L;
        try {
            totalMs = Mp3Util.getDurationMillis(file);
        }
        catch (Exception exception) {}
        long total = totalMs > 0L ? totalMs : 0L;
        this.onPlayStarted(file, total);
        this.player.playAsync(file, () -> Display.getDefault().asyncExec(this::onPlayStopped));
    }

    private void stopPlay() {
        this.player.stop();
        this.onPlayStopped();
    }

    @Focus
    public void setFocus() {
        this.textArea.setFocus();
    }

    @PreDestroy
    public void preDestroy() {
        this.cleanupResources();
    }

    private void cleanupResources() {
        try {
            this.stopPlay();
        }
        catch (Exception exception) {}
        this.cancelProgressTask();
        if (this.progressExec != null) {
            this.progressExec.shutdownNow();
            this.progressExec = null;
        }
        this.disposeRowEditors();
    }

    private void disposeRowEditors() {
        for (Button b : this.rowButtons) {
            if (b == null || b.isDisposed()) continue;
            b.dispose();
        }
        for (TableEditor ed : this.rowEditors) {
            if (ed != null && !ed.getEditor().isDisposed()) {
                ed.getEditor().dispose();
            }
            if (ed == null) continue;
            ed.dispose();
        }
        this.rowButtons.clear();
        this.rowEditors.clear();
    }

    private void installRowEditors() {
        this.disposeRowEditors();
        Table table = this.mp3Table.getTable();
        int downColIndex = 3;
        int i = 0;
        while (i < table.getItemCount()) {
            TableItem item = table.getItem(i);
            Mp3Item data = (Mp3Item)item.getData();
            if (data != null) {
                Button downBtn = new Button((Composite)table, 8);
                downBtn.setText("\ub2e4\uc6b4\ub85c\ub4dc");
                downBtn.addListener(13, ev -> {
                    FileDialog fd = new FileDialog(this.shell, 8192);
                    fd.setOverwrite(true);
                    fd.setFilterExtensions(new String[]{"*.mp3"});
                    fd.setFileName(mp3Item.file.getName());
                    String target = fd.open();
                    if (target != null) {
                        try {
                            Files.copy(mp3Item.file.toPath(), Path.of(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            MessageDialog.openInformation((Shell)this.shell, (String)"\uc800\uc7a5 \uc644\ub8cc", (String)("\ud30c\uc77c\uc774 \uc800\uc7a5\ub418\uc5c8\uc5b4\uc694:\n" + target));
                        }
                        catch (Exception ex) {
                            MessageDialog.openError((Shell)this.shell, (String)"\uc624\ub958", (String)("\uc800\uc7a5 \uc2e4\ud328: " + ex.getMessage()));
                        }
                    }
                });
                TableEditor ed2 = new TableEditor(table);
                ed2.grabHorizontal = true;
                ed2.minimumWidth = 90;
                ed2.horizontalAlignment = 0x1000000;
                ed2.setEditor((Control)downBtn, item, downColIndex);
                this.rowEditors.add(ed2);
                this.rowButtons.add(downBtn);
            }
            ++i;
        }
    }

    private void resetAllPlayButtonsToPlay() {
        for (Button b : this.rowButtons) {
            if (b == null || b.isDisposed() || !"\uc815\uc9c0".equals(b.getText())) continue;
            b.setText("\uc7ac\uc0dd");
        }
    }

    private void onPlayStarted(File f, long totalMs) {
        this.playingFile = f;
        this.playTotalMs = totalMs;
        this.playStartMs = System.currentTimeMillis();
        Display.getDefault().asyncExec(() -> {
            this.progressLabel.setText("\uc7ac\uc0dd \uc911: " + f.getName() + (String)(totalMs > 0L ? " (" + EpubAiGoogleTTSViewPart.formatMs(totalMs) + ")" : ""));
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum((int)(totalMs > 0L ? totalMs : 100L));
            this.progressBar.setSelection(0);
        });
        this.cancelProgressTask();
        this.progressTask = this.progressExec.scheduleAtFixedRate(() -> {
            if (this.playingFile == null) {
                return;
            }
            long elapsed = System.currentTimeMillis() - this.playStartMs;
            Display.getDefault().asyncExec(() -> {
                if (this.progressBar.isDisposed() || this.progressLabel.isDisposed()) {
                    return;
                }
                if (this.playTotalMs > 0L) {
                    int sel = (int)Math.min(this.playTotalMs, elapsed);
                    this.progressBar.setSelection(sel);
                    this.progressLabel.setText("\uc7ac\uc0dd \uc911: " + this.playingFile.getName() + "  " + EpubAiGoogleTTSViewPart.formatMs(elapsed) + " / " + EpubAiGoogleTTSViewPart.formatMs(this.playTotalMs));
                } else {
                    int sel = (this.progressBar.getSelection() + 3) % this.progressBar.getMaximum();
                    this.progressBar.setSelection(sel);
                    this.progressLabel.setText("\uc7ac\uc0dd \uc911: " + this.playingFile.getName() + "  " + EpubAiGoogleTTSViewPart.formatMs(elapsed));
                }
            });
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    private void onPlayStopped() {
        this.cancelProgressTask();
        this.playingFile = null;
        this.playTotalMs = 0L;
        this.playStartMs = 0L;
        if (!this.progressBar.isDisposed() && !this.progressLabel.isDisposed()) {
            this.progressLabel.setText("\ub300\uae30 \uc911");
            this.progressBar.setSelection(0);
        }
        this.resetAllPlayButtonsToPlay();
    }

    private void cancelProgressTask() {
        if (this.progressTask != null) {
            this.progressTask.cancel(true);
            this.progressTask = null;
        }
    }

    private static String formatMs(long ms) {
        if (ms < 0L) {
            ms = 0L;
        }
        long s = ms / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        s %= 60L;
        m %= 60L;
        if (h > 0L) {
            return String.format("%d:%02d:%02d", h, m, s);
        }
        return String.format("%02d:%02d", m, s);
    }

    private static String buildFileName(int seq, String text) {
        String base = Mp3Util.safeBase(text, 80);
        return String.format("%03d_%s", seq, base);
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private String getOutputBaseDir() {
        return this.outputDir.toString();
    }

    private String safe(String s) {
        return s.replaceAll("[^a-zA-Z0-9._-]+", "_");
    }

    public static class Mp3Item {
        public final int seq;
        public final String text;
        public final File file;
        private String title;
        private String prompt;
        private String style;
        private String status;
        private String audioPath;
        private Long seed;

        public Mp3Item(int seq, String text, File file) {
            this.seq = seq;
            this.text = text;
            this.file = file;
        }

        public String getTitle() {
            return this.title;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public String getStyle() {
            return this.style;
        }

        public String getStatus() {
            return this.status;
        }

        public String getAudioPath() {
            return this.audioPath;
        }

        public Long getSeed() {
            return this.seed;
        }

        public void setTitle(String v) {
            this.title = v;
        }

        public void setPrompt(String v) {
            this.prompt = v;
        }

        public void setStyle(String v) {
            this.style = v;
        }

        public void setStatus(String v) {
            this.status = v;
        }

        public void setAudioPath(String v) {
            this.audioPath = v;
        }

        public void setSeed(Long v) {
            this.seed = v;
        }
    }
}

