/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.co.goms.epub.solution.dialogs.EpubCheckErrorDialog;
import kr.co.goms.epub.solution.parts.EpubEditorPart;
import kr.co.goms.epub.solution.providers.EpubErrorListLabelProvider;
import kr.co.goms.epub.solution.registry.EditorRegistry;
import kr.co.goms.epub.solution.ui.EpubErrorItem;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class EpubCheckResultPart {
    private Text searchText;
    private TableViewer tableViewer;
    private CLabel cLableHeader;
    private CLabel cLableResult;
    private List<EpubErrorItem> allEpubErrors = new ArrayList<EpubErrorItem>();
    @Inject
    MPart part;
    @Inject
    EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    @Optional
    private MApplication application;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    IEventBroker eventBroker;
    private static final String EDITOR_PART_ID = "kr.co.goms.epub.solution.parts.epubeditorpart";
    @Inject
    private EditorRegistry registry;

    @PostConstruct
    public void createControls(Composite parent) {
        Shell shell = parent.getShell();
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        parent.setLayout((Layout)new GridLayout(1, false));
        String cfr_ignored_0 = (String)this.part.getTransientData().get("title");
        String message = (String)this.part.getTransientData().get("message");
        System.out.println("message : " + message);
        this.searchText = new Text(parent, 2944);
        this.searchText.setMessage("\uba54\uc138\uc9c0\uba85 \uac80\uc0c9...");
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchText.addModifyListener(e -> this.applyFilter(shell));
        this.tableViewer = new TableViewer(parent, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderBackground(backgroundColor);
        String[] titles = new String[]{"No", "Level", "Code", "File", "Line", "Column", "Message"};
        int[] widths = new int[]{40, 70, 80, 200, 50, 60, 500};
        int i = 0;
        while (i < titles.length) {
            int style = 0x1000000;
            if (i == 6) {
                style = 0;
            }
            TableViewerColumn col = new TableViewerColumn(this.tableViewer, style);
            col.getColumn().setText(titles[i]);
            col.getColumn().setWidth(widths[i]);
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EpubErrorListLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SourceViewer sv;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selected = selection.getFirstElement();
                EpubErrorItem epubErrorItem = (EpubErrorItem)selected;
                Shell shell = Display.getDefault().getActiveShell();
                EpubCheckErrorDialog dialog = new EpubCheckErrorDialog(shell, epubErrorItem);
                Color backgroundColor = new Color((Device)shell.getDisplay(), 220, 235, 250);
                dialog.setTitleAreaColor(backgroundColor.getRGB());
                dialog.open();
                String pathStr = epubErrorItem.fileFullPath != null && !epubErrorItem.fileFullPath.isBlank() ? epubErrorItem.fileFullPath : epubErrorItem.file;
                System.out.println("pathStr : " + pathStr);
                System.out.println("getProjectFullPath() : " + EpubBuildUtil.getProjectFullPath());
                String projectPathStr = EpubCheckResultPart.convertToProjectPath(pathStr, EpubBuildUtil.getProjectFullPath());
                IFile iFile = EpubCheckResultPart.this.resolveIFile(projectPathStr);
                if (iFile == null || !iFile.exists()) {
                    MessageDialog.openWarning((Shell)shell, (String)"\ud30c\uc77c \uc5c6\uc74c", (String)("\uc6cc\ud06c\uc2a4\ud398\uc774\uc2a4\uc5d0\uc11c \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n" + projectPathStr));
                    return;
                }
                System.out.println("iFile : " + iFile.getName());
                SourceViewer sourceViewer = sv = EpubCheckResultPart.this.registry != null ? EpubCheckResultPart.this.registry.get(iFile) : null;
                if (sv != null) {
                    System.out.println("sv : \uc874\uc7ac\ud568");
                    EpubCheckResultPart.this.revealOnSourceViewer(sv, epubErrorItem.line, epubErrorItem.column);
                    return;
                }
                System.out.println("sv : \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c");
                EpubCheckResultPart.this.openAndRevealE4(iFile, epubErrorItem.line, epubErrorItem.column);
                Display.getDefault().timerExec(150, () -> {
                    SourceViewer sv2;
                    SourceViewer sourceViewer = sv2 = EpubCheckResultPart.this.registry != null ? EpubCheckResultPart.this.registry.get(iFile) : null;
                    if (sv2 != null) {
                        EpubCheckResultPart.this.revealOnSourceViewer(sv2, epubErrorItem.line, epubErrorItem.column);
                    }
                });
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.cLableHeader = new CLabel(composite, 0);
        this.cLableResult = new CLabel(composite, 0);
        this.loadFromErrorMessage(shell, message);
    }

    private void loadFromErrorMessage(Shell shell, String epubCheckLogText) {
        List<String> rawLines = Arrays.asList(epubCheckLogText.split("\\R"));
        String headerTxt = rawLines.isEmpty() ? "" : rawLines.get(0);
        String resultTxt = rawLines.stream().filter(line -> line.startsWith("\uba54\uc2dc\uc9c0:")).findFirst().orElse("");
        List<String> errorLines = rawLines.stream().filter(line -> line.startsWith("ERROR(") || line.startsWith("FATAL(") || line.startsWith("WARNING(")).collect(Collectors.toList());
        System.out.println("errorLines : " + String.valueOf(errorLines));
        this.allEpubErrors = EpubBuildUtil.parseEpubErrorAll(errorLines);
        System.out.println("allEpubErrors: " + String.valueOf(this.allEpubErrors));
        this.applyFilter(shell);
        this.cLableHeader.setText(headerTxt);
        this.cLableResult.setText(resultTxt);
        System.out.println("headerTxt: " + headerTxt);
        System.out.println("resultTxt: " + resultTxt);
    }

    private void applyFilter(Shell shell) {
        String lowerKeyword = this.searchText.getText().trim().toLowerCase();
        List filtered = this.allEpubErrors.stream().filter(error -> error.getMessage() != null && error.getMessage().toLowerCase().contains(lowerKeyword) || error.getFile() != null && error.getFile().toLowerCase().contains(lowerKeyword)).collect(Collectors.toList());
        this.tableViewer.getTable().removeAll();
        ArrayList<EpubErrorItem> items = new ArrayList<EpubErrorItem>();
        int i = 0;
        while (i < filtered.size()) {
            EpubErrorItem epubErrorItem = (EpubErrorItem)filtered.get(i);
            String level = epubErrorItem.getLevel();
            String code = epubErrorItem.getCode();
            String fileFullPath = epubErrorItem.getFileFullPath();
            int lineNum = epubErrorItem.getLine();
            int colNum = epubErrorItem.getColumn();
            String message = epubErrorItem.getMessage();
            String[] fileInfo = EpubBuildUtil.splitPathAtOEBPS(fileFullPath);
            String cfr_ignored_0 = fileInfo[0];
            String filePath = fileInfo[1];
            items.add(new EpubErrorItem(i + 1, level, code, filePath, lineNum, colNum, message, fileFullPath));
            ++i;
        }
        this.tableViewer.setInput(items);
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void setFocus() {
    }

    private IFile resolveIFile(String filePath) {
        if (filePath == null || filePath.isBlank()) {
            return null;
        }
        Path path = new Path(filePath);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (f != null && f.exists()) {
            return f;
        }
        f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return f != null && f.exists() ? f : null;
    }

    private void revealOnSourceViewer(SourceViewer viewer, int oneBasedLine, int oneBasedColumn) {
        if (viewer == null || viewer.getDocument() == null) {
            return;
        }
        try {
            int offset = this.safeOffset(viewer.getDocument(), oneBasedLine, oneBasedColumn);
            viewer.revealRange(offset, 1);
            viewer.setSelectedRange(offset, 1);
            if (viewer.getTextWidget() != null && !viewer.getTextWidget().isDisposed()) {
                viewer.getTextWidget().setFocus();
            }
        }
        catch (Exception exception) {}
    }

    private int safeOffset(IDocument doc, int oneBasedLine, int oneBasedColumn) throws BadLocationException {
        int lineIdx = Math.max(0, Math.min(oneBasedLine - 1, Math.max(0, doc.getNumberOfLines() - 1)));
        int lineOffset = doc.getLineOffset(lineIdx);
        int lineLen = doc.getLineLength(lineIdx);
        int col = Math.max(1, oneBasedColumn);
        int colOffset = Math.min(col - 1, Math.max(0, lineLen - 1));
        int offset = Math.max(0, Math.min(lineOffset + colOffset, Math.max(0, doc.getLength() - 1)));
        return offset;
    }

    public static String convertToProjectPath(String pathStr, String projectFullPath) {
        String normPath = pathStr.replace("\\", "/");
        String normProject = projectFullPath.replace("\\", "/");
        int idx = normPath.indexOf("/OEBPS/");
        if (idx == -1) {
            return normPath;
        }
        String subPath = normPath.substring(idx);
        return normProject + subPath;
    }

    private void openAndRevealE4(IFile iFile, int line, int column) {
        SourceViewer sv = this.registry.get(iFile);
        if (sv != null) {
            this.revealOnSourceViewer(sv, line, column);
            return;
        }
        String editorId = EDITOR_PART_ID;
        for (MPart part : this.partService.getParts()) {
            boolean ok;
            if (!editorId.equals(part.getElementId())) continue;
            String openedPath = (String)part.getPersistedState().get("filePath");
            if (!iFile.getLocation().toOSString().equals(openedPath)) continue;
            if (part.isDirty() && !(ok = this.partService.savePart(part, true))) {
                return;
            }
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
            Object obj = part.getObject();
            if (obj instanceof EpubEditorPart) {
                EpubEditorPart editor = (EpubEditorPart)obj;
                editor.onFocus();
                editor.highlightAtLineCol(line, column, 1, 3000);
            }
            String absPath = iFile.getLocation().toOSString();
            this.eventBroker.post("gomsbook/preview/refresh", Map.of("file", iFile, "filePath", absPath));
            return;
        }
        MPart editorPart = this.partService.createPart(EDITOR_PART_ID);
        editorPart.setElementId(editorId);
        editorPart.setContributionURI("bundleclass://epubtest03/kr.co.goms.epub.solution.parts.EpubEditorPart");
        editorPart.getPersistedState().put("filePath", iFile.getLocation().toOSString());
        editorPart.getPersistedState().put("persistState", "true");
        editorPart.getTags().add("Editor");
        MPartStack partStack = (MPartStack)this.modelService.find("kr.co.goms.epub.solution.parts.editpartstack", (MUIElement)this.application);
        if (partStack != null) {
            partStack.getChildren().add(editorPart);
            this.partService.showPart(editorPart, EPartService.PartState.ACTIVATE);
        } else {
            System.out.println("PartStack with ID kr.co.goms.epub.solution.parts.editpartstack not found.");
        }
        this.part.getTransientData().put("fileToOpen", iFile);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("line", line);
        params.put("column", column);
        ParameterizedCommand pc = this.commandService.createCommand("kr.co.goms.epub.solution.command.gotohighlight", params);
        this.handlerService.executeHandler(pc);
        Object obj = this.part.getObject();
        if (obj instanceof EpubEditorPart) {
            EpubEditorPart editor = (EpubEditorPart)obj;
            editor.openFile(iFile);
            Display.getDefault().timerExec(120, () -> editor.highlightAtLineCol(line, column, 1, 3000));
        } else {
            Display.getDefault().timerExec(150, () -> {
                Object obj2 = editorPart.getObject();
                if (obj2 instanceof EpubEditorPart) {
                    EpubEditorPart ed2 = (EpubEditorPart)obj2;
                    ed2.openFile(iFile);
                    Display.getDefault().timerExec(120, () -> ed2.highlightAtLineCol(line, column, 1, 3000));
                }
            });
        }
    }
}

