/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.ai.OllamaCaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

@Creatable
public class EpubPreviewPart {
    private Browser previewBrowser;
    private Browser chatBrowser;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void createPart(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.previewBrowser = new Browser(parent, 0);
        this.previewBrowser.setText("<html><body><h3>EPUB Preview</h3><p>\ubbf8\ub9ac\ubcf4\uae30 \uc601\uc5ed\uc785\ub2c8\ub2e4.</p></body></html>");
    }

    public void setPreviewContent(String htmlContent) {
        if (this.previewBrowser != null && !this.previewBrowser.isDisposed()) {
            this.previewBrowser.setText(htmlContent);
        }
    }

    @Inject
    @Optional
    public void onHtmlUpdated(@UIEventTopic(value="epub/html/updated") String htmlContent) {
        System.out.println("EPUB_HTML_UPDATED \ubc1b\ub294 \ubd80\ubd84 \uc2dc\uc791\uc785\ub2c8\ub2e4.");
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        boolean autoUpdate = prefs.getBoolean("urnUuidGeneration", false);
        String projectPath = prefs.get("ebook_project_folder", "");
        String projectName = prefs.get("ebook_project_name", "");
        String projectFullPath = projectPath + "/" + projectName;
        System.out.println("autoUpdate : " + autoUpdate);
        System.out.println("projectPath : " + projectPath);
        System.out.println("projectName : " + projectName);
        System.out.println("projectFullPath : " + projectFullPath);
        if (this.previewBrowser != null && !this.previewBrowser.isDisposed()) {
            String imagePath = new File(projectFullPath, "OEBPS/Images/chapter1.jpg").toURI().toString();
            String resultStyleHtmlContent = this.changeStypePath(projectFullPath, htmlContent = htmlContent.replace("../OEBPS/Images/chapter1.jpg", imagePath));
            String resultHtmlContent = this.changeImagePath(projectFullPath, resultStyleHtmlContent);
            this.previewBrowser.setText(resultHtmlContent != null && !resultHtmlContent.trim().isEmpty() ? resultHtmlContent : "<html><body><p>\ub0b4\uc6a9 \uc5c6\uc74c</p></body></html>");
        }
    }

    private String changeStypePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Styles/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String styleFileName = matcher.group(1);
            File styleFile = new File(projectFullPath, "OEBPS/Styles/" + styleFileName);
            String styleUri = styleFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String changeImagePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Images/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String imageFileName = matcher.group(1);
            File imageFile = new File(projectFullPath, "OEBPS/Images/" + imageFileName);
            String imageUri = imageFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(imageUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    public void setImage(String imageUrl) {
        String html = "<html><body style='margin:0;padding:0;background:#222;text-align:center;'><img src='" + imageUrl + "' style='max-width:100%;max-height:100%;' /></body></html>";
        this.previewBrowser.setText(html);
    }

    @PreDestroy
    public void cleanup() {
    }

    @Inject
    @Optional
    public void onPreviewRefresh(@UIEventTopic(value="gomsbook/preview/refresh") Map<String, Object> data) {
        IFile file = (IFile)data.get("file");
        String path = (String)data.get("path");
        System.out.println("PREVIEW_REFRESH \ubc1b\ub294 \ubd80\ubd84 \uc2dc\uc791\uc785\ub2c8\ub2e4 > file : " + file.getName());
        System.out.println("PREVIEW_REFRESH \ubc1b\ub294 \ubd80\ubd84 \uc2dc\uc791\uc785\ub2c8\ub2e4 > path : " + path);
        String tmpUrl = null;
        if (file != null && file.getLocation() != null) {
            tmpUrl = file.getLocation().toFile().toURI().toString();
        } else if (path != null) {
            tmpUrl = new File(path).toURI().toString();
        }
        if (tmpUrl != null) {
            String finalUrl = tmpUrl;
            Display.getDefault().asyncExec(() -> {
                if (this.previewBrowser != null && !this.previewBrowser.isDisposed()) {
                    this.previewBrowser.setUrl(finalUrl);
                }
            });
        }
    }

    private void loadChatViewerHtml(Browser browser) {
        try {
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)"your.plugin.id"), (IPath)new Path("resources/html/viewer.html"), null);
            browser.setUrl(FileLocator.toFileURL((URL)url).toString());
        }
        catch (IOException e) {
            browser.setText("<p>viewer.html \ub85c\ub4dc \uc2e4\ud328: " + e.getMessage() + "</p>");
        }
    }

    private void initJsBridge(Browser browser) {
        new BrowserFunction(browser, "sendToOllamaWithTemplate"){

            public Object function(Object[] args) {
                String userMsg = args.length > 0 ? String.valueOf(args[0]) : "";
                String template = args.length > 1 ? String.valueOf(args[1]) : "classic";
                EpubPreviewPart.this.handlePromptWithTemplate(userMsg, template);
                return null;
            }
        };
        this.injectTemplateList(browser);
    }

    private void handlePromptWithTemplate(String userInput, String templateName) {
        new Thread(() -> {
            String templateInstruction = this.readTemplatePrompt(templateName);
            String fullPrompt = userInput + "\n\n" + templateInstruction;
            String response = OllamaCaller.sendPrompt(fullPrompt);
            File saved = this.saveGeneratedXhtml(response);
            Display.getDefault().asyncExec(() -> {
                this.chatBrowser.evaluate("showAIResponse(" + this.toJsString(response) + ");");
                if (saved != null) {
                    this.chatBrowser.evaluate("showAIResponse(" + this.toJsString("\u2705 \uc800\uc7a5: " + saved.getAbsolutePath()) + ");");
                }
            });
        }).start();
    }

    private String readTemplatePrompt(String templateName) {
        File f = new File(System.getProperty("user.home"), "GomsBookEditor/templates/" + templateName + "/template.txt");
        try {
            return f.exists() ? Files.readString(f.toPath(), StandardCharsets.UTF_8) : templateName + " \uc2a4\ud0c0\uc77c\ub85c XHTML\uc744 \uc791\uc131\ud574\uc918.";
        }
        catch (IOException iOException) {
            return templateName + " \uc2a4\ud0c0\uc77c\ub85c XHTML\uc744 \uc791\uc131\ud574\uc918.";
        }
    }

    private File saveGeneratedXhtml(String xhtml) {
        try {
            File dir = new File(System.getProperty("user.home"), "GomsBookEditor/generated");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String ts = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            File file = new File(dir, "chapter-" + ts + ".xhtml");
            Files.writeString(file.toPath(), (CharSequence)xhtml, StandardCharsets.UTF_8, new OpenOption[0]);
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void injectTemplateList(Browser browser) {
        File dir = new File(System.getProperty("user.home"), "GomsBookEditor/templates");
        File[] folders = dir.listFiles(File::isDirectory);
        if (folders == null || folders.length == 0) {
            return;
        }
        StringBuilder js = new StringBuilder("window.templateList=[");
        File[] fileArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            js.append("\"").append(f.getName()).append("\",");
            ++n2;
        }
        if (folders.length > 0) {
            js.setLength(js.length() - 1);
        }
        js.append("]; if(window.renderTemplateButtons){renderTemplateButtons();}");
        browser.evaluate(js.toString());
    }

    private String toJsString(String s) {
        if (s == null) {
            s = "";
        }
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "") + "\"";
    }
}

